/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.bebop.demo.workflow;

import com.arsdigita.bebop.Form;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SingleSelectionModel;
import com.arsdigita.bebop.ToggleLink;
import com.arsdigita.bebop.demo.workflow.Process;
import com.arsdigita.bebop.demo.workflow.SampleProcesses;
import com.arsdigita.bebop.event.FormInitListener;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.event.FormSubmissionListener;
import com.arsdigita.bebop.form.Hidden;
import com.arsdigita.bebop.form.Submit;
import com.arsdigita.bebop.form.TextArea;
import com.arsdigita.bebop.form.TextField;
import com.arsdigita.bebop.parameters.NotNullValidationListener;
import com.arsdigita.bebop.util.GlobalizationUtil;

public class AddProcess
extends Form
implements FormProcessListener,
FormInitListener,
FormSubmissionListener {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/bebop/demo/workflow/AddProcess.java#8 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private SingleSelectionModel m_processes;
    private ToggleLink m_addLink;
    private Hidden m_id;
    private TextField m_title;
    private TextArea m_descr;
    private Submit m_save;
    private Submit m_cancel;

    public AddProcess(SingleSelectionModel m, ToggleLink addLink) {
        super("addProcess");
        this.m_processes = m;
        this.m_addLink = addLink;
        this.addInitListener(this);
        this.addProcessListener(this);
        this.addSubmissionListener(this);
        this.m_id = new Hidden("id");
        this.add(this.m_id);
        this.m_id.addValidationListener(new NotNullValidationListener());
        this.add(new Label(GlobalizationUtil.globalize("bebop.demo.workflow.process_name")));
        this.m_title = new TextField("title");
        this.m_title.addValidationListener(new NotNullValidationListener());
        this.add(this.m_title);
        this.add(new Label(GlobalizationUtil.globalize("bebop.demo.workflow.short_description")));
        this.m_descr = new TextArea("desc");
        this.m_descr.setRows(3);
        this.m_descr.setCols(40);
        this.add(this.m_descr);
        this.m_save = new Submit("save", "Save");
        this.m_cancel = new Submit("cancel", "Cancel");
        this.add(this.m_save, 1);
        this.add(this.m_cancel, 4);
    }

    public void process(FormSectionEvent e) throws FormProcessException {
        PageState s = e.getPageState();
        if (this.m_save.isSelected(s)) {
            String key = (String)this.m_id.getValue(s);
            String title = (String)this.m_title.getValue(s);
            Process p = new Process(key, title);
            p.setDescription((String)this.m_descr.getValue(s));
            SampleProcesses.getInstance().add(p);
            this.m_processes.setSelectedKey(s, key);
        }
    }

    public void submitted(FormSectionEvent e) throws FormProcessException {
        PageState s = e.getPageState();
        if (this.m_cancel.isSelected(s)) {
            this.m_addLink.setSelected(s, false);
            throw new FormProcessException("Cancel hit");
        }
    }

    public void init(FormSectionEvent e) {
        this.m_id.setValue(e.getPageState(), Process.getNextKey());
    }
}

