/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.bebop;

import com.arsdigita.bebop.BoxPanel;
import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.ComponentSelectionModel;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SimpleComponent;
import com.arsdigita.bebop.SplitPanel;
import com.arsdigita.bebop.util.GlobalizationUtil;
import com.arsdigita.util.Assert;
import com.arsdigita.xml.Element;

public class SplitWizard
extends SplitPanel {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/bebop/SplitWizard.java#7 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private ComponentSelectionModel m_sel;
    private Component m_defaultPane;
    private Component m_selector;

    public SplitWizard(Component header, ComponentSelectionModel model, Component defaultPane) {
        this(model, defaultPane);
        this.setHeader(header);
    }

    public SplitWizard(ComponentSelectionModel model, Component defaultPane) {
        this.m_defaultPane = defaultPane;
        if (this.m_defaultPane != null) {
            super.add(this.m_defaultPane);
        }
        this.m_sel = model;
        this.setRightComponent(new WizardPaneSelector());
        this.setClassAttr("wizard");
    }

    public SplitWizard(ComponentSelectionModel model) {
        this(model, (Component)new Label(GlobalizationUtil.globalize("bebop.please_select_choice_from_the_list_on_the_left")));
    }

    public SplitWizard(Component defaultPane) {
        this((ComponentSelectionModel)null, defaultPane);
    }

    public SplitWizard() {
        this((ComponentSelectionModel)null, (Component)new Label(GlobalizationUtil.globalize("bebop.please_select_choice_from_the_list_on_the_left")));
    }

    public void setSelector(Component selector) {
        this.setLeftComponent(selector);
        this.m_selector = selector;
    }

    public final Component getSelector() {
        return this.m_selector;
    }

    public void setSelectionModel(ComponentSelectionModel model) {
        Assert.assertNotLocked(this);
        this.m_sel = model;
    }

    public final ComponentSelectionModel getSelectionModel() {
        return this.m_sel;
    }

    public void setDefaultPane(Component c) {
        Assert.assertNotLocked(this);
        if (this.m_defaultPane != null) {
            throw new IllegalStateException("Default pane has already been set");
        }
        if (!super.contains(c)) {
            super.add(c);
        }
        this.m_defaultPane = c;
    }

    public final Component getDefaultPane() {
        return this.m_defaultPane;
    }

    public static class HeaderPanel
    extends BoxPanel {
        private Label m_label;
        private Component m_child;

        public HeaderPanel(String label, Component c) {
            super(2);
            this.setBorder(false);
            this.m_label = new Label(label);
            this.m_label.setFontWeight("b");
            this.add(this.m_label);
            this.m_child = c;
            this.add(this.m_child);
        }

        public final Label getLabel() {
            return this.m_label;
        }

        public final Component getChild() {
            return this.m_child;
        }
    }

    private class WizardPaneSelector
    extends SimpleComponent {
        public Component getVisibleComponent(PageState state) {
            if (!SplitWizard.this.m_sel.isSelected(state)) {
                return SplitWizard.this.m_defaultPane;
            }
            return SplitWizard.this.m_sel.getComponent(state);
        }

        public void generateXML(PageState state, Element parent) {
            if (!this.isVisible(state)) {
                return;
            }
            Element cell = parent.newChildElement("bebop:cell", "http://www.arsdigita.com/bebop/1.0");
            this.exportAttributes(cell);
            this.getVisibleComponent(state).generateXML(state, cell);
        }
    }
}

