/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.bebop;

import com.arsdigita.bebop.FormData;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.FormValidationException;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.event.EventListenerList;
import com.arsdigita.bebop.event.FormInitListener;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.event.FormSubmissionListener;
import com.arsdigita.bebop.event.FormValidationListener;
import com.arsdigita.bebop.parameters.ParameterData;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.developersupport.DeveloperSupport;
import com.arsdigita.util.Assert;
import com.arsdigita.util.Lockable;
import com.arsdigita.util.URLRewriter;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;

public class FormModel
implements Lockable {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/bebop/FormModel.java#12 $$Author: dennis $$DateTime: 2004/04/07 16:07:11 $";
    private static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$bebop$FormModel == null ? (class$com$arsdigita$bebop$FormModel = FormModel.class$("com.arsdigita.bebop.FormModel")) : class$com$arsdigita$bebop$FormModel));
    private static final String MAGIC_TAG_PREFIX = "form.";
    private String m_name = null;
    private List m_parameterModels = null;
    private List m_parametersToExclude = null;
    private boolean m_locked = false;
    private boolean m_defaultOverridesNull;
    protected EventListenerList m_listenerList;
    static /* synthetic */ Class class$com$arsdigita$bebop$FormModel;
    static /* synthetic */ Class class$com$arsdigita$bebop$event$FormSubmissionListener;
    static /* synthetic */ Class class$com$arsdigita$bebop$event$FormValidationListener;
    static /* synthetic */ Class class$com$arsdigita$bebop$event$FormInitListener;
    static /* synthetic */ Class class$com$arsdigita$bebop$event$FormProcessListener;

    public FormModel(String name) {
        this(name, false);
    }

    FormModel(String name, boolean defaultOverridesNull) {
        Assert.assertNotNull(name, "Name");
        this.m_parameterModels = new LinkedList();
        this.m_parametersToExclude = new LinkedList();
        this.m_listenerList = new EventListenerList();
        this.m_name = name;
        this.m_defaultOverridesNull = defaultOverridesNull;
        this.m_parameterModels.addAll(URLRewriter.getGlobalModels());
    }

    public final String getName() {
        return this.m_name;
    }

    public final void setName(String name) {
        this.m_name = name;
    }

    String getMagicTagName() {
        return MAGIC_TAG_PREFIX + this.getName();
    }

    public final void addFormParam(ParameterModel parameter) {
        Assert.assertNotNull(parameter, "Parameter");
        Assert.assertNotLocked(this);
        parameter.setDefaultOverridesNull(this.m_defaultOverridesNull);
        this.m_parameterModels.add(parameter);
    }

    public final void excludeFormParameterFromExport(ParameterModel parameter) {
        Assert.assertNotNull(parameter, "Parameter");
        Assert.assertNotLocked(this);
        this.m_parametersToExclude.add(parameter);
    }

    public final boolean containsFormParam(ParameterModel p) {
        Assert.assertNotNull(p, "Parameter");
        return this.m_parameterModels.contains(p);
    }

    public final Iterator getParameters() {
        return this.m_parameterModels.iterator();
    }

    public final Iterator getParametersToExclude() {
        return this.m_parametersToExclude.iterator();
    }

    public void addSubmissionListener(FormSubmissionListener listener) {
        Assert.assertNotNull(listener, "Submission Listener");
        this.m_listenerList.add(class$com$arsdigita$bebop$event$FormSubmissionListener == null ? (class$com$arsdigita$bebop$event$FormSubmissionListener = FormModel.class$("com.arsdigita.bebop.event.FormSubmissionListener")) : class$com$arsdigita$bebop$event$FormSubmissionListener, listener);
    }

    public void addValidationListener(FormValidationListener listener) {
        Assert.assertNotNull(listener, "FormValidationListener");
        Assert.assertNotLocked(this);
        this.m_listenerList.add(class$com$arsdigita$bebop$event$FormValidationListener == null ? (class$com$arsdigita$bebop$event$FormValidationListener = FormModel.class$("com.arsdigita.bebop.event.FormValidationListener")) : class$com$arsdigita$bebop$event$FormValidationListener, listener);
    }

    public void addInitListener(FormInitListener listener) {
        Assert.assertNotNull(listener, "FormInitListener");
        Assert.assertNotLocked(this);
        this.m_listenerList.add(class$com$arsdigita$bebop$event$FormInitListener == null ? (class$com$arsdigita$bebop$event$FormInitListener = FormModel.class$("com.arsdigita.bebop.event.FormInitListener")) : class$com$arsdigita$bebop$event$FormInitListener, listener);
    }

    public void addProcessListener(FormProcessListener listener) {
        Assert.assertNotNull(listener, "FormProcessListener");
        Assert.assertNotLocked(this);
        this.m_listenerList.add(class$com$arsdigita$bebop$event$FormProcessListener == null ? (class$com$arsdigita$bebop$event$FormProcessListener = FormModel.class$("com.arsdigita.bebop.event.FormProcessListener")) : class$com$arsdigita$bebop$event$FormProcessListener, listener);
    }

    public FormData process(PageState state) throws FormProcessException {
        Assert.assertLocked(this);
        boolean isSubmission = state.getRequest().getParameter(this.getMagicTagName()) != null;
        return this.process(state, isSubmission);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FormData process(PageState state, boolean isSubmission) throws FormProcessException {
        Assert.assertLocked(this);
        FormData data = new FormData(this, state.getRequest(), isSubmission);
        try {
            DeveloperSupport.startStage("Bebop Form Model Process");
            this.process(state, data);
        }
        finally {
            DeveloperSupport.startStage("Bebop Form Model Process");
        }
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void process(PageState state, FormData data) throws FormProcessException {
        s_log.debug((Object)"Processing the form model");
        FormSectionEvent e = new FormSectionEvent(this, state, data);
        if (data.isSubmission()) {
            s_log.debug((Object)"The request is a form submission; running submission listeners");
            try {
                DeveloperSupport.startStage("Bebop Submission");
                this.fireSubmitted(e);
            }
            catch (FormProcessException fpe) {
                s_log.debug((Object)"A FormProcessException was thrown while firing submit; aborting further processing");
                return;
            }
            finally {
                DeveloperSupport.endStage("Bebop Submission");
            }
            try {
                DeveloperSupport.startStage("Bebop Validation");
                s_log.debug((Object)"Validating parameters");
                this.fireParameterValidation(e);
                s_log.debug((Object)"Validating form");
                this.fireFormValidation(e);
            }
            finally {
                DeveloperSupport.endStage("Bebop Validation");
            }
            if (data.isValid()) {
                s_log.debug((Object)"The form data is valid; running process listeners");
                try {
                    DeveloperSupport.startStage("Bebop Form Process");
                    this.fireFormProcess(e);
                }
                catch (FormValidationException fve) {
                    s_log.debug((Object)"A FormValidationException was thrown while processing the form; storing the error");
                    if (fve.getName() != null) {
                        data.addError(fve.getName(), fve.getMessage());
                    }
                    data.addError(fve.getMessage());
                }
                finally {
                    DeveloperSupport.endStage("Bebop Form Process");
                }
            } else {
                s_log.debug((Object)"The form data was not valid; this form will not run its process listeners");
            }
        } else {
            s_log.debug((Object)"The request is not a form submission; running init listeners");
            try {
                DeveloperSupport.startStage("Bebop Form Init");
                this.fireFormInit(e);
            }
            catch (FormValidationException fve) {
                s_log.debug((Object)"A FormValidationException was thrown while initializing the form; storing the error");
                if (fve.getName() == null) {
                    data.addError(fve.getMessage());
                } else {
                    data.addError(fve.getName(), fve.getMessage());
                }
            }
            catch (FormProcessException fpe) {
                s_log.debug((Object)"A FormProcessException was thrown while initializing the form; storing the error", (Throwable)((Object)fpe));
                data.addError("Initialization Aborted: " + fpe.getMessages());
            }
            finally {
                DeveloperSupport.endStage("Bebop Form Process");
            }
        }
    }

    protected void fireSubmitted(FormSectionEvent e) throws FormProcessException {
        Assert.assertNotNull(e.getFormData(), "FormData");
        Assert.assertLocked(this);
        FormProcessException delayedException = null;
        Iterator i = this.m_listenerList.getListenerIterator(class$com$arsdigita$bebop$event$FormSubmissionListener == null ? (class$com$arsdigita$bebop$event$FormSubmissionListener = FormModel.class$("com.arsdigita.bebop.event.FormSubmissionListener")) : class$com$arsdigita$bebop$event$FormSubmissionListener);
        while (i.hasNext()) {
            try {
                ((FormSubmissionListener)i.next()).submitted(e);
            }
            catch (FormProcessException ex) {
                delayedException = ex;
            }
        }
        if (delayedException != null) {
            throw delayedException;
        }
    }

    protected void fireFormInit(FormSectionEvent e) throws FormProcessException {
        Assert.assertNotNull(e.getFormData(), "FormData");
        Assert.assertLocked(this);
        Iterator i = this.m_listenerList.getListenerIterator(class$com$arsdigita$bebop$event$FormInitListener == null ? (class$com$arsdigita$bebop$event$FormInitListener = FormModel.class$("com.arsdigita.bebop.event.FormInitListener")) : class$com$arsdigita$bebop$event$FormInitListener);
        while (i.hasNext()) {
            ((FormInitListener)i.next()).init(e);
        }
    }

    protected void fireParameterValidation(FormSectionEvent e) {
        FormData data = e.getFormData();
        Assert.assertNotNull(data, "FormData");
        Iterator parameters = this.getParameters();
        while (parameters.hasNext()) {
            ParameterModel parameterModel = (ParameterModel)parameters.next();
            ParameterData parameterData = data.getParameter(parameterModel.getName());
            try {
                parameterData.validate();
                if (parameterData.isValid()) continue;
                data.invalidate();
            }
            catch (FormProcessException fpe) {
                data.addError("Processing Listener Error: " + fpe.getMessage());
            }
        }
    }

    private void fireFormValidation(FormSectionEvent e) {
        FormData data = e.getFormData();
        Assert.assertNotNull(data, "FormData");
        Iterator i = this.m_listenerList.getListenerIterator(class$com$arsdigita$bebop$event$FormValidationListener == null ? (class$com$arsdigita$bebop$event$FormValidationListener = FormModel.class$("com.arsdigita.bebop.event.FormValidationListener")) : class$com$arsdigita$bebop$event$FormValidationListener);
        while (i.hasNext()) {
            try {
                ((FormValidationListener)i.next()).validate(e);
            }
            catch (FormProcessException fpe) {
                data.addError(fpe.getMessage());
            }
        }
    }

    private void fireFormProcess(FormSectionEvent e) throws FormProcessException {
        Assert.assertNotNull(e.getFormData(), "FormData");
        if (!e.getFormData().isValid()) {
            throw new IllegalStateException("Request data must be valid prior to running processing filters.");
        }
        Iterator i = this.m_listenerList.getListenerIterator(class$com$arsdigita$bebop$event$FormProcessListener == null ? (class$com$arsdigita$bebop$event$FormProcessListener = FormModel.class$("com.arsdigita.bebop.event.FormProcessListener")) : class$com$arsdigita$bebop$event$FormProcessListener);
        while (i.hasNext()) {
            ((FormProcessListener)i.next()).process(e);
        }
    }

    void validate(PageState state, FormData data) {
        Assert.assertNotNull(data, "FormData");
        if (!data.isTransformed()) {
            throw new IllegalStateException("Request data must be transformed prior to running validation filters.");
        }
        this.fireParameterValidation(new FormSectionEvent(this, state, data));
        this.fireFormValidation(new FormSectionEvent(this, state, data));
    }

    void mergeModel(FormModel m) {
        Assert.assertNotLocked(this);
        Assert.assertNotNull(m, "FormSection's FormModel");
        this.m_parameterModels.addAll(m.m_parameterModels);
        this.m_listenerList.addAll(m.m_listenerList);
    }

    public void lock() {
        Iterator i = this.getParameters();
        while (i.hasNext()) {
            ((ParameterModel)i.next()).lock();
        }
        this.m_locked = true;
    }

    public final boolean isLocked() {
        return this.m_locked;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

