/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.auditing;

import com.arsdigita.auditing.Audited;
import com.arsdigita.auditing.AuditingSaveInfo;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.kernel.ACSObject;
import com.arsdigita.kernel.User;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.DataQuery;
import com.arsdigita.persistence.Filter;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.SessionManager;
import java.math.BigDecimal;
import java.util.Date;
import org.apache.log4j.Logger;

public class BasicAuditTrail
extends DomainObject
implements Audited {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/auditing/BasicAuditTrail.java#13 $";
    private static final Logger s_cat = Logger.getLogger((String)(class$com$arsdigita$auditing$BasicAuditTrail == null ? (class$com$arsdigita$auditing$BasicAuditTrail = BasicAuditTrail.class$("com.arsdigita.auditing.BasicAuditTrail")) : class$com$arsdigita$auditing$BasicAuditTrail).getName());
    private static final String m_baseDataObjectType = "com.arsdigita.auditing.BasicAuditTrail";
    private static final String RETRIEVEQUERY = "com.arsdigita.auditing.auditTrailForACSObject";
    private static final String CREATION_USER = "creationUser";
    private static final String CREATION_DATE = "creationDate";
    private static final String CREATION_IP = "creationIP";
    private static final String LAST_MODIFIED_USER = "lastModifiedUser";
    private static final String LAST_MODIFIED_DATE = "lastModifiedDate";
    private static final String LAST_MODIFIED_IP = "lastModifiedIP";
    static /* synthetic */ Class class$com$arsdigita$auditing$BasicAuditTrail;

    protected String getBaseDataObjectType() {
        return m_baseDataObjectType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BasicAuditTrail retrieveForACSObject(ACSObject aobj) {
        if (!aobj.isNew()) {
            DataQuery query = SessionManager.getSession().retrieveQuery(RETRIEVEQUERY);
            Filter f = query.addFilter("id=:id");
            f.set("id", aobj.getOID().get("id"));
            try {
                if (query.next()) {
                    BasicAuditTrail basicAuditTrail = new BasicAuditTrail((BigDecimal)query.get("id"));
                    return basicAuditTrail;
                }
            }
            catch (DataObjectNotFoundException e) {
                s_cat.debug((Object)("retrieveForObject: couldn't find audit trail, creating new one." + e));
            }
            finally {
                query.close();
            }
        }
        return new BasicAuditTrail();
    }

    public BasicAuditTrail(DataObject object) {
        super(object);
    }

    public BasicAuditTrail() {
        super(m_baseDataObjectType);
    }

    private BasicAuditTrail(BigDecimal id) throws DataObjectNotFoundException {
        super(new OID(m_baseDataObjectType, (Object)id));
    }

    public User getCreationUser() {
        Object o = this.get(CREATION_USER);
        if (o == null) {
            return null;
        }
        return User.retrieve((DataObject)o);
    }

    public Date getCreationDate() {
        return (Date)this.get(CREATION_DATE);
    }

    public String getCreationIP() {
        return (String)this.get(CREATION_IP);
    }

    public User getLastModifiedUser() {
        Object o = this.get(LAST_MODIFIED_USER);
        if (o == null) {
            return null;
        }
        return User.retrieve((DataObject)o);
    }

    public Date getLastModifiedDate() {
        return (Date)this.get(LAST_MODIFIED_DATE);
    }

    public String getLastModifiedIP() {
        return (String)this.get(LAST_MODIFIED_IP);
    }

    void setID(BigDecimal id) {
        if (!this.isNew()) {
            throw new RuntimeException("Can't set the id for an existing object");
        }
        this.set("id", id);
    }

    void setLastModifiedInfo(User user, Date date, String ip_addr) {
        this.setAssociation(LAST_MODIFIED_USER, user);
        this.set(LAST_MODIFIED_DATE, date);
        this.set(LAST_MODIFIED_IP, ip_addr);
    }

    void setCreationInfo(User user, Date date, String ip_addr) {
        this.setAssociation(CREATION_USER, user);
        this.set(CREATION_DATE, date);
        this.set(CREATION_IP, ip_addr);
        this.setLastModifiedInfo(user, date, ip_addr);
    }

    void setCreationInfo(AuditingSaveInfo info) {
        this.setCreationInfo(info.getSaveUser(), info.getSaveDate(), info.getSaveIP());
    }

    void setLastModifiedInfo(AuditingSaveInfo info) {
        this.setLastModifiedInfo(info.getSaveUser(), info.getSaveDate(), info.getSaveIP());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

