/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.BitSet;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.HitCollector;
import org.apache.lucene.search.HitQueue;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.store.Directory;

public final class IndexSearcher
extends Searcher {
    IndexReader reader;

    public IndexSearcher(String string) throws IOException {
        this(IndexReader.open(string));
    }

    public IndexSearcher(Directory directory) throws IOException {
        this(IndexReader.open(directory));
    }

    public IndexSearcher(IndexReader indexReader) {
        this.reader = indexReader;
    }

    public final void close() throws IOException {
        this.reader.close();
    }

    final int docFreq(Term term) throws IOException {
        return this.reader.docFreq(term);
    }

    public final Document doc(int n) throws IOException {
        return this.reader.document(n);
    }

    final int maxDoc() throws IOException {
        return this.reader.maxDoc();
    }

    final TopDocs search(Query query, Filter filter, final int n) throws IOException {
        Scorer scorer = Query.scorer(query, this, this.reader);
        if (scorer == null) {
            return new TopDocs(0, new ScoreDoc[0]);
        }
        final BitSet bitSet = filter != null ? filter.bits(this.reader) : null;
        final HitQueue hitQueue = new HitQueue(n);
        final int[] nArray = new int[1];
        scorer.score(new HitCollector(){
            private float minScore = 0.0f;

            public final void collect(int n2, float f) {
                if (f > 0.0f && (bitSet == null || bitSet.get(n2))) {
                    nArray[0] = nArray[0] + 1;
                    if (f >= this.minScore) {
                        hitQueue.put(new ScoreDoc(n2, f));
                        if (hitQueue.size() > n) {
                            hitQueue.pop();
                            this.minScore = ((ScoreDoc)hitQueue.top()).score;
                        }
                    }
                }
            }
        }, this.reader.maxDoc());
        ScoreDoc[] scoreDocArray = new ScoreDoc[hitQueue.size()];
        int n2 = hitQueue.size() - 1;
        while (n2 >= 0) {
            scoreDocArray[n2] = (ScoreDoc)hitQueue.pop();
            --n2;
        }
        return new TopDocs(nArray[0], scoreDocArray);
    }

    public final void search(Query query, Filter filter, HitCollector hitCollector) throws IOException {
        Object object;
        HitCollector hitCollector2 = hitCollector;
        if (filter != null) {
            object = filter.bits(this.reader);
            hitCollector2 = new HitCollector((BitSet)object, hitCollector){
                private final /* synthetic */ BitSet val$bits;
                private final /* synthetic */ HitCollector val$results;
                {
                    this.val$bits = bitSet;
                    this.val$results = hitCollector;
                }

                public final void collect(int n, float f) {
                    if (this.val$bits.get(n)) {
                        this.val$results.collect(n, f);
                    }
                }
            };
        }
        if ((object = Query.scorer(query, this, this.reader)) == null) {
            return;
        }
        ((Scorer)object).score(hitCollector2, this.reader.maxDoc());
    }
}

