/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.xsltc.runtime;

import java.text.DecimalFormat;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.ResourceBundle;
import org.apache.xalan.xsltc.DOM;
import org.apache.xalan.xsltc.NodeIterator;
import org.apache.xalan.xsltc.TransletException;
import org.apache.xalan.xsltc.TransletOutputHandler;
import org.apache.xalan.xsltc.dom.DOMAdapter;
import org.apache.xalan.xsltc.dom.SingletonIterator;
import org.apache.xalan.xsltc.runtime.Node;
import org.apache.xalan.xsltc.runtime.Operators;

public final class BasisLibrary
implements Operators {
    private static final String EMPTYSTRING = "";
    private static double lowerBounds = 0.001;
    private static double upperBounds = 1.0E7;
    private static DecimalFormat defaultFormatter;
    private static String defaultPattern;
    private static FieldPosition _fieldPosition;
    private static char[] _characterArray;
    private static int prefixIndex;
    public static final int RUN_TIME_INTERNAL_ERR = 0;
    public static final int RUN_TIME_COPY_ERR = 1;
    public static final int DATA_CONVERSION_ERR = 2;
    public static final int EXTERNAL_FUNC_ERR = 3;
    public static final int EQUALITY_EXPR_ERR = 4;
    public static final int INVALID_ARGUMENT_ERR = 5;
    public static final int FORMAT_NUMBER_ERR = 6;
    public static final int ITERATOR_CLONE_ERR = 7;
    public static final int AXIS_SUPPORT_ERR = 8;
    public static final int TYPED_AXIS_SUPPORT_ERR = 9;
    public static final int STRAY_ATTRIBUTE_ERR = 10;
    public static final int STRAY_NAMESPACE_ERR = 11;
    public static final int NAMESPACE_PREFIX_ERR = 12;
    public static final int DOM_ADAPTER_INIT_ERR = 13;
    private static String[] _errorMessages;
    public static final String ERROR_MESSAGES_KEY = "error-messages";

    public static int countF(NodeIterator iterator) {
        return iterator.getLast();
    }

    /*
     * WARNING - void declaration
     */
    public static double sumF(NodeIterator iterator, DOM dom) {
        try {
            int node;
            double result = 0.0;
            while ((node = iterator.next()) != 0) {
                void var4_4;
                result += Double.parseDouble(dom.getNodeValue((int)var4_4));
            }
            return result;
        }
        catch (NumberFormatException e) {
            return Double.NaN;
        }
    }

    public static String stringF(int node, DOM dom) {
        return dom.getNodeValue(node);
    }

    public static String stringF(Object obj, DOM dom) {
        if (obj instanceof NodeIterator) {
            return dom.getNodeValue(((NodeIterator)obj).reset().next());
        }
        if (obj instanceof Node) {
            return dom.getNodeValue(((Node)obj).node);
        }
        if (obj instanceof DOM) {
            return ((DOM)obj).getStringValue();
        }
        return obj.toString();
    }

    public static String stringF(Object obj, int node, DOM dom) {
        if (obj instanceof NodeIterator) {
            return dom.getNodeValue(((NodeIterator)obj).reset().next());
        }
        if (obj instanceof Node) {
            return dom.getNodeValue(((Node)obj).node);
        }
        if (obj instanceof DOM) {
            return ((DOM)obj).getStringValue();
        }
        if (obj instanceof Double) {
            int length;
            Double d = (Double)obj;
            String result = d.toString();
            if (result.charAt((length = result.length()) - 2) == '.' && result.charAt(length - 1) == '0') {
                return result.substring(0, length - 2);
            }
            return result;
        }
        if (obj != null) {
            return obj.toString();
        }
        return BasisLibrary.stringF(node, dom);
    }

    public static double numberF(int node, DOM dom) {
        return BasisLibrary.stringToReal(dom.getNodeValue(node));
    }

    public static double numberF(Object obj, DOM dom) {
        if (obj instanceof Double) {
            return (Double)obj;
        }
        if (obj instanceof Integer) {
            return ((Integer)obj).doubleValue();
        }
        if (obj instanceof Boolean) {
            return (Boolean)obj != false ? 1.0 : 0.0;
        }
        if (obj instanceof String) {
            return BasisLibrary.stringToReal((String)obj);
        }
        if (obj instanceof NodeIterator) {
            NodeIterator iter = (NodeIterator)obj;
            return BasisLibrary.stringToReal(dom.getNodeValue(iter.reset().next()));
        }
        if (obj instanceof Node) {
            return BasisLibrary.stringToReal(dom.getNodeValue(((Node)obj).node));
        }
        if (obj instanceof DOM) {
            return BasisLibrary.stringToReal(((DOM)obj).getStringValue());
        }
        String className = obj.getClass().getName();
        BasisLibrary.runTimeError(5, className, "number()");
        return 0.0;
    }

    public static boolean booleanF(Object obj) {
        if (obj instanceof Double) {
            double temp = (Double)obj;
            return temp != 0.0 && !Double.isNaN(temp);
        }
        if (obj instanceof Integer) {
            return ((Integer)obj).doubleValue() != 0.0;
        }
        if (obj instanceof Boolean) {
            return (Boolean)obj;
        }
        if (obj instanceof String) {
            return !((String)obj).equals(EMPTYSTRING);
        }
        if (obj instanceof NodeIterator) {
            NodeIterator iter = (NodeIterator)obj;
            return iter.reset().next() != 0;
        }
        if (obj instanceof Node) {
            return true;
        }
        if (obj instanceof DOM) {
            String temp = ((DOM)obj).getStringValue();
            return !temp.equals(EMPTYSTRING);
        }
        String className = obj.getClass().getName();
        BasisLibrary.runTimeError(5, className, "number()");
        return false;
    }

    public static String substringF(String value, double start) {
        try {
            int strlen = value.length();
            int istart = (int)Math.round(start) - 1;
            if (Double.isNaN(start)) {
                return EMPTYSTRING;
            }
            if (istart > strlen) {
                return EMPTYSTRING;
            }
            if (istart < 1) {
                istart = 0;
            }
            return value.substring(istart);
        }
        catch (IndexOutOfBoundsException e) {
            BasisLibrary.runTimeError(0, "substring()");
            return null;
        }
    }

    public static String substringF(String value, double start, double length) {
        try {
            int strlen = value.length();
            int istart = (int)Math.round(start) - 1;
            int isum = istart + (int)Math.round(length);
            if (Double.isInfinite(length)) {
                isum = Integer.MAX_VALUE;
            }
            if (Double.isNaN(start) || Double.isNaN(length)) {
                return EMPTYSTRING;
            }
            if (Double.isInfinite(start)) {
                return EMPTYSTRING;
            }
            if (istart > strlen) {
                return EMPTYSTRING;
            }
            if (isum < 0) {
                return EMPTYSTRING;
            }
            if (istart < 0) {
                istart = 0;
            }
            if (isum > strlen) {
                return value.substring(istart);
            }
            return value.substring(istart, isum);
        }
        catch (IndexOutOfBoundsException e) {
            BasisLibrary.runTimeError(0, "substring()");
            return null;
        }
    }

    public static String substring_afterF(String value, String substring) {
        int index = value.indexOf(substring);
        if (index >= 0) {
            return value.substring(index + substring.length());
        }
        return EMPTYSTRING;
    }

    public static String substring_beforeF(String value, String substring) {
        int index = value.indexOf(substring);
        if (index >= 0) {
            return value.substring(0, index);
        }
        return EMPTYSTRING;
    }

    public static String translateF(String value, String from, String to) {
        int tol = to.length();
        int froml = from.length();
        int valuel = value.length();
        StringBuffer result = new StringBuffer();
        int i = 0;
        while (i < valuel) {
            char ch = value.charAt(i);
            int j = 0;
            while (j < froml) {
                if (ch == from.charAt(j)) {
                    if (j >= tol) break;
                    result.append(to.charAt(j));
                    break;
                }
                ++j;
            }
            if (j == froml) {
                result.append(ch);
            }
            ++i;
        }
        return result.toString();
    }

    public static String normalize_spaceF(int node, DOM dom) {
        return BasisLibrary.normalize_spaceF(dom.getNodeValue(node));
    }

    /*
     * Unable to fully structure code
     */
    public static String normalize_spaceF(String value) {
        i = 0;
        n = value.length();
        result = new StringBuffer();
        while (i < n && BasisLibrary.isWhiteSpace(value.charAt(i))) {
            ++i;
        }
        while (true) {
            if (i < n && !BasisLibrary.isWhiteSpace(value.charAt(i))) {
                result.append(value.charAt(i++));
                continue;
            }
            if (i != n) ** GOTO lbl15
            break;
lbl-1000:
            // 1 sources

            {
                ++i;
lbl15:
                // 2 sources

                ** while (i < n && BasisLibrary.isWhiteSpace((char)value.charAt((int)i)))
            }
lbl16:
            // 1 sources

            if (i >= n) continue;
            result.append(' ');
        }
        return result.toString();
    }

    public static String generate_idF(int node) {
        if (node > 0) {
            return "N" + node;
        }
        return EMPTYSTRING;
    }

    public static String getLocalName(String value) {
        int idx = value.lastIndexOf(58);
        if (idx >= 0) {
            value = value.substring(idx + 1);
        }
        if ((idx = value.lastIndexOf(64)) >= 0) {
            value = value.substring(idx + 1);
        }
        return value;
    }

    public static void unresolved_externalF(String name) {
        BasisLibrary.runTimeError(3, name);
    }

    public static String namespace_uriF(NodeIterator iter, DOM dom) {
        return BasisLibrary.namespace_uriF(iter.next(), dom);
    }

    public static String system_propertyF(String name) {
        if (name.equals("xsl:version")) {
            return "1.0";
        }
        if (name.equals("xsl:vendor")) {
            return "Apache Software Foundation (XSLTC)";
        }
        if (name.equals("xsl:vendor-url")) {
            return "http://xml.apache.org/xalan-j";
        }
        BasisLibrary.runTimeError(5, name, "system-property()");
        return EMPTYSTRING;
    }

    public static String namespace_uriF(int node, DOM dom) {
        String value = dom.getNodeName(node);
        int colon = value.lastIndexOf(58);
        if (colon >= 0) {
            return value.substring(0, colon);
        }
        return EMPTYSTRING;
    }

    public static NodeIterator nodesetF(DOM rtf) {
        DOMAdapter adapter = (DOMAdapter)rtf;
        return new SingletonIterator(1 | adapter.getMultiDOMMask(), true);
    }

    private static boolean isWhiteSpace(char ch) {
        return ch == ' ' || ch == '\t' || ch == '\n' || ch == '\r';
    }

    private static boolean compareStrings(String lstring, String rstring, int op, DOM dom) {
        switch (op) {
            case 0: {
                return lstring.equals(rstring);
            }
            case 1: {
                return !lstring.equals(rstring);
            }
            case 2: {
                return BasisLibrary.numberF(lstring, dom) > BasisLibrary.numberF(rstring, dom);
            }
            case 3: {
                return BasisLibrary.numberF(lstring, dom) < BasisLibrary.numberF(rstring, dom);
            }
            case 4: {
                return BasisLibrary.numberF(lstring, dom) >= BasisLibrary.numberF(rstring, dom);
            }
            case 5: {
                return BasisLibrary.numberF(lstring, dom) <= BasisLibrary.numberF(rstring, dom);
            }
        }
        BasisLibrary.runTimeError(0, "compare()");
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean compare(NodeIterator left, NodeIterator right, int op, int node, DOM dom) {
        int lnode;
        left.reset();
        while ((lnode = left.next()) != 0) {
            int rnode;
            void var5_5;
            String lvalue = dom.getNodeValue((int)var5_5);
            right.reset();
            while ((rnode = right.next()) != 0) {
                void var7_7;
                if (!BasisLibrary.compareStrings(lvalue, dom.getNodeValue((int)var7_7), op, dom)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean compare(int node, NodeIterator nodeSet, int op, DOM dom) {
        int rnode;
        String lvalue = dom.getNodeValue(node);
        while ((rnode = nodeSet.next()) != 0) {
            void var5_5;
            if (!BasisLibrary.compareStrings(lvalue, dom.getNodeValue((int)var5_5), op, dom)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean compare(int node, NodeIterator iterator, int op, int dummy, DOM dom) {
        switch (op) {
            case 0: {
                int rnode;
                String value = dom.getNodeValue(node);
                while ((rnode = iterator.next()) != 0) {
                    void var5_7;
                    if (!value.equals(dom.getNodeValue((int)var5_7))) continue;
                    return true;
                }
                break;
            }
            case 1: {
                int rnode;
                String value = dom.getNodeValue(node);
                while ((rnode = iterator.next()) != 0) {
                    if (value.equals(dom.getNodeValue(rnode))) continue;
                    return true;
                }
                break;
            }
            case 3: {
                int rnode;
                while ((rnode = iterator.next()) != 0) {
                    if (rnode <= node) continue;
                    return true;
                }
                break;
            }
            case 2: {
                int rnode;
                while ((rnode = iterator.next()) != 0) {
                    if (rnode >= node) continue;
                    return true;
                }
                break;
            }
        }
        return false;
    }

    public static boolean compare(NodeIterator left, double rnumber, int op, int node, DOM dom) {
        return BasisLibrary.compare(left, rnumber, op, dom);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean compare(NodeIterator left, double rnumber, int op, DOM dom) {
        switch (op) {
            case 0: {
                int node;
                while ((node = left.next()) != 0) {
                    void var5_4;
                    if (BasisLibrary.numberF(dom.getNodeValue((int)var5_4), dom) != rnumber) continue;
                    return true;
                }
                break;
            }
            case 1: {
                int node;
                while ((node = left.next()) != 0) {
                    if (BasisLibrary.numberF(dom.getNodeValue(node), dom) == rnumber) continue;
                    return true;
                }
                break;
            }
            case 2: {
                int node;
                while ((node = left.next()) != 0) {
                    if (!(BasisLibrary.numberF(dom.getNodeValue(node), dom) > rnumber)) continue;
                    return true;
                }
                break;
            }
            case 3: {
                int node;
                while ((node = left.next()) != 0) {
                    if (!(BasisLibrary.numberF(dom.getNodeValue(node), dom) < rnumber)) continue;
                    return true;
                }
                break;
            }
            case 4: {
                int node;
                while ((node = left.next()) != 0) {
                    if (!(BasisLibrary.numberF(dom.getNodeValue(node), dom) >= rnumber)) continue;
                    return true;
                }
                break;
            }
            case 5: {
                int node;
                while ((node = left.next()) != 0) {
                    if (!(BasisLibrary.numberF(dom.getNodeValue(node), dom) <= rnumber)) continue;
                    return true;
                }
                break;
            }
            default: {
                BasisLibrary.runTimeError(0, "compare()");
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean compare(NodeIterator left, String rstring, int op, DOM dom) {
        int node;
        while ((node = left.next()) != 0) {
            void var4_4;
            if (!BasisLibrary.compareStrings(dom.getNodeValue((int)var4_4), rstring, op, dom)) continue;
            return true;
        }
        return false;
    }

    public static boolean compare(NodeIterator left, String rstring, int op, int node, DOM dom) {
        return BasisLibrary.compareStrings(dom.getNodeValue(node), rstring, op, dom);
    }

    public static boolean compare(Object left, Object right, int op, int node, DOM dom) {
        boolean hasSimpleArgs;
        boolean result = false;
        boolean bl = hasSimpleArgs = BasisLibrary.hasSimpleType(left) && BasisLibrary.hasSimpleType(right);
        if (op != 0 && op != 1) {
            if (left instanceof Node || right instanceof Node) {
                if (left instanceof Boolean) {
                    right = new Boolean(BasisLibrary.booleanF(right));
                    hasSimpleArgs = true;
                }
                if (right instanceof Boolean) {
                    left = new Boolean(BasisLibrary.booleanF(left));
                    hasSimpleArgs = true;
                }
            }
            if (hasSimpleArgs) {
                switch (op) {
                    case 2: {
                        return BasisLibrary.numberF(left, dom) > BasisLibrary.numberF(right, dom);
                    }
                    case 3: {
                        return BasisLibrary.numberF(left, dom) < BasisLibrary.numberF(right, dom);
                    }
                    case 4: {
                        return BasisLibrary.numberF(left, dom) >= BasisLibrary.numberF(right, dom);
                    }
                    case 5: {
                        return BasisLibrary.numberF(left, dom) <= BasisLibrary.numberF(right, dom);
                    }
                }
                BasisLibrary.runTimeError(0, "compare()");
            }
        }
        if (hasSimpleArgs) {
            result = left instanceof Boolean || right instanceof Boolean ? BasisLibrary.booleanF(left) == BasisLibrary.booleanF(right) : (left instanceof Double || right instanceof Double || left instanceof Integer || right instanceof Integer ? BasisLibrary.numberF(left, dom) == BasisLibrary.numberF(right, dom) : BasisLibrary.stringF(left, dom).equals(BasisLibrary.stringF(right, dom)));
            if (op == 1) {
                result = !result;
            }
        } else {
            if (left instanceof Node) {
                left = new SingletonIterator(((Node)left).node);
            }
            if (right instanceof Node) {
                right = new SingletonIterator(((Node)right).node);
            }
            if (BasisLibrary.hasSimpleType(left) || left instanceof DOM && right instanceof NodeIterator) {
                Object temp = right;
                right = left;
                left = temp;
            }
            if (left instanceof DOM) {
                if (right instanceof Boolean) {
                    result = (Boolean)right;
                    return result == (op == 0);
                }
                String sleft = ((DOM)left).getStringValue();
                if (right instanceof Number) {
                    result = ((Number)right).doubleValue() == BasisLibrary.stringToReal(sleft);
                } else if (right instanceof String) {
                    result = sleft.equals((String)right);
                } else if (right instanceof DOM) {
                    result = sleft.equals(((DOM)right).getStringValue());
                }
                if (op == 1) {
                    result = !result;
                }
                return result;
            }
            NodeIterator iter = ((NodeIterator)left).reset();
            if (right instanceof NodeIterator) {
                result = BasisLibrary.compare(iter, (NodeIterator)right, op, node, dom);
            } else if (right instanceof String) {
                result = BasisLibrary.compare(iter, (String)right, op, dom);
            } else if (right instanceof Number) {
                double temp = ((Number)right).doubleValue();
                result = BasisLibrary.compare(iter, temp, op, dom);
            } else if (right instanceof Boolean) {
                boolean temp = (Boolean)right;
                result = iter.reset().next() != 0 == temp;
            } else if (right instanceof DOM) {
                result = BasisLibrary.compare(iter, ((DOM)right).getStringValue(), op, node, dom);
            } else {
                if (right == null) {
                    return false;
                }
                String className = right.getClass().getName();
                BasisLibrary.runTimeError(5, className, "compare()");
            }
        }
        return result;
    }

    public static boolean testLanguage(String testLang, DOM dom, int node) {
        String nodeLang = dom.getLanguage(node);
        if (nodeLang == null) {
            return false;
        }
        nodeLang = nodeLang.toLowerCase();
        if ((testLang = testLang.toLowerCase()).length() == 2) {
            return nodeLang.startsWith(testLang);
        }
        return nodeLang.equals(testLang);
    }

    private static boolean hasSimpleType(Object obj) {
        return obj instanceof Boolean || obj instanceof Double || obj instanceof Integer || obj instanceof String || obj instanceof Node;
    }

    public static double stringToReal(String s) {
        try {
            return Double.valueOf(s);
        }
        catch (NumberFormatException e) {
            return Double.NaN;
        }
    }

    public static int stringToInt(String s) {
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    public static String realToString(double d) {
        double m = Math.abs(d);
        if (m >= lowerBounds && m < upperBounds) {
            int length;
            String result = Double.toString(d);
            if (result.charAt((length = result.length()) - 2) == '.' && result.charAt(length - 1) == '0') {
                return result.substring(0, length - 2);
            }
            return result;
        }
        if (Double.isNaN(d) || Double.isInfinite(d)) {
            return Double.toString(d);
        }
        return BasisLibrary.formatNumber(d, defaultPattern, defaultFormatter);
    }

    public static int realToInt(double d) {
        return (int)d;
    }

    public static String formatNumber(double number, String pattern, DecimalFormat formatter) {
        try {
            StringBuffer result = new StringBuffer();
            formatter.applyLocalizedPattern(pattern);
            String localizedPattern = formatter.toPattern();
            int index = localizedPattern.indexOf(46);
            if (index >= 1 && localizedPattern.charAt(index - 1) != '0') {
                StringBuffer newpattern = new StringBuffer();
                newpattern.append(localizedPattern.substring(0, index));
                newpattern.append("0");
                newpattern.append(localizedPattern.substring(index));
                formatter.applyLocalizedPattern(newpattern.toString());
            } else if (index == 0) {
                StringBuffer newpattern = new StringBuffer();
                newpattern.append("0");
                newpattern.append(localizedPattern);
                formatter.applyLocalizedPattern(newpattern.toString());
            }
            formatter.format(number, result, _fieldPosition);
            return result.toString();
        }
        catch (IllegalArgumentException e) {
            BasisLibrary.runTimeError(6, Double.toString(number), pattern);
            return EMPTYSTRING;
        }
    }

    public static NodeIterator referenceToNodeSet(Object obj) {
        if (obj instanceof Node) {
            return new SingletonIterator(((Node)obj).node);
        }
        if (obj instanceof NodeIterator) {
            return ((NodeIterator)obj).cloneIterator();
        }
        String className = obj.getClass().getName();
        BasisLibrary.runTimeError(2, "reference", className);
        return null;
    }

    public static DOM referenceToResultTree(Object obj) {
        try {
            return (DOM)obj;
        }
        catch (IllegalArgumentException e) {
            String className = obj.getClass().getName();
            BasisLibrary.runTimeError(2, "reference", className);
            return null;
        }
    }

    public static NodeIterator getSingleNode(NodeIterator iterator) {
        int node = iterator.next();
        return new SingletonIterator(node);
    }

    public static void copy(Object obj, TransletOutputHandler handler, int node, DOM dom) {
        try {
            if (obj instanceof NodeIterator) {
                NodeIterator iter = (NodeIterator)obj;
                dom.copy(iter.reset(), handler);
            } else if (obj instanceof Node) {
                dom.copy(((Node)obj).node, handler);
            } else if (obj instanceof DOM) {
                ((DOM)obj).copy(1, handler);
            } else {
                String string = obj.toString();
                int length = string.length();
                if (length > _characterArray.length) {
                    _characterArray = new char[length];
                }
                string.getChars(0, length, _characterArray, 0);
                handler.characters(_characterArray, 0, length);
            }
        }
        catch (TransletException e) {
            BasisLibrary.runTimeError(1);
        }
    }

    public static String getPrefix(String qname) {
        int index = qname.indexOf(58);
        return index > 0 ? qname.substring(0, index) : null;
    }

    public static String generatePrefix() {
        return "ns" + prefixIndex++;
    }

    public static String makeQName(String localName, String prefix) {
        return prefix + ':' + localName;
    }

    public static void runTimeError(int code) {
        throw new RuntimeException(_errorMessages[code]);
    }

    public static void runTimeError(int code, Object[] args) {
        String message = MessageFormat.format(_errorMessages[code], args);
        throw new RuntimeException(message);
    }

    public static void runTimeError(int code, Object arg0) {
        BasisLibrary.runTimeError(code, new Object[]{arg0});
    }

    public static void runTimeError(int code, Object arg0, Object arg1) {
        BasisLibrary.runTimeError(code, new Object[]{arg0, arg1});
    }

    public static void consoleOutput(String msg) {
        System.out.println(msg);
    }

    public static String replace(String base, char ch, String str) {
        return base.indexOf(ch) < 0 ? base : BasisLibrary.replace(base, String.valueOf(ch), new String[]{str});
    }

    public static String replace(String base, String delim, String[] str) {
        int len = base.length();
        StringBuffer result = new StringBuffer();
        int i = 0;
        while (i < len) {
            char ch = base.charAt(i);
            int k = delim.indexOf(ch);
            if (k >= 0) {
                result.append(str[k]);
            } else {
                result.append(ch);
            }
            ++i;
        }
        return result.toString();
    }

    static {
        defaultPattern = EMPTYSTRING;
        defaultFormatter = new DecimalFormat();
        ((NumberFormat)defaultFormatter).setGroupingUsed(false);
        _fieldPosition = new FieldPosition(0);
        _characterArray = new char[32];
        prefixIndex = 0;
        String resource = "org.apache.xalan.xsltc.runtime.ErrorMessages";
        ResourceBundle bundle = ResourceBundle.getBundle(resource);
        _errorMessages = bundle.getStringArray(ERROR_MESSAGES_KEY);
    }
}

