/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.xsltc.dom;

import org.apache.xalan.xsltc.DOM;
import org.apache.xalan.xsltc.NodeIterator;
import org.apache.xalan.xsltc.StripFilter;
import org.apache.xalan.xsltc.TransletException;
import org.apache.xalan.xsltc.TransletOutputHandler;
import org.apache.xalan.xsltc.dom.DOMAdapter;
import org.apache.xalan.xsltc.dom.NodeIteratorBase;
import org.apache.xalan.xsltc.runtime.BasisLibrary;
import org.apache.xalan.xsltc.runtime.Hashtable;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class MultiDOM
implements DOM {
    private static final int NO_TYPE = -2;
    private static final int INITIAL_SIZE = 4;
    private static final int CLR = 0xFFFFFF;
    private static final int SET = -16777216;
    private DOM[] _adapters;
    private int _free = 1;
    private int _size = 4;
    private Hashtable _documents = new Hashtable();

    public MultiDOM(DOM main) {
        this._adapters = new DOM[4];
        this._adapters[0] = main;
    }

    public int nextMask() {
        return this._free << 24;
    }

    public void setupMapping(String[] names, String[] namespaces) {
    }

    public int addDOMAdapter(DOMAdapter dom) {
        int domNo;
        if ((domNo = this._free++) == this._size) {
            DOMAdapter[] newArray = new DOMAdapter[this._size *= 2];
            System.arraycopy(this._adapters, 0, newArray, 0, domNo);
            this._adapters = newArray;
        }
        this._adapters[domNo] = dom;
        String uri = dom.getDocumentURI(0);
        this._documents.put(uri, new Integer(domNo));
        dom.setMultiDOMMask(domNo << 24);
        return domNo << 24;
    }

    public int getDocumentMask(String uri) {
        Integer domIdx = (Integer)this._documents.get(uri);
        if (domIdx == null) {
            return -1;
        }
        return domIdx << 24;
    }

    public NodeIterator getIterator() {
        return this._adapters[0].getIterator();
    }

    public String getStringValue() {
        return this._adapters[0].getStringValue();
    }

    public String getTreeString() {
        return this._adapters[0].getTreeString();
    }

    public NodeIterator getChildren(int node) {
        return (node & 0xFF000000) == 0 ? this._adapters[0].getChildren(node) : this.getAxisIterator(3).setStartNode(node);
    }

    public NodeIterator getTypedChildren(int type) {
        return new AxisIterator(3, type);
    }

    public NodeIterator getAxisIterator(int axis) {
        return new AxisIterator(axis, -2);
    }

    public NodeIterator getTypedAxisIterator(int axis, int type) {
        return new AxisIterator(axis, type);
    }

    public NodeIterator getNthDescendant(int node, int n, boolean includeself) {
        return this._adapters[node >>> 24].getNthDescendant(node & 0xFFFFFF, n, includeself);
    }

    public NodeIterator getNodeValueIterator(NodeIterator iterator, int type, String value, boolean op) {
        return new NodeValueIterator(iterator, type, value, op);
    }

    public NodeIterator getNamespaceAxisIterator(int axis, int ns) {
        NodeIterator iterator = this._adapters[0].getNamespaceAxisIterator(axis, ns);
        return iterator;
    }

    public NodeIterator orderNodes(NodeIterator source, int node) {
        return this._adapters[node >>> 24].orderNodes(source, node & 0xFFFFFF);
    }

    public int getType(int node) {
        return this._adapters[node >>> 24].getType(node & 0xFFFFFF);
    }

    public int getNamespaceType(int node) {
        return this._adapters[node >>> 24].getNamespaceType(node & 0xFFFFFF);
    }

    public int getParent(int node) {
        return this._adapters[node >>> 24].getParent(node & 0xFFFFFF) | node & 0xFF000000;
    }

    public int getTypedPosition(int type, int node) {
        return this._adapters[node >>> 24].getTypedPosition(type, node & 0xFFFFFF);
    }

    public int getTypedLast(int type, int node) {
        return this._adapters[node >>> 24].getTypedLast(type, node & 0xFFFFFF);
    }

    public int getAttributeNode(int type, int el) {
        return this._adapters[el >>> 24].getAttributeNode(type, el & 0xFFFFFF) | el & 0xFF000000;
    }

    public String getNodeName(int node) {
        return this._adapters[node >>> 24].getNodeName(node & 0xFFFFFF);
    }

    public String getNamespaceName(int node) {
        return this._adapters[node >>> 24].getNamespaceName(node & 0xFFFFFF);
    }

    public String getNodeValue(int node) {
        return this._adapters[node >>> 24].getNodeValue(node & 0xFFFFFF);
    }

    public void copy(int node, TransletOutputHandler handler) throws TransletException {
        this._adapters[node >>> 24].copy(node & 0xFFFFFF, handler);
    }

    /*
     * WARNING - void declaration
     */
    public void copy(NodeIterator nodes, TransletOutputHandler handler) throws TransletException {
        int node;
        while ((node = nodes.next()) != 0) {
            void var3_3;
            this._adapters[var3_3 >>> 24].copy((int)(var3_3 & 0xFFFFFF), handler);
        }
    }

    public String shallowCopy(int node, TransletOutputHandler handler) throws TransletException {
        return this._adapters[node >>> 24].shallowCopy(node & 0xFFFFFF, handler);
    }

    public boolean lessThan(int node1, int node2) {
        int dom1 = node1 >>> 24;
        int dom2 = node2 >>> 24;
        return dom1 == dom2 ? this._adapters[dom1].lessThan(node1 & 0xFFFFFF, node2 & 0xFFFFFF) : dom1 < dom2;
    }

    public void characters(int textNode, TransletOutputHandler handler) throws TransletException {
        this._adapters[textNode >>> 24].characters(textNode & 0xFFFFFF, handler);
    }

    public void setFilter(StripFilter filter) {
        int dom = 0;
        while (dom < this._free) {
            this._adapters[dom].setFilter(filter);
            ++dom;
        }
    }

    public Node makeNode(int index) {
        return this._adapters[index >>> 24].makeNode(index & 0xFFFFFF);
    }

    public Node makeNode(NodeIterator iter) {
        return this._adapters[0].makeNode(iter);
    }

    public NodeList makeNodeList(int index) {
        return this._adapters[index >>> 24].makeNodeList(index & 0xFFFFFF);
    }

    public NodeList makeNodeList(NodeIterator iter) {
        return this._adapters[0].makeNodeList(iter);
    }

    public String getLanguage(int node) {
        return this._adapters[node >>> 24].getLanguage(node & 0xFFFFFF);
    }

    public int getSize() {
        int size = 0;
        int i = 0;
        while (i < this._size) {
            size += this._adapters[i].getSize();
            ++i;
        }
        return size;
    }

    public String getDocumentURI(int node) {
        return this._adapters[node >>> 24].getDocumentURI(0);
    }

    public boolean isElement(int node) {
        return this._adapters[node >>> 24].isElement(node & 0xFFFFFF);
    }

    public boolean isAttribute(int node) {
        return this._adapters[node >>> 24].isAttribute(node & 0xFFFFFF);
    }

    public String lookupNamespace(int node, String prefix) throws TransletException {
        return this._adapters[node >>> 24].lookupNamespace(node, prefix);
    }

    private final class NodeValueIterator
    extends NodeIteratorBase {
        private NodeIterator _source;
        private String _value;
        private boolean _op;
        private final boolean _isReverse;
        private int _returnType = 1;

        public NodeValueIterator(NodeIterator source, int returnType, String value, boolean op) {
            this._source = source;
            this._returnType = returnType;
            this._value = value;
            this._op = op;
            this._isReverse = source.isReverse();
        }

        public boolean isReverse() {
            return this._isReverse;
        }

        public NodeIterator cloneIterator() {
            try {
                NodeValueIterator clone = (NodeValueIterator)super.clone();
                clone._source = this._source.cloneIterator();
                clone.setRestartable(false);
                return clone.reset();
            }
            catch (CloneNotSupportedException e) {
                BasisLibrary.runTimeError(7, e.toString());
                return null;
            }
        }

        public void setRestartable(boolean isRestartable) {
            this._isRestartable = isRestartable;
            this._source.setRestartable(isRestartable);
        }

        public NodeIterator reset() {
            this._source.reset();
            return this.resetPosition();
        }

        /*
         * WARNING - void declaration
         */
        public int next() {
            int node;
            while ((node = this._source.next()) != 0) {
                void var1_1;
                String val = MultiDOM.this.getNodeValue((int)var1_1);
                if (this._value.equals(val) != this._op) continue;
                if (this._returnType == 0) {
                    return this.returnNode((int)var1_1);
                }
                return this.returnNode(MultiDOM.this.getParent((int)var1_1));
            }
            return 0;
        }

        public NodeIterator setStartNode(int node) {
            if (this._isRestartable) {
                this._startNode = node;
                this._source.setStartNode(this._startNode);
                return this.resetPosition();
            }
            return this;
        }

        public void setMark() {
            this._source.setMark();
        }

        public void gotoMark() {
            this._source.gotoMark();
        }
    }

    private final class AxisIterator
    implements NodeIterator {
        private final int _axis;
        private final int _type;
        private NodeIterator _source;
        private int _mask;

        public AxisIterator(int axis, int type) {
            this._axis = axis;
            this._type = type;
        }

        public int next() {
            if (this._source == null) {
                return 0;
            }
            if (this._mask == 0) {
                return this._source.next();
            }
            int node = this._source.next();
            return node != 0 ? node | this._mask : 0;
        }

        public void setRestartable(boolean flag) {
            this._source.setRestartable(flag);
        }

        public NodeIterator setStartNode(int node) {
            this._mask = node & 0xFF000000;
            int dom = node >>> 24;
            this._source = this._type == -2 || this._type == 3 ? MultiDOM.this._adapters[dom].getAxisIterator(this._axis) : (this._axis == 3 ? MultiDOM.this._adapters[dom].getTypedChildren(this._type) : MultiDOM.this._adapters[dom].getTypedAxisIterator(this._axis, this._type));
            this._source.setStartNode(node & 0xFFFFFF);
            return this;
        }

        public NodeIterator reset() {
            if (this._source != null) {
                this._source.reset();
            }
            return this;
        }

        public int getLast() {
            return this._source.getLast();
        }

        public int getPosition() {
            return this._source.getPosition();
        }

        public boolean isReverse() {
            if (this._source == null) {
                return false;
            }
            return this._source.isReverse();
        }

        public void setMark() {
            this._source.setMark();
        }

        public void gotoMark() {
            this._source.gotoMark();
        }

        public NodeIterator cloneIterator() {
            AxisIterator clone = new AxisIterator(this._axis, this._type);
            clone._source = this._source.cloneIterator();
            clone._mask = this._mask;
            return clone;
        }
    }
}

