/*
 * Decompiled with CFR 0.152.
 */
package jd.util;

public class TextBuffer {
    private int length_;
    private char[] text_ = new char[64];

    public void append(String string) {
        this.append(string, 0, string.length());
    }

    public void append(String string, int n, int n2) {
        int n3 = this.length_ + n2;
        if (n3 > this.text_.length) {
            this.expandCapacity(n3);
        }
        string.getChars(n, n2, this.text_, this.length_);
        this.length_ = n3;
    }

    public void append(StringBuffer stringBuffer) {
        this.append(stringBuffer, 0, stringBuffer.length());
    }

    public void append(StringBuffer stringBuffer, int n, int n2) {
        int n3 = this.length_ + n2;
        if (n3 > this.text_.length) {
            this.expandCapacity(n3);
        }
        stringBuffer.getChars(n, n2, this.text_, this.length_);
        this.length_ = n3;
    }

    public void append(TextBuffer textBuffer) {
        int n = this.length_ + textBuffer.length_;
        if (n > this.text_.length) {
            this.expandCapacity(n);
        }
        System.arraycopy(textBuffer.text_, 0, this.text_, this.length_, textBuffer.length_);
        this.length_ = n;
    }

    public void append(char c) {
        if (this.length_ + 1 > this.text_.length) {
            this.expandCapacity(this.length_ + 1);
        }
        this.text_[this.length_++] = c;
    }

    public void append(char[] cArray) {
        this.append(cArray, 0, cArray.length);
    }

    public void append(char[] cArray, int n, int n2) {
        int n3 = this.length_ + n2;
        if (n3 > this.text_.length) {
            this.expandCapacity(n3);
        }
        System.arraycopy(cArray, n, this.text_, this.length_, n2);
        this.length_ = n3;
    }

    private void expandCapacity(int n) {
        int n2 = this.text_.length * 2;
        if (n > n2) {
            n2 = n;
        }
        char[] cArray = new char[n2];
        System.arraycopy(this.text_, 0, cArray, 0, this.length_);
        this.text_ = cArray;
    }

    public void clear() {
        this.length_ = 0;
    }

    public int length() {
        return this.length_;
    }

    public void setLength(int n) {
        if (n < 0) {
            throw new StringIndexOutOfBoundsException(n);
        }
        if (n > this.text_.length) {
            this.expandCapacity(n);
        }
        this.length_ = n;
    }

    public char[] getBuffer() {
        return this.text_;
    }

    public char charAt(int n) {
        return this.text_[n];
    }

    public boolean equalsString(String string) {
        int n = this.length_;
        if (this.length_ != string.length()) {
            return false;
        }
        char[] cArray = this.text_;
        int n2 = 0;
        while (n2 < n) {
            if (cArray[n2] != string.charAt(n2)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public String toString() {
        return new String(this.text_, 0, this.length_);
    }
}

