/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.persistence.oql;

import com.redhat.persistence.oql.Code;
import com.redhat.persistence.oql.Expression;
import com.redhat.persistence.oql.Generator;
import com.redhat.persistence.oql.QFrame;

public class Sort
extends Expression {
    public static final String versionId = "$Id: //core-platform/dev/src/com/redhat/persistence/oql/Sort.java#5 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    public static final Order ASCENDING = new Order();
    public static final Order DESCENDING = new Order();
    private Expression m_query;
    private Expression m_key;
    private Order m_order;

    public Sort(Expression query, Expression key, Order order) {
        this.m_query = query;
        this.m_key = key;
        this.m_order = order;
    }

    public Sort(Expression query, Expression key) {
        this(query, key, ASCENDING);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void frame(Generator gen) {
        this.m_query.frame(gen);
        QFrame query = gen.getFrame(this.m_query);
        QFrame frame = gen.frame(this, query.getType());
        frame.addChild(query);
        frame.setValues(query.getValues());
        frame.setMappings(query.getMappings());
        frame.setOrder(this.m_key, this.m_order == ASCENDING);
        gen.addUses(this, gen.getUses(this.m_query));
        gen.push(frame);
        try {
            this.m_key.frame(gen);
            gen.addUses(this, gen.getUses(this.m_key));
        }
        finally {
            gen.pop();
        }
    }

    Code emit(Generator gen) {
        return gen.getFrame(this).emit();
    }

    void hash(Generator gen) {
        this.m_query.hash(gen);
        this.m_key.hash(gen);
        gen.hash(this.m_order == ASCENDING);
        gen.hash(this.getClass());
    }

    String summary() {
        return "sort";
    }

    public String toString() {
        return "sort(" + this.m_query + ", " + this.m_key + ")";
    }

    public static class Order {
        private Order() {
        }
    }
}

