/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.persistence.engine.rdbms;

import com.arsdigita.util.UncheckedWrapperException;
import com.arsdigita.util.WrappedError;
import com.redhat.persistence.DataSet;
import com.redhat.persistence.Engine;
import com.redhat.persistence.Event;
import com.redhat.persistence.PropertyMap;
import com.redhat.persistence.QuerySource;
import com.redhat.persistence.RecordSet;
import com.redhat.persistence.SQLWriterException;
import com.redhat.persistence.SetEvent;
import com.redhat.persistence.Signature;
import com.redhat.persistence.common.CompoundKey;
import com.redhat.persistence.common.Path;
import com.redhat.persistence.engine.rdbms.Aggregator;
import com.redhat.persistence.engine.rdbms.ConnectionSource;
import com.redhat.persistence.engine.rdbms.DML;
import com.redhat.persistence.engine.rdbms.Delete;
import com.redhat.persistence.engine.rdbms.Environment;
import com.redhat.persistence.engine.rdbms.EventSwitch;
import com.redhat.persistence.engine.rdbms.Node;
import com.redhat.persistence.engine.rdbms.Operation;
import com.redhat.persistence.engine.rdbms.RDBMSException;
import com.redhat.persistence.engine.rdbms.RDBMSProfiler;
import com.redhat.persistence.engine.rdbms.RDBMSRecordSet;
import com.redhat.persistence.engine.rdbms.RDBMSStatement;
import com.redhat.persistence.engine.rdbms.ResultCycle;
import com.redhat.persistence.engine.rdbms.RetainUpdatesWriter;
import com.redhat.persistence.engine.rdbms.SQLWriter;
import com.redhat.persistence.engine.rdbms.Select;
import com.redhat.persistence.engine.rdbms.StatementLifecycle;
import com.redhat.persistence.engine.rdbms.StaticOperation;
import com.redhat.persistence.metadata.Adapter;
import com.redhat.persistence.metadata.ObjectType;
import com.redhat.persistence.metadata.Property;
import com.redhat.persistence.metadata.Root;
import com.redhat.persistence.metadata.SQLBlock;
import com.redhat.persistence.metadata.Table;
import com.redhat.persistence.oql.Expression;
import com.redhat.persistence.oql.Query;
import com.redhat.persistence.oql.Size;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class RDBMSEngine
extends Engine {
    public static final String versionId = "$Id: //core-platform/dev/src/com/redhat/persistence/engine/rdbms/RDBMSEngine.java#21 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private static final Logger LOG = Logger.getLogger((Class)(class$com$redhat$persistence$engine$rdbms$RDBMSEngine == null ? (class$com$redhat$persistence$engine$rdbms$RDBMSEngine = RDBMSEngine.class$("com.redhat.persistence.engine.rdbms.RDBMSEngine")) : class$com$redhat$persistence$engine$rdbms$RDBMSEngine));
    private ArrayList m_operations = new ArrayList();
    private HashMap m_operationMap = new HashMap();
    private EventSwitch m_switch = new EventSwitch(this);
    private Event m_event = null;
    private HashMap m_environments = new HashMap();
    private ArrayList m_mutations = new ArrayList();
    private ArrayList m_mutationTypes = new ArrayList();
    private ConnectionSource m_source;
    private Connection m_conn = null;
    private int m_connUsers = 0;
    private SQLWriter m_writer;
    private RDBMSProfiler m_profiler;
    private Aggregator m_aggregator = new Aggregator();
    static /* synthetic */ Class class$com$redhat$persistence$engine$rdbms$RDBMSEngine;

    public RDBMSEngine(ConnectionSource source, SQLWriter writer) {
        this(source, writer, null);
    }

    public RDBMSEngine(ConnectionSource source, SQLWriter writer, RDBMSProfiler profiler) {
        this.m_source = source;
        this.m_writer = writer;
        this.m_profiler = profiler;
        this.m_writer.setEngine(this);
    }

    public Connection getConnection() {
        this.acquire();
        return this.m_conn;
    }

    void acquire() {
        if (this.m_conn == null) {
            this.m_conn = this.m_source.acquire();
        }
        ++this.m_connUsers;
    }

    void release() {
        if (this.m_conn == null) {
            return;
        }
        --this.m_connUsers;
        if (this.m_connUsers == 0) {
            this.m_source.release(this.m_conn);
            this.m_conn = null;
        }
    }

    void releaseAll() {
        if (this.m_conn != null) {
            this.m_source.release(this.m_conn);
            this.m_conn = null;
            this.m_connUsers = 0;
        }
    }

    void addOperation(Object obj, DML dml) {
        DML prev;
        CompoundKey key = new CompoundKey(obj, dml.getTable());
        if (dml instanceof Delete && (prev = (DML)this.m_operationMap.get(key)) != null) {
            this.removeOperation(obj, prev);
        }
        this.m_operationMap.put(key, dml);
        this.addOperation(dml);
    }

    void removeOperation(Object obj, DML dml) {
        CompoundKey key = new CompoundKey(obj, dml.getTable());
        this.m_operationMap.remove(key);
        this.m_operations.remove(dml);
    }

    DML getOperation(Object obj, Table table) {
        CompoundKey key = new CompoundKey(obj, table);
        DML result = (DML)this.m_operationMap.get(key);
        if (this.m_profiler != null && result != null) {
            result.addEvent(this.m_event);
        }
        return result;
    }

    void clearUpdates(Object obj) {
        this.m_operationMap.remove(obj);
    }

    void removeUpdates(Object obj) {
        LOG.debug((Object)("Removing updates for: " + obj));
        ArrayList ops = (ArrayList)this.m_operationMap.get(obj);
        if (ops != null) {
            LOG.debug((Object)("found: " + ops));
            Iterator it = ops.iterator();
            while (it.hasNext()) {
                Operation op = (Operation)it.next();
                if (op instanceof DML) {
                    this.removeOperation(obj, (DML)op);
                } else {
                    this.m_operations.remove(op);
                }
                it.remove();
            }
        }
        this.clearUpdates(obj);
    }

    void markUpdate(Object obj) {
        if (!this.hasUpdates(obj)) {
            this.m_operationMap.put(obj, new ArrayList());
        }
    }

    void markUpdate(Object obj, Operation op) {
        this.markUpdate(obj);
        ArrayList ops = (ArrayList)this.m_operationMap.get(obj);
        ops.add(op);
    }

    boolean hasUpdates(Object obj) {
        return this.m_operationMap.containsKey(obj);
    }

    void addOperation(Operation op) {
        if (this.m_profiler != null) {
            op.addEvent(this.m_event);
        }
        this.m_operations.add(op);
    }

    Environment getEnvironment(Object obj) {
        Environment result = (Environment)this.m_environments.get(obj);
        if (result == null) {
            result = new Environment(this, this.getSession().getObjectMap(obj));
            this.m_environments.put(obj, result);
        }
        return result;
    }

    void scheduleMutation(SetEvent e, int type) {
        this.m_mutations.add(e);
        this.m_mutationTypes.add(new Integer(type));
    }

    void clear() {
        this.m_aggregator.clear();
        this.clearOperations();
        this.m_mutations.clear();
        this.m_mutationTypes.clear();
    }

    void clearOperations() {
        this.m_operationMap.clear();
        this.m_operations.clear();
        this.m_environments.clear();
    }

    protected void commit() {
        this.acquire();
        try {
            this.m_conn.commit();
        }
        catch (SQLException e) {
            throw new WrappedError(e);
        }
        finally {
            this.releaseAll();
        }
    }

    protected void rollback() {
        this.acquire();
        try {
            this.m_conn.rollback();
        }
        catch (SQLException e) {
            throw new WrappedError(e);
        }
        finally {
            this.releaseAll();
            this.clear();
        }
    }

    public RecordSet execute(Signature sig, Expression expr) {
        Select sel = new Select(this, sig, expr);
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("Executing " + sel.getQuery()));
        }
        return new RDBMSRecordSet(sig, this, this.execute(sel));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public long size(Expression expr) {
        ResultCycle rc;
        Query q = new Query(new Size(expr));
        Select sel = new Select(this, q);
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("Executing " + sel.getQuery()));
        }
        if ((rc = this.execute(sel)) == null) {
            throw new IllegalStateException("null result set");
        }
        ResultSet rs = rc.getResultSet();
        StatementLifecycle cycle = rc.getLifecycle();
        try {
            long result;
            if (!rc.next()) throw new IllegalStateException("count returned no rows");
            try {
                if (cycle != null) {
                    cycle.beginGet("1");
                }
                result = rs.getLong(1);
                if (cycle != null) {
                    cycle.endGet(new Long(result));
                }
            }
            catch (SQLException e) {
                if (cycle == null) throw new RDBMSException(e.getMessage()){};
                cycle.endGet(e);
                throw new /* invalid duplicate definition of identical inner class */;
            }
            if (rc.next()) {
                throw new IllegalStateException("count returned too many rows");
            }
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("size = " + result));
            }
            long l = result;
            return l;
        }
        finally {
            rc.close();
        }
    }

    public void write(Event ev) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)ev);
        }
        ev.dispatch(this.m_aggregator);
    }

    private void generate() {
        int before;
        Collection nodes = this.m_aggregator.getNodes();
        HashSet<Event> generated = new HashSet<Event>();
        do {
            before = generated.size();
            Iterator it = nodes.iterator();
            while (it.hasNext()) {
                Node nd = (Node)it.next();
                if (!generated.containsAll(nd.getDependencies())) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Generating node: " + nd));
                }
                int ops = this.m_operations.size();
                Collection events = nd.getEvents();
                Iterator iter = events.iterator();
                while (iter.hasNext()) {
                    Event ev = (Event)iter.next();
                    if (generated.contains(ev)) {
                        throw new IllegalStateException("event generated twice: " + ev);
                    }
                    this.m_event = ev;
                    ev.dispatch(this.m_switch);
                    this.m_event = null;
                    generated.add(ev);
                }
                for (int i = ops; i < this.m_operations.size(); ++i) {
                    Operation op = (Operation)this.m_operations.get(i);
                    LOG.debug((Object)("GENERATED: " + op));
                    LOG.debug((Object)("ENV: " + op.getEnvironment()));
                }
                it.remove();
                this.m_operationMap.clear();
                this.m_environments.clear();
            }
        } while (generated.size() > before);
        if (nodes.size() > 0) {
            StringBuffer msg = new StringBuffer();
            msg.append("unable to generate all events:");
            Iterator it = nodes.iterator();
            while (it.hasNext()) {
                Node nd = (Node)it.next();
                msg.append("\n\nnode {");
                msg.append("\n  events {");
                Iterator iter = nd.getEvents().iterator();
                while (iter.hasNext()) {
                    msg.append("\n    ");
                    msg.append(iter.next());
                }
                msg.append("\n  }\n");
                msg.append("\n  unresolved dependencies {");
                iter = nd.getDependencies().iterator();
                while (iter.hasNext()) {
                    Event ev = (Event)iter.next();
                    if (generated.contains(ev)) continue;
                    msg.append("\n    ");
                    msg.append(ev);
                }
                msg.append("\n  }");
                msg.append("\n}");
            }
            throw new IllegalStateException(msg.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        try {
            this.generate();
            Iterator it = this.m_operations.iterator();
            while (it.hasNext()) {
                Operation op = (Operation)it.next();
                it.remove();
                ResultCycle rc = this.execute(op);
                if (rc == null) continue;
                rc.close();
            }
            for (int i = 0; i < this.m_mutations.size(); ++i) {
                SetEvent e = (SetEvent)this.m_mutations.get(i);
                int jdbcType = (Integer)this.m_mutationTypes.get(i);
                Property prop = e.getProperty();
                DataSet ds = this.getSession().getDataSet(e.getObject(), prop);
                QuerySource qs = this.getSession().getQuerySource();
                RDBMSRecordSet rs = (RDBMSRecordSet)this.execute(ds.getSignature(), ds.getExpression());
                Adapter ad = prop.getRoot().getAdapter(prop.getType());
                try {
                    if (rs.next()) {
                        ad.mutate(rs.getResultSet(), rs.getColumn(Path.get(prop.getName())), e.getArgument(), jdbcType);
                        continue;
                    }
                    throw new IllegalStateException("cannot update blob");
                }
                catch (SQLException se) {
                    LOG.error((Object)se.getMessage(), (Throwable)se);
                    throw new WrappedError(se);
                }
                finally {
                    rs.close();
                }
            }
        }
        finally {
            this.clear();
        }
    }

    private ResultCycle execute(Operation op) {
        return this.execute(op, this.m_writer);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ResultCycle execute(Operation op, SQLWriter w) {
        try {
            PreparedStatement ps;
            try {
                w.write(op);
            }
            catch (RDBMSException re) {
                w.clear();
                LOG.warn((Object)("failed operation: " + op));
                throw re;
            }
            catch (SQLWriterException ex) {
                throw new UncheckedWrapperException("failed operation: " + op.toSafeString(), ex);
            }
            String sql = w.getSQL();
            if (LOG.isInfoEnabled()) {
                this.logQueryDetails(Priority.INFO, sql, w, op);
            }
            if (sql.equals("")) {
                ResultCycle resultCycle = null;
                return resultCycle;
            }
            this.acquire();
            StatementLifecycle cycle = null;
            if (this.m_profiler != null) {
                RDBMSStatement stmt = new RDBMSStatement(sql);
                if (op instanceof Select) {
                    stmt.setSignature(((Select)op).getSignature());
                }
                Iterator it = op.getEvents().iterator();
                while (it.hasNext()) {
                    stmt.addEvent((Event)it.next());
                }
                cycle = this.m_profiler.getLifecycle(stmt);
            }
            try {
                if (cycle != null) {
                    cycle.beginPrepare();
                }
                ps = this.m_conn.prepareStatement(sql);
                if (cycle != null) {
                    cycle.endPrepare();
                }
            }
            catch (SQLException e) {
                if (cycle != null) {
                    cycle.endPrepare(e);
                }
                this.logQueryDetails(Priority.ERROR, sql, w, op, e);
                throw new RDBMSException(e.getMessage()){};
            }
            w.bind(ps, cycle);
            try {
                if (cycle != null) {
                    cycle.beginExecute();
                }
                if (ps.execute()) {
                    if (cycle != null) {
                        cycle.endExecute(0);
                    }
                    ResultCycle e = new ResultCycle(this, ps.getResultSet(), cycle);
                    return e;
                }
            }
            catch (SQLException e) {
                if (cycle != null) {
                    cycle.endExecute(e);
                }
                this.logQueryDetails(Priority.ERROR, sql, w, op, e);
                throw new RDBMSException(e.getMessage()){};
            }
            catch (RuntimeException e) {
                this.logQueryDetails(Priority.ERROR, sql, w, op, e);
                throw e;
            }
            int updateCount = ps.getUpdateCount();
            if (cycle != null) {
                cycle.endExecute(updateCount);
            }
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)(updateCount + " rows affected"));
            }
            try {
                if (cycle != null) {
                    cycle.beginClose();
                }
                ps.close();
                if (cycle != null) {
                    cycle.endClose();
                }
            }
            catch (SQLException e) {
                if (cycle != null) {
                    cycle.endClose(e);
                }
                this.logQueryDetails(Priority.ERROR, sql, w, op, e);
                throw new RDBMSException(e.getMessage()){};
            }
            ResultCycle resultCycle = null;
            return resultCycle;
        }
        finally {
            w.clear();
        }
    }

    private void logQueryDetails(Priority priority, String sql, SQLWriter w, Operation op) {
        this.logQueryDetails(priority, sql, w, op, null);
    }

    private void logQueryDetails(Priority priority, String sql, SQLWriter w, Operation op, Throwable error) {
        if (error == null) {
            LOG.log(priority, (Object)sql);
        } else {
            LOG.log(priority, (Object)sql, error);
        }
        LOG.log(priority, (Object)w.getBindings());
        LOG.log(priority, (Object)w.getTypeNames());
        LOG.log(priority, (Object)op.getEnvironment());
    }

    public void execute(SQLBlock sql, Map parameters) {
        Environment env = new Environment(this, null);
        Iterator it = parameters.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry me = it.next();
            env.set((Path)me.getKey(), me.getValue());
        }
        StaticOperation op = new StaticOperation(this, sql, env, false);
        RetainUpdatesWriter w = new RetainUpdatesWriter();
        w.setEngine(this);
        this.execute(op, w);
    }

    private HashMap collToMap(Collection c) {
        Iterator iter = c.iterator();
        HashMap map = new HashMap();
        int i = 1;
        while (iter.hasNext()) {
            map.put(new Integer(i), iter.next());
            ++i;
        }
        return map;
    }

    static final Path[] getKeyPaths(ObjectType type, Path prefix) {
        return RDBMSEngine.getPaths(type, prefix, false);
    }

    static final Path[] getImmediatePaths(ObjectType type, Path prefix) {
        return RDBMSEngine.getPaths(type, prefix, true);
    }

    private static final Path[] getPaths(ObjectType type, Path prefix, boolean immediate) {
        LinkedList<Path> result = new LinkedList<Path>();
        LinkedList<Path> stack = new LinkedList<Path>();
        stack.add(prefix);
        while (stack.size() > 0) {
            Path p = (Path)stack.removeLast();
            ObjectType ot = type.getType(Path.relative(prefix, p));
            List props = immediate ? ot.getImmediateProperties() : ot.getKeyProperties();
            if (props.size() == 0) {
                result.add(p);
                continue;
            }
            ArrayList revProps = new ArrayList(props.size());
            revProps.addAll(props);
            Collections.reverse(revProps);
            Iterator it = revProps.iterator();
            while (it.hasNext()) {
                Property key = (Property)it.next();
                stack.add(Path.add(p, key.getName()));
            }
        }
        return result.toArray(new Path[0]);
    }

    Object get(Object obj, Path path) {
        if (path == null) {
            return obj;
        }
        Object o = this.get(obj, path.getParent());
        if (o == null) {
            return null;
        }
        PropertyMap props = this.getSession().getProperties(o);
        return props.get(props.getObjectType().getProperty(path.getName()));
    }

    static final int getType(Root root, Object obj) {
        if (obj == null) {
            return 4;
        }
        return RDBMSEngine.getType(root, obj.getClass());
    }

    static final int getType(Root root, Class klass) {
        return root.getAdapter(klass).defaultJDBCType();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

