/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.persistence;

import com.redhat.persistence.AddEvent;
import com.redhat.persistence.CreateEvent;
import com.redhat.persistence.DeleteEvent;
import com.redhat.persistence.NullException;
import com.redhat.persistence.ObjectData;
import com.redhat.persistence.ProtoException;
import com.redhat.persistence.RemoveEvent;
import com.redhat.persistence.Session;
import com.redhat.persistence.SetEvent;
import com.redhat.persistence.metadata.ObjectMap;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;

public abstract class Event {
    public static final String versionId = "$Id: //core-platform/dev/src/com/redhat/persistence/Event.java#5 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private static final Logger LOG = Logger.getLogger((Class)(class$com$redhat$persistence$Event == null ? (class$com$redhat$persistence$Event = Event.class$("com.redhat.persistence.Event")) : class$com$redhat$persistence$Event));
    private Session m_ssn;
    private Object m_obj;
    private List m_dependentEvents = new ArrayList();
    boolean m_flushable = false;
    static /* synthetic */ Class class$com$redhat$persistence$Event;

    Event(Session ssn, Object obj) {
        this.m_ssn = ssn;
        this.m_obj = obj;
        if (this.m_obj == null) {
            throw new NullException(ProtoException.OBJECT);
        }
    }

    public final Session getSession() {
        return this.m_ssn;
    }

    public final Object getObject() {
        ObjectData od = this.getObjectData();
        if (od == null) {
            return this.m_obj;
        }
        return this.getObjectData().getObject();
    }

    public final ObjectMap getObjectMap() {
        return this.m_ssn.getObjectMap(this.m_obj);
    }

    public abstract void dispatch(Switch var1);

    final void addDependent(Event dependent) {
        this.m_dependentEvents.add(dependent);
    }

    final Iterator getDependentEvents() {
        return this.m_dependentEvents.iterator();
    }

    abstract ObjectData getObjectData();

    abstract void prepare();

    abstract void activate();

    abstract void sync();

    void dump() {
        PrintWriter pw = new PrintWriter(System.out);
        this.dump(pw);
        pw.flush();
    }

    abstract void dump(PrintWriter var1);

    abstract String getName();

    final void log() {
        if (LOG.isDebugEnabled()) {
            StringBuffer msg = new StringBuffer();
            Event event = this;
            int level = event.m_ssn.getLevel();
            for (int i = 0; i < level + 1; ++i) {
                msg.append("  ");
            }
            msg.append(this);
            LOG.debug((Object)msg.toString());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static abstract class Switch {
        public abstract void onCreate(CreateEvent var1);

        public abstract void onDelete(DeleteEvent var1);

        public abstract void onSet(SetEvent var1);

        public abstract void onAdd(AddEvent var1);

        public abstract void onRemove(RemoveEvent var1);
    }
}

