/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.workflow.simple;

import com.arsdigita.db.Sequences;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.domain.ObservableDomainObject;
import com.arsdigita.kernel.User;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.PersistenceException;
import com.arsdigita.persistence.metadata.ObjectType;
import com.arsdigita.util.UncheckedWrapperException;
import com.arsdigita.workflow.simple.Task;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.Date;
import org.apache.log4j.Logger;

public class TaskComment
extends ObservableDomainObject {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/workflow/simple/TaskComment.java#11 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private static final Logger s_cat = Logger.getLogger((String)(class$com$arsdigita$workflow$simple$TaskComment == null ? (class$com$arsdigita$workflow$simple$TaskComment = TaskComment.class$("com.arsdigita.workflow.simple.TaskComment")) : class$com$arsdigita$workflow$simple$TaskComment).getName());
    public static final String BASE_DATA_OBJECT_TYPE = "com.arsdigita.workflow.simple.TaskComment";
    private static final String COMMENT = "taskComment";
    private static final String DATE = "commentDate";
    private static final String USER_ID = "partyID";
    private static final String TASK = "task";
    private static final String COMMENT_ID = "id";
    static /* synthetic */ Class class$com$arsdigita$workflow$simple$TaskComment;

    public TaskComment(BigDecimal taskID, User user, String comment) {
        this(taskID, user, comment, new Date());
    }

    public TaskComment(BigDecimal commentID, BigDecimal taskID, User user, String comment) {
        this(commentID, taskID, user, comment, new Date());
    }

    public TaskComment(BigDecimal taskID, User user, String comment, Date date) {
        this(null, taskID, user, comment, date);
    }

    public TaskComment(BigDecimal commentID, BigDecimal taskID, User user, String comment, Date date) {
        this(BASE_DATA_OBJECT_TYPE);
        if (commentID == null) {
            this.set(COMMENT_ID, this.generateID());
        } else {
            this.set(COMMENT_ID, commentID);
        }
        this.set(COMMENT, comment);
        if (user != null) {
            this.set(USER_ID, user.getID());
        }
        this.setTask((Task)DomainObjectFactory.newInstance(new OID("com.arsdigita.workflow.simple.Task", (Object)taskID)));
        this.set(DATE, date);
    }

    private BigDecimal generateID() throws PersistenceException {
        try {
            return Sequences.getNextValue();
        }
        catch (SQLException e) {
            String errorMsg = "Unable to generate a unique TaskComment id.";
            s_cat.error((Object)"Unable to generate a unique TaskComment id.");
            throw new PersistenceException("Unable to generate a unique TaskComment id.");
        }
    }

    public TaskComment(BigDecimal taskID, String comment) {
        this(taskID, null, comment, new Date());
    }

    public TaskComment(DataObject commentDataObject) {
        super(commentDataObject);
    }

    protected TaskComment(ObjectType type) {
        super(type);
    }

    public TaskComment(String typeName) {
        super(typeName);
    }

    public TaskComment(OID oid) throws DataObjectNotFoundException {
        super(oid);
    }

    protected String getBaseDataObjectType() {
        return BASE_DATA_OBJECT_TYPE;
    }

    public String getComment() {
        return (String)this.get(COMMENT);
    }

    public Date getDate() {
        return (Date)this.get(DATE);
    }

    public OID getUserOID() {
        BigDecimal user_id = (BigDecimal)this.get(USER_ID);
        if (user_id == null) {
            return null;
        }
        return new OID("com.arsdigita.kernel.User", (Object)user_id);
    }

    public User getUser() {
        OID oid = this.getUserOID();
        if (oid != null) {
            try {
                return (User)DomainObjectFactory.newInstance(oid);
            }
            catch (DataObjectNotFoundException de) {
                throw new UncheckedWrapperException("Could not load User with OID: " + oid, de);
            }
        }
        return null;
    }

    public BigDecimal getTaskID() {
        Task t = this.getTask();
        if (t == null) {
            return null;
        }
        return this.getTask().getID();
    }

    void setTask(Task task) {
        this.setAssociation(TASK, task);
    }

    public Task getTask() {
        return (Task)DomainObjectFactory.newInstance((DataObject)this.get(TASK));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

