/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.webdevsupport;

import com.arsdigita.util.StringUtils;
import java.sql.SQLException;
import java.util.HashMap;

public class QueryInfo {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/webdevsupport/QueryInfo.java#8 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private int m_id;
    private int m_connection_id;
    private String m_type;
    private String m_query;
    private HashMap m_bindvars;
    private long m_time;
    private SQLException m_sqle;
    private Throwable m_stack_trace;

    public QueryInfo(int id, int connection_id, String type, String query, HashMap bindvars, long time, SQLException sqle) {
        this.m_id = id;
        this.m_connection_id = connection_id;
        this.m_type = type;
        this.m_query = query;
        this.m_bindvars = bindvars;
        this.m_time = time;
        this.m_sqle = sqle;
        this.m_stack_trace = new Throwable();
    }

    public int getID() {
        return this.m_id;
    }

    public int getConnectionID() {
        return this.m_connection_id;
    }

    public String getType() {
        return this.m_type;
    }

    public String getQuery() {
        return this.m_query;
    }

    public HashMap getBindvars() {
        return this.m_bindvars;
    }

    public long getTime() {
        return this.m_time;
    }

    public SQLException getSQLE() {
        return this.m_sqle;
    }

    public String getStackTrace() {
        int j;
        String result = StringUtils.getStackTrace(this.m_stack_trace);
        int i = result.indexOf("DeveloperSupport.logQuery");
        if (i != -1 && (j = result.indexOf("\n", i)) != -1) {
            result = result.substring(j);
        }
        return result;
    }

    public boolean equals(Object o) {
        if (o instanceof QueryInfo) {
            QueryInfo qi = (QueryInfo)o;
            boolean bindvars_equals = qi.getBindvars() == null ? this.getBindvars() == null : qi.getBindvars().equals(this.getBindvars());
            return bindvars_equals && qi.getQuery().equals(this.getQuery());
        }
        return false;
    }

    public int hashCode() {
        return this.getQuery().hashCode();
    }
}

