/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.web;

import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.domain.DomainObjectInstantiator;
import com.arsdigita.kernel.PackageType;
import com.arsdigita.kernel.Stylesheet;
import com.arsdigita.util.Assert;
import com.arsdigita.web.ApplicationType;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Category;

public class ApplicationSetup {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/web/ApplicationSetup.java#9 $$Author: dennis $$DateTime: 2004/04/07 16:07:11 $";
    protected Category m_category;
    protected String m_title = null;
    protected String m_description = null;
    protected String m_typeName = null;
    protected DomainObjectInstantiator m_instantiator = null;
    protected String m_key = null;
    protected PackageType m_packageType = null;
    protected boolean m_isWorkspaceApplication = true;
    protected boolean m_isSingleton = false;
    protected String m_stylesheet = null;
    protected String m_dispatcherClass = null;

    public ApplicationSetup(Category category) {
        this.m_category = category;
    }

    public void setKey(String key) {
        this.m_key = key;
    }

    public void setPackageType(PackageType packageType) {
        this.m_packageType = packageType;
    }

    public void setTitle(String title) {
        this.m_title = title;
    }

    public void setDescription(String description) {
        this.m_description = description;
    }

    public void setApplicationObjectType(String typeName) {
        this.m_typeName = typeName;
    }

    public void setInstantiator(DomainObjectInstantiator instantiator) {
        this.m_instantiator = instantiator;
    }

    public void setWorkspaceApplication(boolean isWorkspaceApplication) {
        this.m_isWorkspaceApplication = isWorkspaceApplication;
    }

    public void setPortalApplication(boolean isWorkspaceApplication) {
        this.m_isWorkspaceApplication = isWorkspaceApplication;
    }

    public void setSingleton(boolean isSingleton) {
        this.m_isSingleton = isSingleton;
    }

    public void setStylesheet(String stylesheet) {
        this.m_stylesheet = stylesheet;
    }

    public void setDispatcherClass(String dispatcherClass) {
        this.m_dispatcherClass = dispatcherClass;
    }

    protected void notice(String message) {
        this.m_category.info((Object)("ApplicationType '" + this.m_title + "' - " + message));
    }

    public ApplicationType run() {
        this.notice("Validating setup...");
        List messages = this.validate();
        if (messages.size() > 0) {
            Iterator iter = messages.iterator();
            String errors = "Validation of ApplicationSetup data failed:\n";
            while (iter.hasNext()) {
                String msg = (String)iter.next();
                this.m_category.error((Object)msg);
                errors = errors + msg + "\n";
            }
            throw new RuntimeException(errors);
        }
        this.notice("Done validating.");
        ApplicationType applicationType = this.process();
        Assert.assertNotNull(applicationType, "applicationType is not null");
        applicationType.save();
        return applicationType;
    }

    protected List validate() {
        ArrayList<String> messages = new ArrayList<String>();
        if (this.m_title == null) {
            messages.add("Title is not set.");
        }
        if (this.m_typeName == null) {
            messages.add("ApplicationObjectType is not set.");
        }
        if (this.m_instantiator == null) {
            messages.add("Instantiator is not set.");
        }
        return messages;
    }

    protected ApplicationType process() {
        this.notice("Starting setup...");
        ApplicationType applicationType = null;
        if (ApplicationType.isInstalled(this.m_typeName)) {
            if (this.m_key != null && !this.packageTypeIsInstalled(this.m_key)) {
                Assert.assertTrue(this.m_packageType == null);
                this.m_category.warn((Object)("ApplicationType " + this.m_typeName + " did not have " + "its corresponding PackageType " + this.m_key + ". Adding " + "one now."));
                PackageType packageType = new PackageType();
                packageType.setKey(this.m_key);
                packageType.setDisplayName(this.m_title);
                packageType.setURI("http://arsdigita.com/" + this.m_key);
                applicationType = ApplicationType.retrieveApplicationTypeForApplication(this.m_typeName);
                applicationType.setPackageType(packageType);
                applicationType.addStylesheet(Stylesheet.createStylesheet(this.m_stylesheet));
                applicationType.setDispatcherClass(this.m_dispatcherClass);
                packageType.save();
                applicationType.save();
            } else {
                applicationType = ApplicationType.retrieveApplicationTypeForApplication(this.m_typeName);
            }
        } else {
            this.notice("Not installed.  Installing now...");
            this.notice("Using the following properties to perform install.");
            this.notice("  ApplicationObjectType: " + this.m_typeName);
            this.notice("  Title: " + this.m_title);
            this.notice("  Description: " + this.m_description);
            this.notice("  Instantiator: " + this.m_instantiator);
            this.notice("  IsWorkspaceApplication: " + this.m_isWorkspaceApplication);
            this.notice("  IsSingleton: " + this.m_isSingleton);
            this.notice("  Key: " + this.m_key);
            this.notice("  PackageType: " + this.m_packageType);
            this.notice("  Stylesheet: " + this.m_stylesheet);
            this.notice("  DispatcherClass: " + this.m_dispatcherClass);
            if (this.m_key == null && this.m_packageType == null) {
                applicationType = new ApplicationType(this.m_title, this.m_typeName);
            } else {
                if (this.m_key == null) {
                    applicationType = ApplicationType.createApplicationType(this.m_packageType, this.m_title, this.m_typeName);
                } else if (this.m_packageType == null) {
                    applicationType = ApplicationType.createApplicationType(this.m_key, this.m_title, this.m_typeName);
                    if (this.m_stylesheet != null) {
                        applicationType.addStylesheet(Stylesheet.createStylesheet(this.m_stylesheet));
                    }
                    if (this.m_dispatcherClass != null) {
                        applicationType.setDispatcherClass(this.m_dispatcherClass);
                    }
                }
                applicationType.setWorkspaceApplication(this.m_isWorkspaceApplication);
                applicationType.setSingleton(this.m_isSingleton);
            }
            applicationType.setDescription(this.m_description);
            this.notice("Done installing.");
        }
        DomainObjectFactory.registerInstantiator(this.m_typeName, this.m_instantiator);
        this.notice("Done setting up.");
        return applicationType;
    }

    private boolean packageTypeIsInstalled(String key) {
        try {
            PackageType.findByKey(key);
            return true;
        }
        catch (DataObjectNotFoundException nfe) {
            return false;
        }
    }
}

