/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.web;

import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.domain.DomainServiceInterfaceExposer;
import com.arsdigita.kernel.ACSObject;
import com.arsdigita.kernel.Kernel;
import com.arsdigita.kernel.KernelExcursion;
import com.arsdigita.kernel.PackageInstance;
import com.arsdigita.kernel.PackageType;
import com.arsdigita.kernel.Resource;
import com.arsdigita.kernel.SiteNode;
import com.arsdigita.persistence.DataAssociation;
import com.arsdigita.persistence.DataAssociationCursor;
import com.arsdigita.persistence.DataCollection;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.DataQuery;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.util.Assert;
import com.arsdigita.web.ApplicationCollection;
import com.arsdigita.web.ApplicationType;
import com.arsdigita.web.BaseDispatcher;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;

public class Application
extends Resource {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/web/Application.java#11 $$Author: dennis $$DateTime: 2004/04/07 16:07:11 $";
    private static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$web$Application == null ? (class$com$arsdigita$web$Application = Application.class$("com.arsdigita.web.Application")) : class$com$arsdigita$web$Application));
    public static final String PRIMARY_URL = "primaryURL";
    private static final String SLASH = "/";
    public static final String BASE_DATA_OBJECT_TYPE = "com.arsdigita.web.Application";
    static /* synthetic */ Class class$com$arsdigita$web$Application;
    static /* synthetic */ Class class$com$arsdigita$web$ApplicationType;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$com$arsdigita$persistence$DataObject;
    static /* synthetic */ Class class$com$arsdigita$kernel$ACSObject;
    static /* synthetic */ Class class$com$arsdigita$kernel$PackageInstance;
    static /* synthetic */ Class class$com$arsdigita$kernel$SiteNode;

    protected String getBaseDataObjectType() {
        return BASE_DATA_OBJECT_TYPE;
    }

    protected Application(DataObject dataObject) {
        super(dataObject);
    }

    protected Application(OID oid) throws DataObjectNotFoundException {
        super(oid);
    }

    public static Application createRootApplication(ApplicationType type, String title) {
        if (Assert.isAssertEnabled()) {
            Assert.exists(type, class$com$arsdigita$web$ApplicationType == null ? (class$com$arsdigita$web$ApplicationType = Application.class$("com.arsdigita.web.ApplicationType")) : class$com$arsdigita$web$ApplicationType);
            Assert.exists(title, class$java$lang$String == null ? (class$java$lang$String = Application.class$("java.lang.String")) : class$java$lang$String);
            Assert.truth(type.m_legacyFree);
        }
        return Application.make(type, null, title, null);
    }

    public static Application createApplication(ApplicationType type, String fragment, String title, Application parent) {
        if (Assert.isAssertEnabled()) {
            Assert.exists(type, class$com$arsdigita$web$ApplicationType == null ? (class$com$arsdigita$web$ApplicationType = Application.class$("com.arsdigita.web.ApplicationType")) : class$com$arsdigita$web$ApplicationType);
            Assert.exists(fragment, class$java$lang$String == null ? (class$java$lang$String = Application.class$("java.lang.String")) : class$java$lang$String);
            Assert.exists(title, class$java$lang$String == null ? (class$java$lang$String = Application.class$("java.lang.String")) : class$java$lang$String);
            Assert.truth(!fragment.equals(""), "The URL fragment must not be the empty string");
        }
        if (type.m_legacyFree) {
            return Application.make(type, fragment, title, parent);
        }
        return Application.legacyMake(type, fragment, title, parent);
    }

    public static Application createApplication(String typeName, String fragment, String title, Application parent) {
        ApplicationType type = ApplicationType.retrieveApplicationTypeForApplication(typeName);
        if (type == null) {
            throw new IllegalArgumentException("No ApplicationType found for type name " + typeName);
        }
        return Application.createApplication(type, fragment, title, parent);
    }

    private static Application make(ApplicationType type, String fragment, String title, Application parent) {
        Application app = (Application)Resource.createResource(type, title, (Resource)parent);
        if (Assert.isAssertEnabled() && fragment != null) {
            Assert.truth(fragment.indexOf(47) == -1, "The URL fragment must not contain slashes; I got '" + fragment + "'");
        }
        if (parent == null) {
            if (fragment == null) {
                app.setPath("");
            } else {
                app.setPath(SLASH + fragment);
            }
        } else {
            app.setPath(parent.getPath() + SLASH + fragment);
        }
        return app;
    }

    private static Application legacyMake(final ApplicationType type, final String fragment, String title, final Application parent) {
        Application application = (Application)Resource.createResource(type, title, (Resource)parent);
        final DataObject dataObject = DomainServiceInterfaceExposer.getDataObject(application);
        final SiteNode[] siteNode = new SiteNode[]{null};
        new KernelExcursion(){

            protected void excurse() {
                this.setParty(Kernel.getSystemParty());
                PackageInstance packageInstance = type.getPackageType().createInstance(type.getTitle());
                dataObject.set("packageInstance", DomainServiceInterfaceExposer.getDataObject(packageInstance));
                if (fragment != null) {
                    siteNode[0] = Application.makeSiteNode(fragment, parent);
                    siteNode[0].mountPackage(packageInstance);
                    siteNode[0].save();
                }
            }
        }.run();
        if (siteNode[0] != null) {
            application.setPrimaryURL(siteNode[0].getURL());
        }
        return application;
    }

    public static Application retrieveApplication(BigDecimal id) {
        OID oid = new OID(BASE_DATA_OBJECT_TYPE, (Object)id);
        return Application.retrieveApplication(oid);
    }

    public static Application retrieveApplication(OID oid) {
        DataObject dataObject = SessionManager.getSession().retrieve(oid);
        if (dataObject == null) {
            return null;
        }
        return Application.retrieveApplication(dataObject);
    }

    public static Application retrieveApplication(DataObject dobj) {
        Assert.exists(dobj, class$com$arsdigita$persistence$DataObject == null ? (class$com$arsdigita$persistence$DataObject = Application.class$("com.arsdigita.persistence.DataObject")) : class$com$arsdigita$persistence$DataObject);
        ACSObject obj = (ACSObject)DomainObjectFactory.newInstance(dobj);
        if (obj instanceof Application) {
            return (Application)obj;
        }
        return Application.getContainingApplication(obj);
    }

    public static final Application getContainingApplication(ACSObject obj) {
        ACSObject result;
        Assert.exists(obj, class$com$arsdigita$kernel$ACSObject == null ? (class$com$arsdigita$kernel$ACSObject = Application.class$("com.arsdigita.kernel.ACSObject")) : class$com$arsdigita$kernel$ACSObject);
        for (result = obj.gimmeContainer(); result != null && !(result instanceof Application); result = result.gimmeContainer()) {
        }
        return (Application)result;
    }

    public static Application retrieveApplicationForSiteNode(SiteNode siteNode) {
        DataQuery query = SessionManager.getSession().retrieveQuery("com.arsdigita.web.applicationForSiteNodeID");
        query.setParameter("siteNodeID", siteNode.getID());
        Application application = null;
        if (query.next()) {
            DataObject dataObject = (DataObject)query.get("application");
            application = Application.retrieveApplication(dataObject);
        }
        query.close();
        return application;
    }

    public static Application retrieveApplicationForPath(String path) {
        DataCollection dataCollection = SessionManager.getSession().retrieve(BASE_DATA_OBJECT_TYPE);
        dataCollection.addEqualsFilter(PRIMARY_URL, path);
        if (dataCollection.next()) {
            DataObject dataObject = dataCollection.getDataObject();
            dataCollection.close();
            return Application.retrieveApplication(dataObject);
        }
        return null;
    }

    public ApplicationType getApplicationType() {
        DataObject dataObject = (DataObject)this.get("resourceType");
        Assert.exists(dataObject, class$com$arsdigita$persistence$DataObject == null ? (class$com$arsdigita$persistence$DataObject = Application.class$("com.arsdigita.persistence.DataObject")) : class$com$arsdigita$persistence$DataObject);
        dataObject.specialize("com.arsdigita.web.ApplicationType");
        return new ApplicationType(dataObject);
    }

    protected void setApplicationType(ApplicationType applicationType) {
        Assert.exists(applicationType, class$com$arsdigita$web$Application == null ? (class$com$arsdigita$web$Application = Application.class$(BASE_DATA_OBJECT_TYPE)) : class$com$arsdigita$web$Application);
        this.setAssociation("resourceType", applicationType);
    }

    public PackageType getPackageType() {
        return this.getApplicationType().getPackageType();
    }

    public Application getParentApplication() {
        return (Application)this.getParentResource();
    }

    public List getAncestorApplications() {
        ArrayList<Resource> list = new ArrayList<Resource>();
        for (Resource ancestor = this.getParentResource(); ancestor != null; ancestor = ancestor.getParentResource()) {
            if (!(ancestor instanceof Application)) continue;
            list.add(0, ancestor);
        }
        return list;
    }

    public void setParentApplication(Application application) {
        this.setParentResource(application);
    }

    public ApplicationCollection getChildApplications() {
        ApplicationCollection children = Application.retrieveAllApplications();
        children.addEqualsFilter("parentResource.id", this.getID());
        return children;
    }

    public ApplicationCollection getChildApplicationsForType(String applicationType) {
        ApplicationCollection children = this.getChildApplications();
        children.addEqualsFilter("objectType", applicationType);
        return children;
    }

    private PackageInstance getPackageInstance() {
        DataObject dataObject = (DataObject)this.get("packageInstance");
        Assert.exists(dataObject, class$com$arsdigita$persistence$DataObject == null ? (class$com$arsdigita$persistence$DataObject = Application.class$("com.arsdigita.persistence.DataObject")) : class$com$arsdigita$persistence$DataObject);
        return new PackageInstance(dataObject);
    }

    private void setPackageInstance(PackageInstance packageInstance) {
        Assert.exists(packageInstance, class$com$arsdigita$kernel$PackageInstance == null ? (class$com$arsdigita$kernel$PackageInstance = Application.class$("com.arsdigita.kernel.PackageInstance")) : class$com$arsdigita$kernel$PackageInstance);
        this.setAssociation("packageInstance", packageInstance);
    }

    public SiteNode getSiteNode() {
        DataObject packageInstance = (DataObject)this.get("packageInstance");
        DataAssociation siteNodes = (DataAssociation)packageInstance.get("mountPoint");
        DataAssociationCursor siteNodesCursor = siteNodes.cursor();
        DataObject siteNode = null;
        if (siteNodesCursor.next()) {
            siteNode = siteNodesCursor.getDataObject();
        }
        siteNodesCursor.close();
        if (siteNode == null) {
            return null;
        }
        return new SiteNode(siteNode);
    }

    public static Application getCurrentApplication(HttpServletRequest req) {
        Resource result = Kernel.getContext().getResource();
        if (result instanceof Application) {
            return (Application)result;
        }
        return null;
    }

    public String getPrimaryURL() {
        String path = (String)this.get(PRIMARY_URL);
        if (path == null) {
            return null;
        }
        if (path.endsWith(SLASH)) {
            return path;
        }
        return path + SLASH;
    }

    public final String getPath() {
        String path = (String)this.get(PRIMARY_URL);
        Assert.exists(path, class$java$lang$String == null ? (class$java$lang$String = Application.class$("java.lang.String")) : class$java$lang$String);
        if (path.endsWith(SLASH)) {
            return path.substring(0, path.length() - 1);
        }
        return path;
    }

    private void setPrimaryURL(String primaryURL) {
        this.set(PRIMARY_URL, primaryURL);
    }

    public final void setPath(String path) {
        if (Assert.isAssertEnabled()) {
            Assert.exists(path, class$java$lang$String == null ? (class$java$lang$String = Application.class$("java.lang.String")) : class$java$lang$String);
            Assert.truth(path.equals("") || path.startsWith(SLASH) && !path.endsWith(SLASH), "The path must either be the empty string (for the default application) or it must start with '/' and *not* end in '/'; I got '" + path + "'");
        }
        this.set(PRIMARY_URL, path);
    }

    public Collection getRelevantPrivileges() {
        return this.getApplicationType().getRelevantPrivileges();
    }

    public static ApplicationCollection retrieveAllApplications() {
        DataCollection dataCollection = SessionManager.getSession().retrieve(BASE_DATA_OBJECT_TYPE);
        dataCollection.addEqualsFilter("resourceType.hasFullPageView", Boolean.TRUE);
        ApplicationCollection apps = new ApplicationCollection(dataCollection);
        return apps;
    }

    public static boolean isInstalled(String applicationObjectType, String path) {
        DataCollection dataCollection = SessionManager.getSession().retrieve(applicationObjectType);
        dataCollection.addEqualsFilter(PRIMARY_URL, path);
        if (dataCollection.next()) {
            dataCollection.close();
            return true;
        }
        return false;
    }

    private static SiteNode makeSiteNode(String urlName, Application parent) {
        SiteNode siteNode;
        if (parent == null) {
            siteNode = SiteNode.createSiteNode(urlName);
        } else {
            SiteNode parentSiteNode = parent.getSiteNode();
            Assert.exists(parentSiteNode, class$com$arsdigita$web$Application == null ? (class$com$arsdigita$web$Application = Application.class$(BASE_DATA_OBJECT_TYPE)) : class$com$arsdigita$web$Application);
            siteNode = SiteNode.createSiteNode(urlName, parentSiteNode);
        }
        Assert.exists(siteNode, class$com$arsdigita$kernel$SiteNode == null ? (class$com$arsdigita$kernel$SiteNode = Application.class$("com.arsdigita.kernel.SiteNode")) : class$com$arsdigita$kernel$SiteNode);
        return siteNode;
    }

    public static String getCanonicalURL(String url) {
        String canonicalURL = (url = url.trim()).startsWith(SLASH) ? url : SLASH + url;
        return url.endsWith(SLASH) ? canonicalURL : canonicalURL + SLASH;
    }

    public String getContextPath() {
        return "";
    }

    public String getServletPath() {
        return "/__ccm__/servlet/legacy-adapter";
    }

    public String getStylesheetPath() {
        return "/__ccm__/xsl/core-platform.xsl";
    }

    protected void beforeSave() {
        if (this.isPropertyModified(PRIMARY_URL) || this.isNew()) {
            BaseDispatcher.scheduleRefresh();
        }
        super.beforeSave();
    }

    public void afterDelete() {
        BaseDispatcher.scheduleRefresh();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

