/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.versioning;

import com.arsdigita.auditing.AuditingSaveFactory;
import com.arsdigita.auditing.AuditingSaveInfo;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.kernel.User;
import com.arsdigita.persistence.DataAssociation;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.persistence.metadata.ObjectType;
import com.arsdigita.util.Assert;
import com.arsdigita.versioning.Adapter;
import com.arsdigita.versioning.Constants;
import com.arsdigita.versioning.DataObjectChange;
import com.arsdigita.versioning.Initializer;
import com.arsdigita.versioning.ObjectTypeMetadata;
import com.arsdigita.versioning.functions;
import com.redhat.persistence.AddEvent;
import com.redhat.persistence.CreateEvent;
import com.redhat.persistence.DeleteEvent;
import com.redhat.persistence.Event;
import com.redhat.persistence.EventProcessor;
import com.redhat.persistence.ObjectEvent;
import com.redhat.persistence.PropertyEvent;
import com.redhat.persistence.RemoveEvent;
import com.redhat.persistence.SetEvent;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

final class VersioningEventProcessor
extends EventProcessor
implements Constants {
    private static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$versioning$VersioningEventProcessor == null ? (class$com$arsdigita$versioning$VersioningEventProcessor = VersioningEventProcessor.class$("com.arsdigita.versioning.VersioningEventProcessor")) : class$com$arsdigita$versioning$VersioningEventProcessor));
    private Event.Switch m_switch = new EventSwitch();
    private VersioningTxn m_vTxn = null;
    private boolean m_suspended = false;
    static /* synthetic */ Class class$com$arsdigita$versioning$VersioningEventProcessor;
    static /* synthetic */ Class class$com$arsdigita$persistence$DataObject;

    VersioningEventProcessor() {
    }

    protected void write(Event event) {
        event.dispatch(this.m_switch);
    }

    protected void flush() {
    }

    protected void cleanUp(boolean isCommit) {
        if (this.m_vTxn != null) {
            this.m_vTxn.cleanUp();
        }
        this.m_vTxn = null;
        this.m_suspended = false;
    }

    void tag(OID oid, String tag) {
        this.getTxn().tag(oid, tag);
    }

    void suspendVersioning() {
        this.m_suspended = true;
    }

    void resumeVersioning() {
        this.m_suspended = false;
    }

    private VersioningTxn getTxn() {
        if (this.m_vTxn == null) {
            this.m_vTxn = new VersioningTxn();
        }
        return this.m_vTxn;
    }

    private static boolean isCommitted(Event ev) {
        return ((DataObject)ev.getObject()).isCommitted();
    }

    private boolean canBeIgnored(PropertyEvent ev) {
        if (this.m_suspended || !VersioningEventProcessor.isCommitted(ev)) {
            return true;
        }
        ObjectType objType = functions.getObjectType(ev);
        String modelName = objType.getModel().getName();
        if ("com.arsdigita.versioning".equals(modelName)) {
            return true;
        }
        if (VersioningEventProcessor.isUnversionedProperty(objType.getQualifiedName(), ev.getProperty().getName())) {
            return true;
        }
        return VersioningEventProcessor.isUnreachable(objType.getQualifiedName());
    }

    private boolean canBeIgnored(ObjectEvent ev) {
        if (!Initializer.hasRun()) {
            return true;
        }
        if (this.m_suspended) {
            return true;
        }
        ObjectType objType = functions.getObjectType(ev);
        if ("com.arsdigita.versioning".equals(objType.getModel().getName())) {
            return true;
        }
        return VersioningEventProcessor.isUnreachable(objType.getQualifiedName());
    }

    private static boolean isUnreachable(String objTypeName) {
        return ObjectTypeMetadata.getInstance().isUnreachable(objTypeName);
    }

    private static boolean isUnversionedProperty(String containerName, String propertyName) {
        return ObjectTypeMetadata.getInstance().isUnversionedProperty(containerName, propertyName);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class VersioningTxn {
        private Map m_dobjChanges = new HashMap();
        private DataObject m_txn = SessionManager.getSession().create("com.arsdigita.versioning.Txn");

        public VersioningTxn() {
            this.m_txn.set("id", functions.nextTxnID());
            this.addAuditTrail();
        }

        public DataObjectChange getDataObjectChange(OID oid) {
            DataObjectChange result = (DataObjectChange)this.m_dobjChanges.get(oid);
            if (result != null) {
                return result;
            }
            result = new DataObjectChange(oid);
            this.m_dobjChanges.put(oid, result);
            result.setTxn(this.m_txn);
            return result;
        }

        public DataObjectChange getDataObjectChange(DataObject dobj) {
            Assert.exists(dobj, class$com$arsdigita$persistence$DataObject == null ? (class$com$arsdigita$persistence$DataObject = VersioningEventProcessor.class$("com.arsdigita.persistence.DataObject")) : class$com$arsdigita$persistence$DataObject);
            return this.getDataObjectChange(dobj.getOID());
        }

        public void cleanUp() {
            this.m_dobjChanges.clear();
        }

        public void tag(OID oid, String tag) {
            DataObject tagDobj = SessionManager.getSession().create("com.arsdigita.versioning.Tag");
            tagDobj.set("id", functions.nextSequenceValue());
            tagDobj.set("tag", tag);
            tagDobj.set("taggedOID", Adapter.serialize(oid));
            ((DataAssociation)this.m_txn.get("tags")).add(tagDobj);
        }

        private void addAuditTrail() {
            AuditingSaveInfo auditInfo = AuditingSaveFactory.newInstance();
            Date timestamp = auditInfo.getSaveDate();
            this.m_txn.set("timestamp", timestamp);
            this.m_txn.set("modifyingIP", auditInfo.getSaveIP());
            User user = auditInfo.getSaveUser();
            if (user != null) {
                new DomainObject(this.m_txn){

                    public void set(String attr, Object value) {
                        super.set(attr, value);
                    }
                }.set("modUser", user);
            }
        }
    }

    private class EventSwitch
    extends Event.Switch {
        private EventSwitch() {
        }

        public void onSet(SetEvent ev) {
            if (VersioningEventProcessor.this.canBeIgnored(ev)) {
                return;
            }
            this.getChange(ev).recordEvent(ev);
        }

        public void onAdd(AddEvent ev) {
            if (VersioningEventProcessor.this.canBeIgnored(ev)) {
                return;
            }
            this.getChange(ev).recordEvent(ev);
        }

        public void onRemove(RemoveEvent ev) {
            if (VersioningEventProcessor.this.canBeIgnored(ev)) {
                return;
            }
            this.getChange(ev).recordEvent(ev);
        }

        private DataObjectChange getChange(Event ev) {
            return VersioningEventProcessor.this.getTxn().getDataObjectChange((DataObject)ev.getObject());
        }

        public void onCreate(CreateEvent ev) {
            if (VersioningEventProcessor.this.canBeIgnored(ev)) {
                return;
            }
            this.getChange(ev).recordEvent(ev);
        }

        public void onDelete(DeleteEvent ev) {
            if (VersioningEventProcessor.this.canBeIgnored(ev)) {
                return;
            }
            this.getChange(ev).recordEvent(ev);
        }
    }
}

