/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.versioning;

import com.arsdigita.persistence.DataAssociation;
import com.arsdigita.persistence.DataAssociationCursor;
import com.arsdigita.persistence.DataCollection;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.persistence.metadata.ObjectType;
import com.arsdigita.persistence.metadata.Property;
import com.arsdigita.util.Assert;
import com.arsdigita.util.AssertionError;
import com.arsdigita.versioning.Constants;
import com.arsdigita.versioning.DataObjectDiff;
import com.arsdigita.versioning.Difference;
import com.arsdigita.versioning.ObjectChangeCollection;
import com.arsdigita.versioning.ObjectTypeMetadata;
import com.arsdigita.versioning.QueueMap;
import com.arsdigita.versioning.RollbackAdapter;
import com.arsdigita.versioning.RollbackListener;
import com.arsdigita.versioning.VersioningException;
import java.math.BigInteger;
import java.util.Iterator;
import org.apache.log4j.Logger;

final class DiffSet
implements Constants {
    private static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$versioning$DiffSet == null ? (class$com$arsdigita$versioning$DiffSet = DiffSet.class$("com.arsdigita.versioning.DiffSet")) : class$com$arsdigita$versioning$DiffSet));
    private QueueMap m_queue;
    private BigInteger m_txnID;
    private DataObjectDiff m_firstEnqueued;
    private RollbackListener m_listener;
    private final ObjectTypeMetadata m_otmd;
    static /* synthetic */ Class class$com$arsdigita$versioning$DiffSet;
    static /* synthetic */ Class class$com$arsdigita$persistence$OID;

    public DiffSet(OID oid, BigInteger txnID) throws NoSuchTxnException {
        this(oid, txnID, null);
    }

    public DiffSet(OID oid, BigInteger txnID, RollbackListener listener) {
        Assert.exists(oid, class$com$arsdigita$persistence$OID == null ? (class$com$arsdigita$persistence$OID = DiffSet.class$("com.arsdigita.persistence.OID")) : class$com$arsdigita$persistence$OID);
        this.m_txnID = txnID;
        this.m_queue = new QueueMap();
        this.m_listener = listener == null ? new RollbackAdapter() : listener;
        this.m_firstEnqueued = this.enqueue(oid);
        this.m_otmd = ObjectTypeMetadata.getInstance();
    }

    private DataObjectDiff enqueue(OID oid) {
        Assert.exists(oid, class$com$arsdigita$persistence$OID == null ? (class$com$arsdigita$persistence$OID = DiffSet.class$("com.arsdigita.persistence.OID")) : class$com$arsdigita$persistence$OID);
        if (this.m_queue.contains(oid)) {
            return (DataObjectDiff)this.m_queue.get(oid);
        }
        DataObjectDiff dobjDiff = new DataObjectDiff(oid, this.m_listener);
        this.m_queue.enqueue(oid, dobjDiff);
        this.m_listener.onEnqueue(oid);
        return dobjDiff;
    }

    private DataObjectDiff dequeue() {
        DataObjectDiff dobjDiff = (DataObjectDiff)this.m_queue.dequeue();
        this.m_listener.onDequeue(dobjDiff.getOID());
        return dobjDiff;
    }

    public DataObjectDiff get(OID oid) throws IllegalArgumentException {
        DataObjectDiff result = (DataObjectDiff)this.m_queue.get(oid);
        if (result == null) {
            throw new IllegalArgumentException("No data object diff for this oid: " + oid);
        }
        return result;
    }

    private boolean hasNext() {
        return this.m_queue.hasNext();
    }

    private void rewind() {
        this.m_queue.rewind();
    }

    public DataObject rollback() {
        this.computeDifferences();
        this.reify();
        this.applyDifferences();
        this.removeTerminalObjects();
        return this.m_firstEnqueued.getDataObject();
    }

    void computeDifferences() {
        this.m_listener.onDiffStart();
        while (this.hasNext()) {
            DataObjectDiff dobjDiff = this.dequeue();
            ObjectChangeCollection occ = new ObjectChangeCollection(dobjDiff.getOID(), this.m_txnID);
            DiffSet.computeDiff(dobjDiff, occ);
            ObjectType objType = dobjDiff.getOID().getObjectType();
            if (this.m_otmd.isFullyVersioned(objType)) {
                this.enqueueCompoundAttributes(dobjDiff);
            }
            if (!this.m_otmd.isUnreachable(objType)) {
                this.enqueueComponents(dobjDiff);
            }
            occ.close();
        }
        this.rewind();
        this.m_listener.onDiffFinish();
    }

    Difference diff(BigInteger toID) {
        DiffSet to;
        this.computeDifferences();
        if (toID == null) {
            to = null;
        } else {
            to = new DiffSet(this.m_firstEnqueued.getOID(), toID);
            to.computeDifferences();
        }
        Difference result = new Difference();
        while (this.hasNext()) {
            DataObjectDiff dobjDiff = this.dequeue();
            if (to == null) {
                dobjDiff.diff(null, result);
                continue;
            }
            dobjDiff.diff((DataObjectDiff)to.m_queue.get(dobjDiff.getOID()), result);
        }
        this.rewind();
        return result;
    }

    private static void computeDiff(DataObjectDiff dobjDiff, ObjectChangeCollection occ) {
        while (occ.next()) {
            DataCollection ops = occ.getOperations();
            while (ops.next()) {
                BigInteger id = (BigInteger)ops.get("id");
                Integer opType = (Integer)ops.get("subtype");
                DataObject op = DiffSet.specializeOperation(id, opType);
                dobjDiff.undoEvent(op);
            }
        }
    }

    private static DataObject specializeOperation(BigInteger id, Integer opType) {
        OID oid = null;
        if (Constants.GENERIC_OPERATION.integerValue().equals(opType)) {
            oid = new OID(Constants.GENERIC_OPERATION.datatype(), (Object)id);
        } else if (Constants.CLOB_OPERATION.integerValue().equals(opType)) {
            oid = new OID(Constants.CLOB_OPERATION.datatype(), (Object)id);
        } else if (Constants.BLOB_OPERATION.integerValue().equals(opType)) {
            oid = new OID(Constants.BLOB_OPERATION.datatype(), (Object)id);
        } else {
            throw new AssertionError("can't happen: id=" + id + ", opType" + opType);
        }
        return SessionManager.getSession().retrieve(oid);
    }

    private void enqueueCompoundAttributes(DataObjectDiff dobjDiff) {
        Iterator oids = dobjDiff.compoundAttributes();
        while (oids.hasNext()) {
            this.enqueue((OID)oids.next());
        }
    }

    private void enqueueComponents(DataObjectDiff dobjDiff) {
        DataObject dobj = SessionManager.getSession().retrieve(dobjDiff.getOID());
        if (dobj == null) {
            return;
        }
        ObjectType type = dobjDiff.getOID().getObjectType();
        ObjectTypeMetadata otmd = ObjectTypeMetadata.getInstance();
        Iterator props = type.getProperties();
        while (props.hasNext()) {
            Property prop = (Property)props.next();
            if (!prop.isComponent() || otmd.isUnversionedProperty(prop) || prop.getType().isSimple() || otmd.isUnreachable((ObjectType)prop.getType())) continue;
            if (prop.isCollection()) {
                DataAssociationCursor cur = ((DataAssociation)dobj.get(prop.getName())).cursor();
                while (cur.next()) {
                    this.enqueue(cur.getDataObject().getOID());
                }
                cur.close();
                continue;
            }
            DataObject comp = (DataObject)dobj.get(prop.getName());
            if (comp == null) continue;
            this.enqueue(comp.getOID());
        }
    }

    private void reify() {
        this.m_listener.onReifyStart();
        while (this.hasNext()) {
            DataObjectDiff dobjDiff = this.dequeue();
            this.m_listener.onReifyStart(dobjDiff.getOID(), dobjDiff.getState());
            dobjDiff.reify();
            this.m_listener.onReifyFinish(dobjDiff.getOID(), dobjDiff.getState());
        }
        this.rewind();
        while (this.hasNext()) {
            this.dequeue().reifyCompoundAttributes(this);
        }
        this.rewind();
        this.m_listener.onReifyFinish();
    }

    private void applyDifferences() {
        this.m_listener.onApplyStart();
        while (this.hasNext()) {
            DataObjectDiff dobjDiff = this.dequeue();
            this.m_listener.onApplyStart(dobjDiff.getOID(), dobjDiff.getState());
            dobjDiff.apply();
            this.m_listener.onApplyFinish(dobjDiff.getOID());
        }
        this.rewind();
        this.m_listener.onApplyFinish();
    }

    private void removeTerminalObjects() {
        this.m_listener.onTerminalStart();
        while (this.hasNext()) {
            DataObjectDiff dobjDiff = this.dequeue();
            dobjDiff.deleteIfTerminal();
        }
        this.m_listener.onTerminalFinish();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class NoSuchTxnException
    extends VersioningException {
        private final OID m_oid;

        public NoSuchTxnException(OID oid) {
            this.m_oid = oid;
        }

        public String getMessage() {
            return "No such txn: " + this.m_oid;
        }
    }
}

