/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.util.url;

import com.arsdigita.util.Assert;
import com.arsdigita.util.StringUtils;
import com.arsdigita.util.url.URLData;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.apache.log4j.Logger;

public class URLCache {
    private static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$util$url$URLCache == null ? (class$com$arsdigita$util$url$URLCache = URLCache.class$("com.arsdigita.util.url.URLCache")) : class$com$arsdigita$util$url$URLCache));
    private HashMap m_cache = new HashMap();
    private long m_maxSize;
    private long m_defaultExpiryTime;
    private long m_curSize = 0L;
    public static final int FIFTEEN_MINUTES = 900000;
    static /* synthetic */ Class class$com$arsdigita$util$url$URLCache;

    public URLCache() {
        this(10000000L, 900000L);
    }

    public URLCache(long size) {
        this(size, 900000L);
    }

    public URLCache(long size, long expiryTime) {
        URLCache.assertCacheSize(size);
        URLCache.assertExpiryTime(expiryTime);
        this.m_maxSize = size;
        this.m_defaultExpiryTime = expiryTime;
    }

    public long getCurrentSize() {
        return this.m_curSize;
    }

    public long getMaxSize() {
        return this.m_maxSize;
    }

    public Collection getURLS() {
        LinkedList list = new LinkedList(this.m_cache.keySet());
        return list;
    }

    public synchronized void setMaxSize(long maxSize) {
        URLCache.assertCacheSize(maxSize);
        long oldSize = this.m_maxSize;
        this.m_maxSize = maxSize;
        if (oldSize > maxSize) {
            this.makeRoomInCache(0L);
        }
    }

    public long getDefaultExpiryTime() {
        return this.m_defaultExpiryTime;
    }

    public synchronized void setDefaultExpiryTime(long defaultExpiryTime) {
        URLCache.assertExpiryTime(defaultExpiryTime);
        this.m_defaultExpiryTime = defaultExpiryTime;
    }

    public synchronized void store(String url, String data) {
        URLData urlData = new URLData(url);
        urlData.setContent(data.getBytes());
        this.store(url, urlData);
    }

    public synchronized void store(String url, URLData data) {
        this.store(url, data, this.m_defaultExpiryTime);
    }

    public synchronized void store(String url, String data, long expiry) {
        URLData urlData = new URLData(url);
        urlData.setContent(data.getBytes());
        this.store(url, urlData, expiry);
    }

    public synchronized void store(String url, URLData data, long expiry) {
        long newSize;
        URLCache.assertURL(url);
        if (null == data) {
            throw new IllegalArgumentException("Data can be empty, but not null!");
        }
        URLCache.assertExpiryTime(expiry);
        long dataSize = data.getContent().length + url.length();
        if (dataSize > this.m_maxSize) {
            throw new IllegalArgumentException("Cannot store data greater than maximum Cache size: " + this.m_maxSize + ". URL is " + url.length() + " Data is: " + data.getContent().length);
        }
        s_log.debug((Object)("Storing location URL " + url + " in the URLCache."));
        if (this.retrieve(url) != null) {
            this.purge(url);
        }
        if ((newSize = this.m_curSize + dataSize) > this.m_maxSize) {
            this.makeRoomInCache(dataSize);
        }
        this.addToCache(url, data, expiry);
    }

    private synchronized void makeRoomInCache(long dataSize) {
        long newSize;
        this.purgeExpired();
        if (newSize > this.m_maxSize) {
            long entrySize;
            Iterator iter = this.m_cache.entrySet().iterator();
            for (newSize = this.m_curSize + dataSize; newSize > this.m_maxSize && iter.hasNext(); newSize -= entrySize) {
                Map.Entry ent = iter.next();
                String entryURL = (String)ent.getKey();
                Entry e2 = (Entry)ent.getValue();
                entrySize = entryURL.length() + e2.data.getContent().length;
                iter.remove();
                this.m_curSize -= entrySize;
            }
        }
    }

    private synchronized void addToCache(String url, URLData data, long expiry) {
        long dataSize = data.getContent().length + url.length();
        Assert.assertTrue(this.m_curSize + dataSize <= this.m_maxSize);
        Entry e = new Entry(data, System.currentTimeMillis(), expiry);
        this.m_cache.put(url, e);
        this.m_curSize += dataSize;
    }

    public synchronized void purge(String url) {
        URLCache.assertURL(url);
        s_log.debug((Object)("Evicting " + url + " from the URLCache."));
        Entry e = (Entry)this.m_cache.get(url);
        if (e != null) {
            this.m_cache.remove(url);
            this.m_curSize = this.m_curSize - (long)url.length() - (long)e.data.getContent().length;
        }
    }

    public synchronized void purgeAll() {
        this.m_cache.clear();
        this.m_curSize = 0L;
    }

    public synchronized void purgeExpired() {
        Iterator iter = this.m_cache.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry ent = iter.next();
            String entryURL = (String)ent.getKey();
            Entry e2 = (Entry)ent.getValue();
            if (!e2.isExpired()) continue;
            iter.remove();
            this.m_curSize = this.m_curSize - (long)entryURL.length() - (long)e2.data.getContent().length;
        }
    }

    public String retrieve(String url) {
        URLData data = this.retrieveData(url);
        if (data != null) {
            return data.getContentAsString();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URLData retrieveData(String url) {
        URLCache.assertURL(url);
        s_log.debug((Object)("Trying to retrieve " + url + " from the URLCache."));
        Entry e = null;
        URLCache uRLCache = this;
        synchronized (uRLCache) {
            e = (Entry)this.m_cache.get(url);
        }
        if (e == null) {
            return null;
        }
        if (e.isExpired()) {
            this.purge(url);
            return null;
        }
        e.lastUse = System.currentTimeMillis();
        s_log.debug((Object)("URL " + url + " is in the cache."));
        return e.data;
    }

    private static void assertExpiryTime(long expiryTime) {
        if (expiryTime < 0L) {
            throw new IllegalArgumentException("Expiry time must be non negative: " + expiryTime);
        }
    }

    private static void assertCacheSize(long size) {
        if (size <= 0L) {
            throw new IllegalArgumentException("Cache size must be greater than 0. " + size);
        }
    }

    private static void assertURL(String url) {
        if (StringUtils.emptyString(url)) {
            throw new IllegalArgumentException("URL cannot be empty!");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private final class Entry {
        final URLData data;
        long lastUse;
        final long creationTime;
        final long expiry;

        Entry(URLData data, long lastUse, long expiry) {
            this.data = data;
            this.lastUse = lastUse;
            this.creationTime = System.currentTimeMillis();
            this.expiry = expiry;
        }

        boolean isExpired() {
            long now = System.currentTimeMillis();
            boolean expired = this.expiry > 0L && this.creationTime < now - this.expiry;
            return expired;
        }
    }
}

