/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.util;

import com.arsdigita.util.Assert;
import com.arsdigita.util.StringUtils;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class CallTracer {
    private final Logger m_logger;
    private final int m_frequency;
    private final int m_level;
    private final Map m_methods = new HashMap();
    static /* synthetic */ Class class$com$arsdigita$util$CallTracer;

    public CallTracer(Class theClass, int frequency) {
        this(theClass, frequency, 1);
    }

    public CallTracer(Class theClass, int frequency, int level) {
        this.m_logger = Logger.getLogger((Class)theClass);
        this.m_frequency = frequency;
        this.m_level = level;
    }

    public void trace() {
        if (this.m_logger.isDebugEnabled()) {
            List trace = StringUtils.getStackList(new Throwable());
            String method = (String)trace.get(2);
            String caller = CallTracer.getCallerFromTrace(this.m_level, trace);
            this.incrementCount(method, caller);
        }
    }

    private void incrementCount(String method, String caller) {
        MethodTrace trace = this.getMethodTrace(method);
        trace.incrementCount(method, caller);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MethodTrace getMethodTrace(String method) {
        MethodTrace trace;
        Map map = this.m_methods;
        synchronized (map) {
            trace = (MethodTrace)this.m_methods.get(method);
            if (trace == null) {
                trace = new MethodTrace();
                this.m_methods.put(method, trace);
            }
        }
        return trace;
    }

    public static String getCaller() {
        List trace = StringUtils.getStackList(new Throwable());
        return CallTracer.getCallerFromTrace(1, trace);
    }

    public static String getCaller(int level) {
        Assert.truth(level > 0, "Level must be greater than zero!");
        List trace = StringUtils.getStackList(new Throwable());
        return CallTracer.getCallerFromTrace(level, trace);
    }

    private static String getCallerFromTrace(int level, List trace) {
        int entryIdx = level + 2;
        if (entryIdx >= trace.size()) {
            Logger.getLogger((Class)(class$com$arsdigita$util$CallTracer == null ? (class$com$arsdigita$util$CallTracer = CallTracer.class$("com.arsdigita.util.CallTracer")) : class$com$arsdigita$util$CallTracer)).warn((Object)("Level " + level + " is too deep; called from " + trace.get(2) + ". Getting last entry instead."));
            entryIdx = trace.size() - 1;
        }
        String caller = (String)trace.get(entryIdx);
        return caller;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private final class MethodTrace {
        private final HashMap m_callers = new HashMap();
        private long m_totalCalls = 0L;

        private MethodTrace() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void incrementCount(String method, String caller) {
            HashMap hashMap = this.m_callers;
            synchronized (hashMap) {
                Integer count = (Integer)this.m_callers.get(caller);
                if (count == null) {
                    count = new Integer(0);
                }
                count = new Integer(count + 1);
                this.m_callers.put(caller, count);
                ++this.m_totalCalls;
                if (this.m_totalCalls % (long)CallTracer.this.m_frequency == 0L) {
                    this.logCalls(method);
                }
            }
        }

        private void logCalls(String method) {
            CallTracer.this.m_logger.debug((Object)("----------- Callers for method " + method + " -----------"));
            CallTracer.this.m_logger.debug((Object)(this.m_totalCalls + " total so far."));
            Iterator iter = this.m_callers.keySet().iterator();
            while (iter.hasNext()) {
                String caller = (String)iter.next();
                Integer count = (Integer)this.m_callers.get(caller);
                CallTracer.this.m_logger.debug((Object)(caller + " called " + count + " times."));
            }
            CallTracer.this.m_logger.debug((Object)"----------- DONE -----------");
        }
    }
}

