/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.ui.permissions;

import com.arsdigita.bebop.BoxPanel;
import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Form;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.Page;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.RequestLocal;
import com.arsdigita.bebop.Resettable;
import com.arsdigita.bebop.SegmentedPanel;
import com.arsdigita.bebop.SimpleComponent;
import com.arsdigita.bebop.SimpleContainer;
import com.arsdigita.bebop.event.ActionEvent;
import com.arsdigita.bebop.event.ActionListener;
import com.arsdigita.bebop.parameters.ArrayParameter;
import com.arsdigita.bebop.parameters.BigDecimalParameter;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.bebop.parameters.StringParameter;
import com.arsdigita.kernel.ACSObject;
import com.arsdigita.kernel.Party;
import com.arsdigita.kernel.permissions.PermissionDescriptor;
import com.arsdigita.kernel.permissions.PermissionService;
import com.arsdigita.kernel.permissions.PrivilegeDescriptor;
import com.arsdigita.ui.permissions.PermissionsConstants;
import com.arsdigita.ui.permissions.PermissionsGrant;
import com.arsdigita.ui.permissions.PermissionsHeader;
import com.arsdigita.ui.permissions.PermissionsTables;
import com.arsdigita.ui.permissions.UserObjectStruct;
import com.arsdigita.ui.permissions.UserSearchForm;
import com.arsdigita.web.RedirectSignal;
import com.arsdigita.web.URL;

public class PermissionsPane
extends SimpleContainer
implements Resettable,
ActionListener,
PermissionsConstants {
    private ParameterModel m_object_id_param = new BigDecimalParameter("po_id");
    private ParameterModel m_searchString = new StringParameter("query");
    private ParameterModel m_privArray = new ArrayParameter("privs_set");
    private PrivilegeDescriptor[] m_privileges;
    private PermissionsTables m_allPermissions;
    private PermissionsHeader m_PermissionsHeader;
    private SimpleContainer m_DirectPermissions;
    private Form m_UserSearchForm;
    private SimpleContainer m_InheritedPermissions;
    private SimpleComponent m_ContextPanel;
    private SimpleContainer m_PermissionsGrantPanel;
    private SimpleContainer m_NoResultsPanel;
    private RequestLocal m_UserObjectInfo = new RequestLocal(){

        protected Object initialValue(PageState s) {
            return new UserObjectStruct(s);
        }
    };

    public PermissionsPane() {
        this(PermissionsConstants.DEFAULT_PRIVILEGES);
    }

    public PermissionsPane(PrivilegeDescriptor[] privs) {
        this.m_privileges = privs;
    }

    public void register(Page p) {
        super.register(p);
        this.add(this.getPermissionsHeader());
        this.add(this.getDirectPermissionsPanel());
        this.add(this.getUserSearchForm());
        this.add(this.getInheritedPermissionsPanel());
        this.add(this.getContextPanel());
        this.add(this.getPermissionGrantPanel());
        this.add(this.getNoSearchResultPanel());
        p.setVisibleDefault(this.getPermissionsHeader(), true);
        p.setVisibleDefault(this.getDirectPermissionsPanel(), true);
        p.setVisibleDefault(this.getUserSearchForm(), true);
        p.setVisibleDefault(this.getInheritedPermissionsPanel(), true);
        p.setVisibleDefault(this.getContextPanel(), true);
        p.setVisibleDefault(this.getPermissionGrantPanel(), false);
        p.setVisibleDefault(this.getNoSearchResultPanel(), false);
        p.addActionListener(this);
        p.addGlobalStateParam(this.m_object_id_param);
        p.addGlobalStateParam(this.m_searchString);
        p.addGlobalStateParam(this.m_privArray);
    }

    public void reset(PageState ps) {
        this.showAdmin(ps);
    }

    public Party getRequestingUser(PageState s) {
        return ((UserObjectStruct)this.m_UserObjectInfo.get(s)).getParty();
    }

    public ACSObject getObject(PageState s) {
        return ((UserObjectStruct)this.m_UserObjectInfo.get(s)).getObject();
    }

    public Label getTitle() {
        return ((PermissionsHeader)this.getPermissionsHeader()).getTitle();
    }

    public String[] getPrivileges() {
        String[] p = new String[this.m_privileges.length];
        for (int i = 0; i < p.length; ++i) {
            p[i] = this.m_privileges[i].getName();
        }
        return p;
    }

    private PermissionsTables getPermissionsTables() {
        if (this.m_allPermissions == null) {
            this.m_allPermissions = new PermissionsTables(this.m_privileges, this);
        }
        return this.m_allPermissions;
    }

    public SimpleContainer getDirectPermissionsPanel() {
        this.m_DirectPermissions = this.getPermissionsTables().getPermissions(0);
        return this.m_DirectPermissions;
    }

    public SimpleContainer getInheritedPermissionsPanel() {
        this.m_InheritedPermissions = this.getPermissionsTables().getPermissions(1);
        return this.m_InheritedPermissions;
    }

    public SegmentedPanel getUniversalPermissionsPanel() {
        throw new UnsupportedOperationException();
    }

    public Form getUserSearchForm() {
        if (this.m_UserSearchForm == null) {
            this.m_UserSearchForm = new UserSearchForm(this);
        }
        return this.m_UserSearchForm;
    }

    public SimpleContainer getPermissionGrantPanel() {
        if (this.m_PermissionsGrantPanel == null) {
            PermissionsGrant permGrant = new PermissionsGrant(this);
            this.m_PermissionsGrantPanel = permGrant.getPanel();
        }
        return this.m_PermissionsGrantPanel;
    }

    public SimpleContainer getPermissionsHeader() {
        if (this.m_PermissionsHeader == null) {
            this.m_PermissionsHeader = new PermissionsHeader(this);
        }
        return this.m_PermissionsHeader;
    }

    public SimpleContainer getNoSearchResultPanel() {
        if (this.m_NoResultsPanel == null) {
            Label errorMsg = new Label(PermissionsConstants.NO_RESULTS.localize() + "");
            errorMsg.setClassAttr("errorBullet");
            BoxPanel bp = new BoxPanel();
            bp.add(errorMsg);
            bp.add(new UserSearchForm(this));
            this.m_NoResultsPanel = new SegmentedPanel().addSegment(new Label(" "), (Component)bp);
        }
        return this.m_NoResultsPanel;
    }

    public SimpleComponent getContextPanel() {
        if (this.m_ContextPanel == null) {
            this.m_ContextPanel = this.getPermissionsTables().makeContextPanel();
        }
        return this.m_ContextPanel;
    }

    ParameterModel getObjectIDParam() {
        return this.m_object_id_param;
    }

    ParameterModel getSearchString() {
        return this.m_searchString;
    }

    ParameterModel getPrivilegeParam() {
        return this.m_privArray;
    }

    public void showNoResults(PageState s) {
        this.getDirectPermissionsPanel().setVisible(s, false);
        this.getInheritedPermissionsPanel().setVisible(s, false);
        this.getContextPanel().setVisible(s, false);
        this.getUserSearchForm().setVisible(s, false);
        this.getPermissionGrantPanel().setVisible(s, false);
        this.getNoSearchResultPanel().setVisible(s, true);
    }

    public void showGrant(PageState s) {
        this.getDirectPermissionsPanel().setVisible(s, false);
        this.getInheritedPermissionsPanel().setVisible(s, false);
        this.getContextPanel().setVisible(s, false);
        this.getUserSearchForm().setVisible(s, false);
        this.getNoSearchResultPanel().setVisible(s, false);
        this.getPermissionGrantPanel().setVisible(s, true);
    }

    public void showAdmin(PageState s) {
        this.getDirectPermissionsPanel().setVisible(s, true);
        this.getInheritedPermissionsPanel().setVisible(s, true);
        this.getContextPanel().setVisible(s, true);
        this.getUserSearchForm().setVisible(s, true);
        this.getPermissionGrantPanel().setVisible(s, false);
    }

    public void actionPerformed(ActionEvent e) {
        PermissionDescriptor admin;
        PageState s = e.getPageState();
        if (this.isVisible(s) && !PermissionService.checkPermission(admin = new PermissionDescriptor(PrivilegeDescriptor.ADMIN, this.getObject(s), this.getRequestingUser(s)))) {
            URL url = URL.there(s.getRequest(), "/permissions/denied");
            throw new RedirectSignal(url, false);
        }
    }
}

