/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.ui.permissions;

import com.arsdigita.bebop.Form;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.SimpleContainer;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.form.Submit;
import com.arsdigita.bebop.form.TextField;
import com.arsdigita.globalization.GlobalizedMessage;
import com.arsdigita.ui.permissions.PermissionsConstants;
import com.arsdigita.web.ParameterMap;
import com.arsdigita.web.RedirectSignal;
import com.arsdigita.web.URL;

class PermissionSearchForm
extends Form
implements FormProcessListener,
PermissionsConstants {
    private static final String FORM_NAME = "permissionSearch";
    private static final String SEARCH_QUERY_PARAM_NAME = "searchQuery";

    public PermissionSearchForm() {
        this(new SimpleContainer());
    }

    public PermissionSearchForm(SimpleContainer container) {
        super(FORM_NAME, container);
        this.setMethod("post");
        this.add(new Label(new GlobalizedMessage("permissions.searchForm.label")));
        this.add(new TextField(SEARCH_QUERY_PARAM_NAME));
        Submit submit = new Submit("submit");
        submit.setButtonLabel(PermissionsConstants.SEARCH_BUTTON);
        this.add(submit);
        this.addProcessListener(this);
    }

    public void process(FormSectionEvent event) throws FormProcessException {
        String searchQuery = (String)event.getFormData().get(SEARCH_QUERY_PARAM_NAME);
        ParameterMap params = new ParameterMap();
        params.setParameter("po_id", searchQuery);
        URL url = URL.there(event.getPageState().getRequest(), "/permissions/one", params);
        throw new RedirectSignal(url, true);
    }
}

