/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.ui.login;

import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.event.RequestEvent;
import com.arsdigita.bebop.event.RequestListener;
import com.arsdigita.kernel.User;
import com.arsdigita.kernel.security.UserContext;
import com.arsdigita.kernel.security.Util;
import com.arsdigita.web.LoginSignal;
import com.arsdigita.web.Web;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;

public class UserAuthenticationListener
implements RequestListener {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/ui/login/UserAuthenticationListener.java#14 $$Author: dennis $$DateTime: 2004/04/07 16:07:11 $";
    private static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$ui$login$UserAuthenticationListener == null ? (class$com$arsdigita$ui$login$UserAuthenticationListener = UserAuthenticationListener.class$("com.arsdigita.ui.login.UserAuthenticationListener")) : class$com$arsdigita$ui$login$UserAuthenticationListener));
    static /* synthetic */ Class class$com$arsdigita$ui$login$UserAuthenticationListener;

    public User getUser(PageState state) {
        if (!this.isLoggedIn(state)) {
            throw new IllegalStateException("User is not logged in");
        }
        return Web.getUserContext().getUser();
    }

    public boolean isLoggedIn(PageState state) {
        return Web.getUserContext().isLoggedIn();
    }

    public void pageRequested(RequestEvent event) {
        PageState state = event.getPageState();
        UserContext ctx = Web.getUserContext();
        if (!ctx.isLoggedIn()) {
            s_log.debug((Object)"User is not logged in");
            this.redirectToLoginPage(state);
            return;
        }
    }

    private void redirectToLoginPage(PageState state) {
        HttpServletRequest req = state.getRequest();
        String urlBase = Util.getSecurityHelper().getLoginURL(req);
        if (urlBase.equals(Web.getContext().getRequestURL().getRequestURI())) {
            s_log.debug((Object)("preventing cyclic redirect to: " + urlBase));
            return;
        }
        throw new LoginSignal(req);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

