/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.ui.admin;

import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.event.FormInitListener;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.kernel.EmailAddress;
import com.arsdigita.kernel.Group;
import com.arsdigita.ui.admin.AdminConstants;
import com.arsdigita.ui.admin.GroupAdministrationTab;
import com.arsdigita.ui.admin.GroupForm;
import java.math.BigDecimal;
import javax.mail.internet.InternetAddress;

class GroupEditForm
extends GroupForm
implements AdminConstants,
FormInitListener,
FormProcessListener {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/ui/admin/GroupEditForm.java#8 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private GroupAdministrationTab m_parent;

    public GroupEditForm() {
        this((GroupAdministrationTab)null);
    }

    public GroupEditForm(GroupAdministrationTab parent) {
        super("group-edit-form");
        this.addInitListener(this);
        this.addProcessListener(this);
        this.m_parent = parent;
    }

    public void init(FormSectionEvent e) {
        PageState ps = e.getPageState();
        BigDecimal id = (BigDecimal)ps.getValue(AdminConstants.GROUP_ID_PARAM);
        if (id != null) {
            Group group = new Group(id);
            this.m_name.setValue(ps, group.getName());
            this.m_email.setValue(ps, group.getPrimaryEmail());
        }
    }

    public void process(FormSectionEvent e) throws FormProcessException {
        Group group;
        PageState ps = e.getPageState();
        BigDecimal id = (BigDecimal)ps.getValue(AdminConstants.GROUP_ID_PARAM);
        if (id == null) {
            throw new FormProcessException("id is null");
        }
        try {
            group = new Group(id);
        }
        catch (DataObjectNotFoundException exc) {
            throw new FormProcessException("Couldn't find the specified group", exc);
        }
        String name = (String)this.m_name.getValue(ps);
        group.setName(name);
        InternetAddress email = (InternetAddress)this.m_email.getValue(ps);
        if (email != null) {
            group.setPrimaryEmail(new EmailAddress(email.getAddress()));
        } else {
            group.setPrimaryEmail(null);
        }
        group.save();
        if (this.m_parent != null) {
            this.m_parent.displayGroupInfoPanel(ps);
        }
    }
}

