/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.templating;

import com.arsdigita.util.UncheckedWrapperException;
import com.arsdigita.util.cmd.BooleanSwitch;
import com.arsdigita.util.cmd.CommandLine;
import com.arsdigita.util.cmd.StringSwitch;
import java.util.Date;
import java.util.HashMap;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.log4j.Appender;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.Priority;

public class ApplyTemplates {
    private static final String OPT_LOOP = "-loop";
    private static final String OPT_LOG = "-log";
    private static final String OPT_WARMUP = "-warmup";
    private static final String OPT_VERBOSE = "-verbose";
    private static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$templating$ApplyTemplates == null ? (class$com$arsdigita$templating$ApplyTemplates = ApplyTemplates.class$("com.arsdigita.templating.ApplyTemplates")) : class$com$arsdigita$templating$ApplyTemplates));
    private static CommandLine s_cmd = new CommandLine("apply-templates", "java com.arsdigita.templating.ApplyTemplates -loop [count] -log [loglevel] -verbose -warmup [count] Stylesheet Input Output ");
    static /* synthetic */ Class class$com$arsdigita$templating$ApplyTemplates;

    public static final void main(String[] args) {
        ConsoleAppender log = new ConsoleAppender((Layout)new PatternLayout("%d{ISO8601} [%5.5t] %-5p %c{2} - %m%n"));
        log.setThreshold((Priority)Level.toLevel((String)"warn"));
        BasicConfigurator.configure((Appender)log);
        HashMap options = new HashMap();
        args = s_cmd.parse(options, args);
        String stylesheet = args[0];
        String input = args[1];
        String output = args[2];
        log.setThreshold((Priority)Level.toLevel((String)((String)options.get(OPT_LOG))));
        s_log.debug((Object)("Build xml source " + new Date()));
        StreamSource xml = new StreamSource(input);
        s_log.debug((Object)("Build xsl source " + new Date()));
        StreamSource xsl = new StreamSource(stylesheet);
        s_log.debug((Object)("Build html dest " + new Date()));
        StreamResult html = new StreamResult(output);
        s_log.debug((Object)("Build transformer factory " + new Date()));
        TransformerFactory fact = TransformerFactory.newInstance();
        s_log.debug((Object)("Build templates " + new Date()));
        Templates templates = null;
        try {
            templates = fact.newTemplates(xsl);
        }
        catch (TransformerConfigurationException tce) {
            throw new UncheckedWrapperException(tce);
        }
        Transformer xf = null;
        try {
            xf = templates.newTransformer();
        }
        catch (TransformerConfigurationException tce) {
            throw new UncheckedWrapperException(tce);
        }
        boolean verbose = Boolean.TRUE.equals(options.get(OPT_VERBOSE));
        try {
            int warmup = new Integer((String)options.get(OPT_WARMUP));
            Date start = new Date();
            s_log.debug((Object)("Warming up " + start));
            for (int i = 0; i < warmup; ++i) {
                xf.setOutputProperty("encoding", "UTF-8");
                xf.transform(xml, html);
                if (!verbose) continue;
                System.out.print(".");
                System.out.flush();
            }
            if (warmup > 0 && verbose) {
                System.out.println();
            }
            int loop = new Integer((String)options.get(OPT_LOOP));
            start = new Date();
            s_log.debug((Object)("Start " + start));
            for (int i = 0; i < loop; ++i) {
                xf.setOutputProperty("encoding", "UTF-8");
                xf.transform(xml, html);
                if (!verbose) continue;
                System.out.print(".");
                System.out.flush();
            }
            if (verbose) {
                System.out.println();
            }
            Date end = new Date();
            s_log.debug((Object)("End " + end));
            long duration = end.getTime() - start.getTime();
            s_log.info((Object)("Duration for " + loop + " iterations with " + " is " + duration + " milliseconds"));
        }
        catch (TransformerException ex) {
            throw new UncheckedWrapperException("cannot transform document", ex);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        s_cmd.addSwitch(new StringSwitch(OPT_LOG, "Log4j debug level", "warn"));
        s_cmd.addSwitch(new StringSwitch(OPT_LOOP, "Number of iterations to apply xsl", "1"));
        s_cmd.addSwitch(new StringSwitch(OPT_WARMUP, "Number of iterations to warm up on", "0"));
        s_cmd.addSwitch(new BooleanSwitch(OPT_VERBOSE, "Display progress", Boolean.FALSE));
    }
}

