/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.sitenode;

import com.arsdigita.kernel.Kernel;
import com.arsdigita.kernel.Party;
import com.arsdigita.kernel.PersonName;
import com.arsdigita.kernel.User;
import com.arsdigita.logging.ErrorReport;
import com.arsdigita.util.ExceptionUnwrapper;
import com.arsdigita.util.Exceptions;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.TreeSet;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ServletErrorReport
extends ErrorReport {
    public static final String GURU_MEDITATION_CODE = "guruMeditationCode";
    public static final String GURU_ERROR_REPORT = "guruErrorReport";
    private HttpServletRequest m_request;
    private HttpServletResponse m_response;
    static /* synthetic */ Class class$javax$servlet$ServletException;

    public ServletErrorReport(Throwable throwable, HttpServletRequest request, HttpServletResponse response) {
        super(throwable);
        this.m_request = request;
        this.m_response = response;
        try {
            this.addRequest();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            this.addCookies();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            this.addUser();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            this.addAttributes();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            this.addHeaders();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        request.setAttribute(GURU_MEDITATION_CODE, (Object)this.getGuruMeditationCode());
        request.setAttribute(GURU_ERROR_REPORT, (Object)this.getReport());
    }

    private void addRequest() {
        ArrayList<String> lines = new ArrayList<String>();
        lines.add("Context path: " + this.m_request.getContextPath());
        lines.add("Request URI: " + this.m_request.getRequestURI());
        lines.add("Query string: " + this.m_request.getQueryString());
        lines.add("Method: " + this.m_request.getMethod());
        lines.add("Remote user: " + this.m_request.getRemoteUser());
        this.addSection("Request summary", lines);
    }

    private void addCookies() {
        Cookie[] cookies = this.m_request.getCookies();
        if (cookies == null) {
            return;
        }
        String[] lines = new String[cookies.length];
        for (int i = 0; i < lines.length; ++i) {
            lines[i] = cookies[i].getName() + ": " + cookies[i].getValue() + " (expires: " + cookies[i].getMaxAge() + ")";
        }
        this.addSection("Cookies", lines);
    }

    private void addUser() {
        Party party = Kernel.getContext().getParty();
        if (party == null) {
            this.addSection("CCM User", "Party not logged in");
        } else {
            String[] lines = new String[5];
            lines[0] = "Party ID: " + party.getID();
            lines[1] = "Email address: " + party.getPrimaryEmail().toString();
            if (party instanceof User) {
                User user = (User)party;
                PersonName name = null;
                try {
                    name = user.getPersonName();
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (name != null) {
                    lines[2] = "Family name: " + name.getFamilyName();
                    lines[3] = "Given name: " + name.getGivenName();
                } else {
                    lines[2] = "Family name: not available";
                    lines[3] = "Given name: not available";
                }
                lines[4] = "Screen name: " + user.getScreenName();
            } else {
                lines[2] = "Family name: party is not a user";
                lines[3] = "Given name: party is not a user";
                lines[4] = "Screen name: party is not a user";
            }
            this.addSection("CCM User", lines);
        }
    }

    private void addAttributes() {
        TreeSet<Object> data = new TreeSet<Object>(Collator.getInstance());
        Enumeration props = this.m_request.getAttributeNames();
        while (props.hasMoreElements()) {
            String key = (String)props.nextElement();
            if (GURU_ERROR_REPORT.equals(key) || GURU_MEDITATION_CODE.equals(key)) continue;
            Object value = this.m_request.getAttribute(key);
            data.add(key + ": " + value);
        }
        this.addSection("Servlet attributes", data);
    }

    private void addHeaders() {
        TreeSet<Object> data = new TreeSet<Object>(Collator.getInstance());
        Enumeration props = this.m_request.getHeaderNames();
        while (props.hasMoreElements()) {
            String key = (String)props.nextElement();
            String value = this.m_request.getHeader(key);
            data.add(key + ": " + value);
        }
        this.addSection("HTTP headers", data);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        Exceptions.registerUnwrapper(class$javax$servlet$ServletException == null ? (class$javax$servlet$ServletException = ServletErrorReport.class$("javax.servlet.ServletException")) : class$javax$servlet$ServletException, new ExceptionUnwrapper(){

            public Throwable unwrap(Throwable t) {
                ServletException ex = (ServletException)t;
                return ex.getRootCause();
            }
        });
    }
}

