/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.search.ui;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Form;
import com.arsdigita.bebop.FormData;
import com.arsdigita.bebop.FormModel;
import com.arsdigita.bebop.Page;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.parameters.ParameterData;
import com.arsdigita.bebop.parameters.StringParameter;
import com.arsdigita.bebop.util.Traversal;
import com.arsdigita.globalization.GlobalizedMessage;
import com.arsdigita.search.FilterSpecification;
import com.arsdigita.search.Search;
import com.arsdigita.search.ui.FilterGenerator;
import com.arsdigita.search.ui.QueryComponent;
import com.arsdigita.xml.Element;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.log4j.Logger;

public class BaseQueryComponent
extends QueryComponent {
    private static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$search$ui$BaseQueryComponent == null ? (class$com$arsdigita$search$ui$BaseQueryComponent = BaseQueryComponent.class$("com.arsdigita.search.ui.BaseQueryComponent")) : class$com$arsdigita$search$ui$BaseQueryComponent));
    private Set m_filters;
    private Form m_form;
    private StringParameter m_terms = new StringParameter("terms");
    static /* synthetic */ Class class$com$arsdigita$search$ui$BaseQueryComponent;

    public BaseQueryComponent() {
        super("query");
        this.m_filters = new HashSet();
    }

    public void register(Page p) {
        super.register(p);
        this.findFilters(this.m_filters);
    }

    public void register(Form form, FormModel model) {
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("Adding " + this.m_terms.getName() + " to form model"));
        }
        this.m_terms.setPassIn(true);
        model.addFormParam(this.m_terms);
        this.m_form = form;
    }

    protected String getTerms(PageState state) {
        FormData fd = this.m_form.getFormData(state);
        if (fd != null) {
            ParameterData data = fd.getParameter(this.m_terms.getName());
            return (String)data.getValue();
        }
        return null;
    }

    protected FilterSpecification[] getFilters(PageState state) {
        FilterSpecification[] filters = new FilterSpecification[this.m_filters.size()];
        Iterator i = this.m_filters.iterator();
        int c = 0;
        while (i.hasNext()) {
            FilterGenerator filter = (FilterGenerator)i.next();
            filters[c++] = filter.getFilter(state);
        }
        return filters;
    }

    public void generateXML(PageState state, Element parent) {
        Element content = this.generateParent(parent);
        Element terms = Search.newElement("terms");
        terms.addAttribute("param", this.m_terms.getName());
        terms.addAttribute("value", this.getTerms(state));
        this.generateErrorXML(state, terms);
        content.addContent(terms);
        this.generateChildrenXML(state, content);
    }

    protected void generateErrorXML(PageState state, Element parent) {
        FormData f = this.m_form.getFormData(state);
        if (f == null) {
            return;
        }
        Iterator i = f.getErrors(this.m_terms.getName());
        while (i.hasNext()) {
            Element error = Search.newElement("error");
            error.setText((String)((GlobalizedMessage)i.next()).localize(state.getRequest()));
            parent.addContent(error);
        }
    }

    protected void findFilters(Set filters) {
        FilterTraversal trav = new FilterTraversal(filters);
        trav.preorder(this);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class FilterTraversal
    extends Traversal {
        private Set m_filters;

        public FilterTraversal(Set filters) {
            this.m_filters = filters;
        }

        public void act(Component c) {
            if (c instanceof FilterGenerator) {
                this.m_filters.add(c);
            }
        }
    }
}

