/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.search.intermedia;

import com.arsdigita.domain.DomainObject;
import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.domain.DomainService;
import com.arsdigita.persistence.DataAssociation;
import com.arsdigita.persistence.DataAssociationCursor;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.metadata.DataType;
import com.arsdigita.persistence.metadata.MetadataRoot;
import com.arsdigita.persistence.metadata.ObjectType;
import com.arsdigita.persistence.metadata.Property;
import com.arsdigita.search.intermedia.SearchIndexHelpCustomize;
import com.arsdigita.xml.Document;
import com.arsdigita.xml.Element;
import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class SearchIndexHelp
extends DomainService {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/search/intermedia/SearchIndexHelp.java#3 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private static final Logger s_log = Logger.getLogger((String)(class$com$arsdigita$search$intermedia$SearchIndexHelp == null ? (class$com$arsdigita$search$intermedia$SearchIndexHelp = SearchIndexHelp.class$("com.arsdigita.search.intermedia.SearchIndexHelp")) : class$com$arsdigita$search$intermedia$SearchIndexHelp).getName());
    private String m_xml;
    private byte[] m_raw;
    public static final String USE_INDEX_HELP = "use_SearchIndexHelp";
    static /* synthetic */ Class class$com$arsdigita$search$intermedia$SearchIndexHelp;

    public void retrieveContent(DomainObject obj) {
        HashSet found = new HashSet();
        ByteArrayOutputStream raw = new ByteArrayOutputStream();
        Element el = this.getXMLe(obj, found, raw);
        this.m_xml = "";
        if (el != null) {
            try {
                this.m_xml = new Document(el).toString();
                this.m_xml = this.stripHeader(this.m_xml);
            }
            catch (Exception e) {
                s_log.error((Object)"Error when creating document to index.");
                e.printStackTrace();
            }
        }
        this.m_raw = raw.toByteArray();
    }

    private String stripHeader(String xml) {
        String HEAD_PATTERN = "<?xml version=\"1.0\" encoding=\"";
        if (xml.startsWith("<?xml version=\"1.0\" encoding=\"")) {
            int head_end = xml.indexOf(62);
            return xml.substring(head_end + 1);
        }
        return xml;
    }

    private Element getXMLe(DomainObject obj, HashSet found, ByteArrayOutputStream raw) {
        found.add(obj);
        ArrayList fields = obj instanceof SearchIndexHelpCustomize ? this.getIndexHelpFields(obj) : this.getObjectAttributeFields(obj);
        boolean hasXML = false;
        OID oid = obj.getOID();
        ObjectType ot = oid.getObjectType();
        Element top_el = new Element(ot.getName());
        Iterator it = fields.iterator();
        while (it.hasNext()) {
            FieldInfo fi = (FieldInfo)it.next();
            String name = fi.name;
            String code = fi.code;
            Object value = SearchIndexHelp.get(obj, name);
            if (code.equals("XML")) {
                hasXML = true;
                Element attr_el = new Element(name);
                if (value != null) {
                    attr_el.setText(value.toString());
                }
                top_el.addContent(attr_el);
                continue;
            }
            if (raw.size() > 0) {
                raw.write(32);
            }
            if (value == null) continue;
            byte[] value_b = value.toString().getBytes();
            raw.write(value_b, 0, value_b.length);
        }
        it = ot.getProperties();
        while (it.hasNext()) {
            DataAssociation da;
            Property prop = (Property)it.next();
            if (prop.isAttribute()) continue;
            boolean isComposition = prop.isComponent();
            String rr_name = prop.getName();
            s_log.debug((Object)("Retrieving role reference '" + rr_name + "' for '" + obj + "'"));
            Object rr_da = SearchIndexHelp.get(obj, rr_name);
            if (rr_da == null) continue;
            try {
                da = (DataAssociation)rr_da;
            }
            catch (Exception e) {
                continue;
            }
            DataAssociationCursor da_cursor = da.getDataAssociationCursor();
            while (da_cursor.next()) {
                Element objEl;
                if (!isComposition) {
                    s_log.debug((Object)("Found non-composition: " + rr_name));
                    continue;
                }
                DataObject dataObject = da_cursor.getDataObject();
                DomainObject domainObject = DomainObjectFactory.newInstance(dataObject);
                if (found.contains(domainObject) || (objEl = this.getXMLe(domainObject, found, raw)) == null) continue;
                hasXML = true;
                top_el.addContent(objEl);
            }
        }
        if (hasXML) {
            return top_el;
        }
        return null;
    }

    private ArrayList getObjectAttributeFields(DomainObject obj) {
        MetadataRoot root = MetadataRoot.getMetadataRoot();
        ArrayList<FieldInfo> fieldInfo = new ArrayList<FieldInfo>();
        OID oid = obj.getOID();
        ObjectType ot = oid.getObjectType();
        Iterator iter = ot.getProperties();
        while (iter.hasNext()) {
            String name;
            DataType dt;
            Property prop = (Property)iter.next();
            if (prop.isRole() || !(dt = prop.getType()).equals(root.getPrimitiveType("Character")) && !dt.equals(root.getPrimitiveType("Clob")) && !dt.equals(root.getPrimitiveType("String")) || (name = prop.getName()).equals("objectType") || name.equals("defaultDomainClass")) continue;
            fieldInfo.add(new FieldInfo(name, "XML"));
        }
        return fieldInfo;
    }

    private ArrayList getIndexHelpFields(DomainObject obj) {
        ArrayList<FieldInfo> fieldInfo = new ArrayList<FieldInfo>();
        String errMsg = "Invalid field information returned by SearchIndexHelpFields must have name with 'XML' or 'RAW' appended...";
        String[] fieldList = ((SearchIndexHelpCustomize)((Object)obj)).searchIndexHelpFields();
        for (int i = 0; i < fieldList.length; ++i) {
            String code;
            String name;
            String nameAndCode = fieldList[i];
            int len = nameAndCode.length();
            try {
                name = nameAndCode.substring(0, len - 3);
                code = nameAndCode.substring(len - 3);
            }
            catch (IndexOutOfBoundsException e) {
                s_log.error((Object)("Invalid field information returned by SearchIndexHelpFields must have name with 'XML' or 'RAW' appended..." + nameAndCode));
                continue;
            }
            if (name.length() == 0 || !code.equals("XML") && !code.equals("RAW")) {
                s_log.error((Object)("Invalid field information returned by SearchIndexHelpFields must have name with 'XML' or 'RAW' appended..." + nameAndCode));
                continue;
            }
            fieldInfo.add(new FieldInfo(name, code));
        }
        return fieldInfo;
    }

    public String xmlContent() {
        return this.m_xml;
    }

    public byte[] rawContent() {
        return this.m_raw;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class FieldInfo {
        String name;
        String code;

        FieldInfo(String n, String c) {
            this.name = n;
            this.code = c;
        }
    }
}

