/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.search;

import com.arsdigita.domain.DomainObject;
import com.arsdigita.persistence.PersistenceException;
import com.arsdigita.persistence.TransactionContext;
import com.arsdigita.persistence.TransactionListener;
import com.arsdigita.search.DocumentObserver;
import com.arsdigita.search.Search;
import com.arsdigita.search.SearchObserver;
import java.util.Iterator;
import java.util.Set;
import org.apache.log4j.Logger;

class SearchTransactionListener
implements TransactionListener {
    private static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$search$SearchTransactionListener == null ? (class$com$arsdigita$search$SearchTransactionListener = SearchTransactionListener.class$("com.arsdigita.search.SearchTransactionListener")) : class$com$arsdigita$search$SearchTransactionListener));
    static /* synthetic */ Class class$com$arsdigita$search$SearchTransactionListener;

    SearchTransactionListener() {
    }

    public void beforeCommit(TransactionContext txn) throws PersistenceException {
        Set toDelete;
        Set toSave;
        DocumentObserver observer = Search.getConfig().getObserver();
        if (observer == null) {
            s_log.warn((Object)("No document observer configured for indexer " + Search.getConfig().getIndexer()));
            return;
        }
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)"Running beforeCommit event in search transaction listener");
        }
        if ((toSave = (Set)txn.getAttribute(SearchObserver.SEARCH_SAVE_ATTR)) != null) {
            if (s_log.isDebugEnabled()) {
                s_log.debug((Object)("Save set has " + toSave.size() + " entries"));
            }
            Iterator iter = toSave.iterator();
            while (iter.hasNext()) {
                DomainObject dobj = (DomainObject)iter.next();
                if (s_log.isDebugEnabled()) {
                    s_log.debug((Object)("Search save for object with OID " + dobj.getOID()));
                }
                observer.onSave(dobj);
            }
        }
        if ((toDelete = (Set)txn.getAttribute(SearchObserver.SEARCH_DELETE_ATTR)) != null) {
            if (s_log.isDebugEnabled()) {
                s_log.debug((Object)("Delete set has " + toDelete.size() + " entries"));
            }
            Iterator iter = toDelete.iterator();
            while (iter.hasNext()) {
                DomainObject dobj = (DomainObject)iter.next();
                if (s_log.isDebugEnabled()) {
                    s_log.debug((Object)("Search delete for object with OID " + dobj.getOID()));
                }
                observer.onDelete(dobj);
            }
        }
    }

    public void afterCommit(TransactionContext txn) {
    }

    public void beforeAbort(TransactionContext txn) {
    }

    public void afterAbort(TransactionContext txn) {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

