/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.search;

import com.arsdigita.domain.DomainObject;
import com.arsdigita.domain.GlobalObserver;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.PersistenceException;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.persistence.TransactionContext;
import com.arsdigita.search.DocumentObserver;
import com.arsdigita.search.MetadataProvider;
import com.arsdigita.search.MetadataProviderRegistry;
import com.arsdigita.search.Search;
import com.arsdigita.search.SearchTransactionListener;
import com.arsdigita.search.intermedia.Searchable;
import com.arsdigita.search.lucene.Registry;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;

class SearchObserver
implements GlobalObserver {
    public static final String SEARCH_SAVE_ATTR = (class$com$arsdigita$search$SearchObserver == null ? (class$com$arsdigita$search$SearchObserver = SearchObserver.class$("com.arsdigita.search.SearchObserver")) : class$com$arsdigita$search$SearchObserver).getName() + ".onSave";
    public static final String SEARCH_DELETE_ATTR = (class$com$arsdigita$search$SearchObserver == null ? (class$com$arsdigita$search$SearchObserver = SearchObserver.class$("com.arsdigita.search.SearchObserver")) : class$com$arsdigita$search$SearchObserver).getName() + ".onDelete";
    private static final String SEARCH_TXN_ATTR = (class$com$arsdigita$search$SearchObserver == null ? (class$com$arsdigita$search$SearchObserver = SearchObserver.class$("com.arsdigita.search.SearchObserver")) : class$com$arsdigita$search$SearchObserver).getName() + ".listener";
    private static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$search$SearchObserver == null ? (class$com$arsdigita$search$SearchObserver = SearchObserver.class$("com.arsdigita.search.SearchObserver")) : class$com$arsdigita$search$SearchObserver));
    static /* synthetic */ Class class$com$arsdigita$search$SearchObserver;

    SearchObserver() {
    }

    public boolean shouldObserve(DomainObject dobj) {
        Registry reg;
        MetadataProvider provider = MetadataProviderRegistry.findAdapter(dobj.getObjectType());
        if (provider != null) {
            if (s_log.isDebugEnabled()) {
                s_log.debug((Object)("Requesting observation for " + dobj.getOID()));
            }
            return true;
        }
        if (Search.getConfig().isLuceneEnabled() && (reg = Registry.getInstance()).hasAdapter(dobj.getObjectType())) {
            if (s_log.isDebugEnabled()) {
                s_log.debug((Object)("Requesting legacy lucene observation for " + dobj.getOID()));
            }
            return true;
        }
        if (Search.getConfig().isIntermediaEnabled() && dobj instanceof Searchable) {
            if (s_log.isDebugEnabled()) {
                s_log.debug((Object)("Requesting legacy intermedia observation for " + dobj.getOID()));
            }
            return true;
        }
        return false;
    }

    public void set(DomainObject dobj, String name, Object old_value, Object new_value) {
    }

    public void add(DomainObject dobj, String name, DataObject dataObject) {
    }

    public void remove(DomainObject dobj, String name, DataObject dataObject) {
    }

    public void clear(DomainObject dobj, String name) {
    }

    public void beforeSave(DomainObject dobj) throws PersistenceException {
    }

    public void beforeDelete(DomainObject dobj) throws PersistenceException {
    }

    public void afterSave(DomainObject dobj) throws PersistenceException {
        if (Search.getConfig().getLazyUpdates()) {
            if (s_log.isDebugEnabled()) {
                s_log.debug((Object)("Scheduling onSave event for " + dobj.getOID()));
            }
            this.registerListener();
            Set saveSet = this.getAttributeSet(SEARCH_SAVE_ATTR);
            Set deleteSet = this.getAttributeSet(SEARCH_DELETE_ATTR);
            if (deleteSet.contains(dobj)) {
                if (s_log.isInfoEnabled()) {
                    s_log.info((Object)("Not scheduling onSave event for deleted object" + dobj.getOID()));
                }
                return;
            }
            saveSet.add(dobj);
        } else {
            DocumentObserver observer = Search.getConfig().getObserver();
            if (observer == null) {
                s_log.warn((Object)("No document observer configured for indexer " + Search.getConfig().getIndexer()));
                return;
            }
            if (s_log.isDebugEnabled()) {
                s_log.debug((Object)("Invoking onSave event for " + dobj.getOID()));
            }
            observer.onSave(dobj);
        }
    }

    public void afterDelete(DomainObject dobj) throws PersistenceException {
        if (Search.getConfig().getLazyUpdates()) {
            if (s_log.isDebugEnabled()) {
                s_log.debug((Object)("Scheduling onDelete event for " + dobj.getOID()));
            }
            this.registerListener();
            Set saveSet = this.getAttributeSet(SEARCH_SAVE_ATTR);
            Set deleteSet = this.getAttributeSet(SEARCH_DELETE_ATTR);
            if (saveSet.contains(dobj)) {
                if (s_log.isInfoEnabled()) {
                    s_log.info((Object)("Removing onSave event for deleted object " + dobj.getOID()));
                }
                saveSet.remove(dobj);
            }
            deleteSet.add(dobj);
        } else {
            DocumentObserver observer = Search.getConfig().getObserver();
            if (observer == null) {
                s_log.warn((Object)("No document observer configured for indexer " + Search.getConfig().getIndexer()));
                return;
            }
            if (s_log.isDebugEnabled()) {
                s_log.debug((Object)("Invoking onDelete event for " + dobj.getOID()));
            }
            observer.onDelete(dobj);
        }
    }

    private Set getAttributeSet(String sAttr) {
        TransactionContext ctx = SessionManager.getSession().getTransactionContext();
        HashSet set = (HashSet)ctx.getAttribute(sAttr);
        if (set == null) {
            set = new HashSet();
            ctx.setAttribute(sAttr, set);
        }
        return set;
    }

    private synchronized void registerListener() {
        TransactionContext ctx = SessionManager.getSession().getTransactionContext();
        String sTxn = (String)ctx.getAttribute(SEARCH_TXN_ATTR);
        if (sTxn == null) {
            ctx.addTransactionListener(new SearchTransactionListener());
            ctx.setAttribute(SEARCH_TXN_ATTR, SEARCH_TXN_ATTR);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

