/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.persistence;

import com.arsdigita.persistence.DataCollection;
import com.arsdigita.persistence.Session;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.persistence.TransactionContext;
import com.arsdigita.persistence.metadata.MetadataRoot;
import com.arsdigita.persistence.pdl.PDLCompiler;
import com.arsdigita.runtime.DataInitEvent;
import com.arsdigita.runtime.DomainInitEvent;
import com.arsdigita.runtime.LegacyInitEvent;
import com.arsdigita.runtime.RuntimeConfig;
import com.redhat.persistence.oql.Query;
import java.io.StringReader;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class Initializer
implements com.arsdigita.runtime.Initializer {
    private static final Logger s_log = Logger.getLogger((String)(class$com$arsdigita$persistence$Initializer == null ? (class$com$arsdigita$persistence$Initializer = Initializer.class$("com.arsdigita.persistence.Initializer")) : class$com$arsdigita$persistence$Initializer).getName());
    static /* synthetic */ Class class$com$arsdigita$persistence$Initializer;

    public void init(DataInitEvent evt) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(DomainInitEvent evt) {
        Query.setQueryCacheSize(RuntimeConfig.getConfig().getQueryCacheSize());
        TransactionContext txn = null;
        try {
            String pdlFile;
            String currentFile;
            Session session = SessionManager.getSession();
            txn = session.getTransactionContext();
            txn.beginTxn();
            MetadataRoot root = MetadataRoot.getMetadataRoot();
            PDLCompiler pdl = new PDLCompiler();
            DataCollection collection = SessionManager.getSession().retrieve("com.arsdigita.persistence.DynamicObjectType");
            while (collection.next()) {
                currentFile = (String)collection.get("dynamicType");
                if (s_log.isInfoEnabled()) {
                    s_log.info((Object)("loading... " + currentFile.toString()));
                }
                if (root.getObjectType(currentFile) != null) {
                    if (!s_log.isEnabledFor((Priority)Level.WARN)) continue;
                    s_log.warn((Object)("The Object Type [" + currentFile + "] has already " + "been defined in the static files.  Ignoring " + "object type definition from the database"));
                    continue;
                }
                pdlFile = (String)collection.get("pdlFile");
                pdl.parse(new StringReader(pdlFile), "DATABASE: " + currentFile);
            }
            collection = SessionManager.getSession().retrieve("com.arsdigita.persistence.DynamicAssociation");
            while (collection.next()) {
                currentFile = "Association from " + collection.get("objectType1") + " to " + collection.get("objectType2");
                if (s_log.isInfoEnabled()) {
                    s_log.info((Object)("loading " + currentFile));
                }
                pdlFile = (String)collection.get("pdlFile");
                pdl.parse(new StringReader(pdlFile), "DATABASE: " + currentFile);
            }
            pdl.emit(root);
            txn.commitTxn();
            Object var10_9 = null;
            if (txn != null && txn.inTxn()) {
                txn.abortTxn();
            }
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            if (txn != null && txn.inTxn()) {
                txn.abortTxn();
            }
            throw throwable;
        }
    }

    public void init(LegacyInitEvent evt) {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

