/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.packaging;

import com.arsdigita.kernel.KernelConfig;
import com.arsdigita.packaging.Menu;
import com.arsdigita.packaging.ParameterMap;
import com.arsdigita.runtime.RuntimeConfig;
import com.arsdigita.util.StringUtils;
import com.arsdigita.util.UncheckedWrapperException;
import com.arsdigita.util.parameter.ErrorList;
import com.arsdigita.util.parameter.Parameter;
import com.arsdigita.util.parameter.ParameterError;
import com.arsdigita.util.parameter.ParameterInfo;
import com.arsdigita.util.parameter.ParameterReader;
import com.arsdigita.web.WebConfig;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;

class ParameterEditor {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/packaging/ParameterEditor.java#7 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private ParameterMap m_map;
    private BufferedReader m_in;
    private PrintStream m_out;
    private boolean m_optional;
    private boolean m_done;
    private boolean m_valid;
    private Menu m_menu;
    private List m_topics;
    private Map m_help;

    ParameterEditor(ParameterMap map, InputStream in, PrintStream out) {
        this.m_map = map;
        this.m_in = new BufferedReader(new InputStreamReader(in));
        this.m_out = out;
        this.m_optional = false;
        this.m_done = false;
        this.m_valid = false;
        this.menu();
    }

    private void menu() {
        this.m_menu = new Menu(this.m_in, this.m_out);
        this.m_topics = new ArrayList();
        this.m_help = new HashMap();
        this.m_menu.add(Menu.GAP);
        int index = 1;
        Iterator it = this.m_map.getParameters().iterator();
        while (it.hasNext()) {
            final Parameter param = (Parameter)it.next();
            if (!this.m_optional && (!param.isRequired() || param.getDefaultValue() != null)) continue;
            String key = "" + index++;
            this.m_menu.add(key, new Menu.Item(){

                public String getDescription() {
                    String value = "" + ParameterEditor.this.m_map.get(param);
                    value = value.length() > 20 ? "\n          " + value : " " + value;
                    return "Set " + ParameterEditor.this.getTitle(param) + ":" + value;
                }

                public void act() {
                    ParameterEditor.this.read(param);
                }
            });
            this.m_topics.add(key);
            this.m_help.put(key, this.getHelp(param));
        }
        this.m_menu.add(Menu.GAP);
        this.m_menu.add("l", new Menu.Item(){

            public String getDescription() {
                return "List parameters";
            }

            public void act() {
                ParameterEditor.this.m_menu.display();
            }
        });
        this.m_menu.add("o", new Menu.Item(){

            public String getDescription() {
                if (ParameterEditor.this.m_optional) {
                    return "Hide optional parameters";
                }
                return "Show optional parameters";
            }

            public void act() {
                ParameterEditor.this.m_optional = !ParameterEditor.this.m_optional;
                ParameterEditor.this.menu();
                ParameterEditor.this.m_menu.display();
            }
        }, Menu.HORIZONTAL);
        this.m_menu.add("v", new Menu.Item(){

            public String getDescription() {
                return "Validate parameters";
            }

            public void act() {
                if (ParameterEditor.this.validate()) {
                    ParameterEditor.this.m_out.println("  -- valid --");
                }
            }
        }, Menu.HORIZONTAL);
        this.m_menu.add("e", new Menu.Item(){

            public String getDescription() {
                return "Exit";
            }

            public void act() {
                if (!ParameterEditor.this.validate()) {
                    while (true) {
                        String line;
                        ParameterEditor.this.m_out.print("Configuration is invalid, abort? (yes/no) ");
                        ParameterEditor.this.m_out.flush();
                        try {
                            line = ParameterEditor.this.m_in.readLine();
                        }
                        catch (IOException e) {
                            throw new UncheckedWrapperException(e);
                        }
                        if (line == null) {
                            ParameterEditor.this.abort();
                            return;
                        }
                        if ((line = line.trim()).equals("")) continue;
                        if (line.equals("yes")) {
                            ParameterEditor.this.abort();
                            return;
                        }
                        if (line.equals("no")) break;
                    }
                    return;
                }
                ParameterEditor.this.m_done = true;
                ParameterEditor.this.m_valid = true;
            }
        }, Menu.HORIZONTAL);
        this.m_menu.add("r", new Menu.Item(){

            public String getDescription() {
                return "Set required parameters";
            }

            public void act() {
                Iterator it = ParameterEditor.this.m_map.getParameters().iterator();
                while (it.hasNext()) {
                    Parameter param = (Parameter)it.next();
                    if (!param.isRequired() || ParameterEditor.this.m_map.get(param) != null) continue;
                    while (!ParameterEditor.this.read(param)) {
                    }
                    if (!ParameterEditor.this.m_done) continue;
                    return;
                }
                ParameterEditor.this.m_menu.display();
            }
        }, Menu.HORIZONTAL);
        this.m_menu.add("A", new Menu.Item(){

            public String getDescription() {
                return "Abort";
            }

            public void act() {
                ParameterEditor.this.abort();
            }
        }, Menu.HORIZONTAL);
        this.m_menu.add("?", new Menu.Item(){

            public String getDescription() {
                return "Help";
            }

            public void act() {
                ParameterEditor.this.help();
            }
        }, Menu.HORIZONTAL);
        this.m_menu.add(Menu.GAP);
        this.loadHelp();
    }

    private void loadHelp() {
        Properties props = new Properties();
        InputStream is = this.getClass().getResourceAsStream("ParameterEditor.help");
        if (is == null) {
            throw new IllegalStateException("Can't find ParameterEditor.help");
        }
        try {
            props.load(is);
            is.close();
        }
        catch (IOException e) {
            throw new UncheckedWrapperException(e);
        }
        String[] topics = StringUtils.split(props.getProperty("topics", ""), ',');
        for (int i = 0; i < topics.length; ++i) {
            String topic = topics[i].trim();
            this.m_topics.add(topic);
            this.m_help.put(topic, props.getProperty("topics." + topic));
        }
    }

    private String getTitle(Parameter param) {
        ParameterInfo pinfo = param.getInfo();
        if (pinfo == null || pinfo.getTitle() == null) {
            return param.getName();
        }
        return pinfo.getTitle();
    }

    private String getHelp(Parameter param) {
        ParameterInfo info = param.getInfo();
        if (info == null) {
            return null;
        }
        StringWriter buf = new StringWriter();
        PrintWriter pw = new PrintWriter(buf);
        pw.println("    Title: " + info.getTitle());
        pw.println("  Purpose: " + info.getPurpose());
        pw.println("  Example: " + info.getExample());
        pw.print("   Format: " + info.getFormat());
        pw.flush();
        return buf.toString();
    }

    private boolean validate() {
        ErrorList errs = new ErrorList();
        this.m_map.validate(errs);
        if (errs.isEmpty()) {
            return true;
        }
        this.print(errs);
        return false;
    }

    private void print(ErrorList errs) {
        Iterator it = errs.iterator();
        while (it.hasNext()) {
            ParameterError err = (ParameterError)it.next();
            this.m_out.println("  * " + this.getTitle(err.getParameter()) + ": " + err.getMessage());
        }
    }

    private boolean read(Parameter param) {
        ErrorList errs = new ErrorList();
        Object obj = this.read(param, errs);
        if (errs.isEmpty()) {
            this.m_map.set(param, obj);
            return true;
        }
        this.print(errs);
        return false;
    }

    private Object read(Parameter param, ErrorList errs) {
        return param.read(new ParameterReader(){

            public String read(Parameter param, ErrorList errs) {
                ParameterEditor.this.m_out.print(ParameterEditor.this.getTitle(param) + ": ");
                ParameterEditor.this.m_out.flush();
                try {
                    String line = ParameterEditor.this.m_in.readLine();
                    if (line == null) {
                        ParameterEditor.this.abort();
                        return null;
                    }
                    return line;
                }
                catch (IOException e) {
                    throw new UncheckedWrapperException(e);
                }
            }
        }, errs);
    }

    private void abort() {
        this.m_valid = false;
        this.m_done = true;
        this.m_out.println("Aborting...");
    }

    private void topics() {
        this.m_out.print("  Help topics: ");
        Iterator it = this.m_topics.iterator();
        while (it.hasNext()) {
            this.m_out.print(it.next());
            if (!it.hasNext()) continue;
            this.m_out.print(", ");
        }
        this.m_out.println();
    }

    private void help() {
        String line;
        this.topics();
        this.m_out.print("Topic: ");
        this.m_out.flush();
        try {
            line = this.m_in.readLine();
        }
        catch (IOException e) {
            throw new UncheckedWrapperException(e);
        }
        if (line == null) {
            this.abort();
            return;
        }
        String help = (String)this.m_help.get(line = line.trim());
        if (help == null) {
            this.m_out.println("  * No help for: " + line);
        } else {
            this.m_out.println(help);
        }
    }

    public boolean edit() {
        this.m_menu.display();
        while (!this.m_done) {
            Menu.Item item = this.m_menu.choose("Choose: ");
            if (item == null) {
                return false;
            }
            item.act();
        }
        return this.m_valid;
    }

    public static final void main(String[] args) {
        ParameterMap map = new ParameterMap();
        map.addContext(new RuntimeConfig());
        map.addContext(new WebConfig());
        map.addContext(new KernelConfig());
        ParameterEditor pe = new ParameterEditor(map, System.in, System.out);
        pe.edit();
    }
}

