/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.notification;

import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.kernel.User;
import com.arsdigita.mail.Mail;
import com.arsdigita.notification.Digest;
import com.arsdigita.notification.NotificationConstants;
import com.arsdigita.notification.QueueItem;
import com.arsdigita.persistence.DataQuery;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.Session;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.util.StringUtils;
import com.arsdigita.util.UncheckedWrapperException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TimerTask;
import javax.mail.MessagingException;
import org.apache.log4j.Logger;

class DigestQueueManager
extends TimerTask
implements NotificationConstants {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/notification/DigestQueueManager.java#14 $ by $Author: dennis $,  $Date: 2004/04/07 $";
    private static final Logger log = Logger.getLogger((Class)(class$com$arsdigita$notification$DigestQueueManager == null ? (class$com$arsdigita$notification$DigestQueueManager = DigestQueueManager.class$("com.arsdigita.notification.DigestQueueManager")) : class$com$arsdigita$notification$DigestQueueManager));
    private static final String FROM = "From: ";
    private static final String SUBJECT = "Subject: ";
    static /* synthetic */ Class class$com$arsdigita$notification$DigestQueueManager;

    DigestQueueManager() {
    }

    public void run() {
        log.info((Object)"processing current requests");
        long time = System.currentTimeMillis();
        HashMap digestMap = new HashMap();
        boolean committedTxn = false;
        Session session = SessionManager.getSession();
        session.getTransactionContext().beginTxn();
        try {
            DataQuery query = session.retrieveQuery("com.arsdigita.notification.GetDigestQueuedNotifications");
            while (query.next()) {
                BigDecimal digestID = (BigDecimal)query.get("digestID");
                BigDecimal partyTo = (BigDecimal)query.get("partyTo");
                BigDecimal requestID = (BigDecimal)query.get("requestID");
                HashMap partyMap = (HashMap)digestMap.get(digestID);
                if (!digestMap.containsKey(digestID)) {
                    digestMap.put(digestID, new HashMap());
                }
                if (!(partyMap = (HashMap)digestMap.get(digestID)).containsKey(partyTo)) {
                    partyMap.put(partyTo, new ArrayList());
                }
                ((ArrayList)partyMap.get(partyTo)).add(requestID);
            }
            Iterator digestIDIter = digestMap.keySet().iterator();
            while (digestIDIter.hasNext()) {
                Digest digest;
                BigDecimal digestID = (BigDecimal)digestIDIter.next();
                try {
                    digest = new Digest(digestID);
                }
                catch (DataObjectNotFoundException e) {
                    log.warn((Object)("failed to retrieved digest " + digestID));
                    continue;
                }
                String from = digest.getFromEmail();
                String subject = digest.getSubject();
                String header = StringUtils.addNewline(digest.getHeader());
                String signature = StringUtils.addNewline(digest.getSignature());
                String separator = StringUtils.addNewline(digest.getSeparator());
                HashMap partyMap = (HashMap)digestMap.get(digestID);
                Iterator partyIDIter = partyMap.keySet().iterator();
                while (partyIDIter.hasNext()) {
                    int i;
                    String to;
                    BigDecimal partyID = (BigDecimal)partyIDIter.next();
                    try {
                        to = User.retrieve(partyID).getPrimaryEmail().toString();
                    }
                    catch (DataObjectNotFoundException e) {
                        log.warn((Object)("failed to retrieve user " + partyID));
                        continue;
                    }
                    ArrayList requestIDList = (ArrayList)partyMap.get(partyID);
                    ArrayList<QueueItem> noticeList = new ArrayList<QueueItem>();
                    String nl = System.getProperty("line.separator");
                    Mail mail = new Mail(to, from, subject);
                    StringBuffer body = new StringBuffer();
                    body.append(header);
                    body.append(separator);
                    for (i = 0; i < requestIDList.size(); ++i) {
                        BigDecimal requestID = (BigDecimal)requestIDList.get(i);
                        try {
                            OID oid = new OID(QueueItem.BASE_DATA_OBJECT_TYPE);
                            oid.set("requestID", requestID);
                            oid.set("partyTo", partyID);
                            QueueItem notice = new QueueItem(oid);
                            noticeList.add(notice);
                            body.append(FROM);
                            body.append(notice.getFrom());
                            body.append(nl);
                            body.append(SUBJECT);
                            body.append(notice.getSubject());
                            body.append(nl).append(nl);
                            body.append(StringUtils.addNewline(notice.getBody()));
                            body.append(separator);
                            try {
                                notice.addAttachments(mail);
                            }
                            catch (MessagingException ex) {
                                log.warn((Object)"error handling attachments", (Throwable)ex);
                            }
                            continue;
                        }
                        catch (DataObjectNotFoundException ex) {
                            log.warn((Object)"error handling notification", (Throwable)ex);
                        }
                    }
                    body.append(signature);
                    try {
                        mail.setBody(body.toString());
                        mail.send();
                        for (i = 0; i < noticeList.size(); ++i) {
                            QueueItem n = (QueueItem)noticeList.get(i);
                            n.setSuccess(Boolean.TRUE);
                            n.save();
                        }
                    }
                    catch (MessagingException e) {
                        log.warn((Object)"Failed to send digest notification", (Throwable)e);
                        for (int i2 = 0; i2 < noticeList.size(); ++i2) {
                            QueueItem n = (QueueItem)noticeList.get(i2);
                            n.setSuccess(Boolean.FALSE);
                            n.incrRetryCount();
                            n.save();
                        }
                    }
                }
                digest.updateNextRun();
                digest.save();
            }
            session.getTransactionContext().commitTxn();
            committedTxn = true;
        }
        catch (Throwable t) {
            log.error((Object)"Unexpected error occured. DigestQueueManager disabled", t);
            throw new UncheckedWrapperException(t);
        }
        finally {
            if (!committedTxn) {
                session.getTransactionContext().abortTxn();
            }
        }
        time = System.currentTimeMillis() - time;
        log.info((Object)("DigestQueueManager completed in " + time + " ms."));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

