/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.notification;

import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.kernel.ACSObject;
import com.arsdigita.kernel.Party;
import com.arsdigita.notification.NotificationConstants;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.OID;
import com.arsdigita.util.Assert;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;

public class Digest
extends ACSObject
implements NotificationConstants {
    public static final String BASE_DATA_OBJECT_TYPE = "com.arsdigita.notification.Digest";
    public static final int HOURLY = 60;
    public static final int DAILY = 1440;
    public static final int WEEKLY = 10080;

    public Digest() {
        super(BASE_DATA_OBJECT_TYPE);
        this.setSeparator('-', 78);
        this.setFrequency(60);
        this.setNextRun(new Date());
    }

    public Digest(Party from, String subject, String header, String signature) {
        this();
        Assert.assertNotNull(from, "Party from");
        Assert.assertNotNull(subject, "String subject");
        Assert.assertNotNull(header, "String header");
        Assert.assertNotNull(signature, "String signature");
        this.setFrom(from);
        this.setSubject(subject);
        this.setHeader(header);
        this.setSignature(signature);
    }

    public Digest(OID oid) throws DataObjectNotFoundException {
        super(oid);
    }

    public Digest(DataObject dataObj) {
        super(dataObj);
    }

    public Digest(BigDecimal id) throws DataObjectNotFoundException {
        this(new OID(BASE_DATA_OBJECT_TYPE, (Object)id));
    }

    public Party getFrom() throws DataObjectNotFoundException {
        return (Party)DomainObjectFactory.newInstance(new OID("com.arsdigita.kernel.Party", this.get("partyFrom")));
    }

    public String getFromEmail() {
        try {
            return this.getFrom().getPrimaryEmail().toString();
        }
        catch (DataObjectNotFoundException ex) {
            return null;
        }
    }

    public void setFrom(Party from) {
        Assert.assertNotNull(from, "Party from");
        this.set("partyFrom", from.getID());
    }

    public String getSubject() {
        return (String)this.get("subject");
    }

    public void setSubject(String subject) {
        this.set("subject", subject);
    }

    public String getHeader() {
        return (String)this.get("header");
    }

    public void setHeader(String header) {
        this.set("header", header);
    }

    public String getSeparator() {
        return (String)this.get("separator");
    }

    public void setSeparator(String separator) {
        this.set("separator", separator);
    }

    public void setSeparator(char s, int n) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            sb.append(s);
        }
        this.setSeparator(sb.toString());
    }

    public String getSignature() {
        return (String)this.get("signature");
    }

    public void setSignature(String signature) {
        this.set("signature", signature);
    }

    public Integer getFrequency() {
        return (Integer)this.get("frequency");
    }

    public void setFrequency(int frequency) {
        this.set("frequency", new Integer(frequency));
    }

    private void setNextRun(Date nextRun) {
        this.set("nextRun", nextRun);
    }

    void updateNextRun() {
        Calendar cal = Calendar.getInstance();
        cal.add(12, this.getFrequency());
        this.setNextRun(cal.getTime());
    }

    public Date getNextRun() {
        return (Date)this.get("nextRun");
    }

    protected void beforeSave() {
        Party from;
        String message = "Digest cannot be saved without a valid sender";
        if (this.get("partyFrom") == null) {
            throw new IllegalStateException(message);
        }
        try {
            from = this.getFrom();
        }
        catch (DataObjectNotFoundException ex) {
            throw new IllegalStateException(message);
        }
        if (from == null || from.getPrimaryEmail() == null) {
            throw new IllegalStateException(message);
        }
        super.beforeSave();
    }
}

