/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.mimetypes;

import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.mimetypes.GenericDomainService;
import com.arsdigita.mimetypes.MimeTypeCollection;
import com.arsdigita.mimetypes.MimeTypeExtension;
import com.arsdigita.mimetypes.MimeTypeExtensionCollection;
import com.arsdigita.persistence.DataAssociation;
import com.arsdigita.persistence.DataCollection;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.Filter;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.util.UncheckedWrapperException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.apache.log4j.Logger;

public class MimeType
extends DomainObject {
    public static final String BASE_DATA_OBJECT_TYPE = "com.arsdigita.cms.MimeType";
    public static final String MIME_TYPE = "mimeType";
    public static final String LABEL = "label";
    public static final String FILE_EXTENSION = "fileExtension";
    public static final String ALL_FILE_EXTENSIONS = "extensions";
    public static final String JAVA_CLASS = "javaClass";
    public static final String OBJECT_TYPE = "objectType";
    private static Class[] s_dataArgs = new Class[]{class$com$arsdigita$persistence$DataObject == null ? (class$com$arsdigita$persistence$DataObject = MimeType.class$("com.arsdigita.persistence.DataObject")) : class$com$arsdigita$persistence$DataObject};
    private static Class[] s_newArgs = new Class[]{class$java$lang$String == null ? (class$java$lang$String = MimeType.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = MimeType.class$("java.lang.String")) : class$java$lang$String};
    private static Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$mimetypes$MimeType == null ? (class$com$arsdigita$mimetypes$MimeType = MimeType.class$("com.arsdigita.mimetypes.MimeType")) : class$com$arsdigita$mimetypes$MimeType));
    static /* synthetic */ Class class$com$arsdigita$persistence$DataObject;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$com$arsdigita$mimetypes$MimeType;

    public MimeType(OID oid) throws DataObjectNotFoundException {
        super(oid);
    }

    public MimeType(DataObject obj) {
        super(obj);
    }

    public MimeType(String type, String mimeType) {
        super(type);
        this.setMimeType(mimeType);
        this.setSpecificObjectType(type);
    }

    public String getMimeType() {
        return (String)this.get(MIME_TYPE);
    }

    public void setMimeType(String value) {
        this.set(MIME_TYPE, value);
    }

    public String getLabel() {
        return (String)this.get(LABEL);
    }

    public void setLabel(String value) {
        this.set(LABEL, value);
    }

    public String getFileExtension() {
        return (String)this.get(FILE_EXTENSION);
    }

    public MimeTypeExtensionCollection getAllFileExtensions() {
        DataAssociation association = (DataAssociation)this.get(ALL_FILE_EXTENSIONS);
        if (association != null) {
            return new MimeTypeExtensionCollection(association);
        }
        return null;
    }

    public boolean hasFileExtension(String fileExtension) {
        DataAssociation association = (DataAssociation)this.get(ALL_FILE_EXTENSIONS);
        if (association != null) {
            association.addEqualsFilter(FILE_EXTENSION, fileExtension);
            boolean exists = association.next();
            association.close();
            return exists;
        }
        return false;
    }

    public void setFileExtension(String value) {
        this.set(FILE_EXTENSION, value);
    }

    public String getJavaClass() {
        return (String)this.get(JAVA_CLASS);
    }

    public void setJavaClass(String javaClassName) {
        this.set(JAVA_CLASS, javaClassName);
    }

    public String getSpecificObjectType() {
        return (String)this.get(OBJECT_TYPE);
    }

    public void setSpecificObjectType(String objectType) {
        this.set(OBJECT_TYPE, objectType);
    }

    public MimeType specialize() {
        if (this.getClass().getName().equals(this.getJavaClass())) {
            return this;
        }
        try {
            Class<?> mimeClass = Class.forName(this.getJavaClass());
            Constructor<?> constr = mimeClass.getConstructor(s_dataArgs);
            DataObject data = GenericDomainService.getDataObject(this);
            data.specialize(this.getSpecificObjectType());
            return (MimeType)constr.newInstance(data);
        }
        catch (Exception e) {
            s_log.error((Object)"Error in specialization", (Throwable)e);
            return this;
        }
    }

    public String getBaseDataObjectType() {
        return BASE_DATA_OBJECT_TYPE;
    }

    public String getPrefix() {
        String mt = this.getMimeType();
        int i = mt.indexOf("/");
        if (i == -1) {
            return mt;
        }
        return mt.substring(0, i);
    }

    public static MimeType loadMimeType(String mimeTypeName) {
        MimeType mime;
        try {
            mime = new MimeType(new OID(BASE_DATA_OBJECT_TYPE, (Object)mimeTypeName));
        }
        catch (DataObjectNotFoundException ex) {
            return null;
        }
        String mimeClassName = mime.getJavaClass();
        try {
            Class<?> mimeClass = Class.forName(mimeClassName);
            Constructor<?> constr = mimeClass.getConstructor(s_dataArgs);
            DataObject data = GenericDomainService.getDataObject(mime);
            data.specialize(mime.getSpecificObjectType());
            return (MimeType)constr.newInstance(data);
        }
        catch (Exception e) {
            throw new UncheckedWrapperException("Error instantiating MimeType", e);
        }
    }

    public static MimeType createMimeType(String mimeTypeName, String javaClass, String objectType) {
        Exception exception = null;
        try {
            Class<?> mimeClass = Class.forName(javaClass);
            Constructor<?> constr = mimeClass.getConstructor(s_newArgs);
            MimeType mime = (MimeType)constr.newInstance(objectType, mimeTypeName);
            mime.setJavaClass(javaClass);
            return mime;
        }
        catch (SecurityException e) {
            s_log.error((Object)"SecurityException", (Throwable)e);
            exception = e;
        }
        catch (IllegalArgumentException e) {
            s_log.error((Object)"IllegalArgumentException", (Throwable)e);
            exception = e;
        }
        catch (ClassNotFoundException e) {
            s_log.error((Object)"ClassNotFoundException", (Throwable)e);
            exception = e;
        }
        catch (NoSuchMethodException e) {
            s_log.error((Object)"NoSuchMethodException", (Throwable)e);
            exception = e;
        }
        catch (InstantiationException e) {
            s_log.error((Object)"InstantiationException", (Throwable)e);
            exception = e;
        }
        catch (IllegalAccessException e) {
            s_log.error((Object)"IllegalAccessException", (Throwable)e);
            exception = e;
        }
        catch (InvocationTargetException e) {
            s_log.error((Object)"InvocationTargetException", (Throwable)e);
            exception = e;
        }
        String msg = "Couldn't createMimeType for mimeType " + mimeTypeName + " Class: " + javaClass + " Object Type: " + objectType;
        throw new UncheckedWrapperException(msg, exception);
    }

    public static MimeType guessMimeType(String fileExtension) {
        MimeTypeExtension ext = MimeTypeExtension.retrieve(fileExtension.toLowerCase());
        if (ext == null) {
            return null;
        }
        return ext.getMimeTypeObject();
    }

    public static MimeType guessMimeTypeFromFile(String fileName) {
        int i = fileName.lastIndexOf(".");
        if (i != -1) {
            return MimeType.guessMimeType(fileName.substring(i + 1));
        }
        return null;
    }

    protected void beforeSave() {
        if (this.isNew()) {
            if (null == this.getJavaClass()) {
                this.setJavaClass(this.getClass().getName());
            }
            if (null == this.getSpecificObjectType()) {
                this.setSpecificObjectType(this.getOID().getObjectType().getQualifiedName());
            }
        }
        super.beforeSave();
    }

    public static MimeTypeCollection getAllMimeTypes() {
        DataCollection da = SessionManager.getSession().retrieve(BASE_DATA_OBJECT_TYPE);
        return new MimeTypeCollection(da);
    }

    public static MimeTypeCollection searchMimeTypes(String startsWith) {
        DataCollection da = SessionManager.getSession().retrieve(BASE_DATA_OBJECT_TYPE);
        Filter filter = da.addFilter("mimeType like (:startsWith || '%')");
        filter.set("startsWith", startsWith);
        return new MimeTypeCollection(da);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

