/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.kernel.ui;

import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.ParameterSingleSelectionModel;
import com.arsdigita.bebop.RequestLocal;
import com.arsdigita.bebop.SingleSelectionModel;
import com.arsdigita.bebop.event.ChangeListener;
import com.arsdigita.bebop.parameters.BigDecimalParameter;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.kernel.ACSObject;
import com.arsdigita.kernel.ACSObjectCache;
import com.arsdigita.kernel.ui.DomainObjectSelectionModel;
import com.arsdigita.persistence.OID;
import com.arsdigita.util.Assert;
import com.arsdigita.util.UncheckedWrapperException;
import java.lang.reflect.Constructor;
import java.math.BigDecimal;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import org.apache.log4j.Logger;

public class ACSObjectSelectionModel
implements DomainObjectSelectionModel {
    private static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$kernel$ui$ACSObjectSelectionModel == null ? (class$com$arsdigita$kernel$ui$ACSObjectSelectionModel = ACSObjectSelectionModel.class$("com.arsdigita.kernel.ui.ACSObjectSelectionModel")) : class$com$arsdigita$kernel$ui$ACSObjectSelectionModel));
    private RequestLocal m_loaded = new RequestLocal(){

        protected Object initialValue(PageState state) {
            return Boolean.FALSE;
        }
    };
    private Class m_javaClass;
    private Constructor m_constructor;
    private String m_objectType;
    private SingleSelectionModel m_model;
    static /* synthetic */ Class class$com$arsdigita$kernel$ui$ACSObjectSelectionModel;
    static /* synthetic */ Class class$com$arsdigita$persistence$OID;
    static /* synthetic */ Class class$java$lang$Class;

    public ACSObjectSelectionModel(BigDecimalParameter parameter) {
        this(null, null, parameter);
    }

    public ACSObjectSelectionModel(String parameterName) {
        this(null, null, new BigDecimalParameter(parameterName));
    }

    public ACSObjectSelectionModel(SingleSelectionModel model) {
        this(null, null, model);
    }

    public ACSObjectSelectionModel(String javaClass, String objectType, String parameterName) {
        this(javaClass, objectType, new BigDecimalParameter(parameterName));
    }

    public ACSObjectSelectionModel(String javaClass, String objectType, BigDecimalParameter parameter) {
        this(javaClass, objectType, new ParameterSingleSelectionModel(parameter));
    }

    public ACSObjectSelectionModel(String javaClass, String objectType, SingleSelectionModel model) {
        if (javaClass != null) {
            try {
                this.m_javaClass = Class.forName(javaClass);
                this.m_constructor = this.m_javaClass.getConstructor(class$com$arsdigita$persistence$OID == null ? (class$com$arsdigita$persistence$OID = ACSObjectSelectionModel.class$("com.arsdigita.persistence.OID")) : class$com$arsdigita$persistence$OID);
            }
            catch (Exception e) {
                throw new UncheckedWrapperException("Problem loading class " + javaClass, e);
            }
        }
        this.m_objectType = objectType;
        this.m_model = model;
    }

    public void setSelectedKey(PageState state, Object key) {
        this.m_loaded.set(state, (Object)Boolean.FALSE);
        this.m_model.setSelectedKey(state, key);
    }

    public DomainObject getSelectedObject(PageState state) {
        BigDecimal id = ACSObjectSelectionModel.convertToBigDecimal(this.getSelectedKey(state));
        if (id == null) {
            return null;
        }
        if (!this.isInitialized(state)) {
            this.m_loaded.set(state, (Object)Boolean.TRUE);
            if (!this.isSelected(state)) {
                return null;
            }
            ACSObject item = ACSObjectCache.get((ServletRequest)state.getRequest(), id);
            if (null != item) {
                return item;
            }
            item = this.loadACSObject(state, id);
            if (item != null) {
                ACSObjectCache.set((ServletRequest)state.getRequest(), item);
            }
            return item;
        }
        return ACSObjectCache.get((ServletRequest)state.getRequest(), id);
    }

    protected ACSObject loadACSObject(PageState state, Object key) {
        Object item = null;
        BigDecimal id = ACSObjectSelectionModel.convertToBigDecimal(key);
        String objectType = this.m_objectType;
        if (null == objectType) {
            objectType = "com.arsdigita.kernel.ACSObject";
        }
        try {
            OID oid = new OID(objectType, (Object)id);
            return (ACSObject)DomainObjectFactory.newInstance(oid);
        }
        catch (DataObjectNotFoundException e) {
            return null;
        }
    }

    public void setSelectedObject(PageState state, DomainObject object) {
        ACSObject item = (ACSObject)object;
        if (item == null) {
            this.m_loaded.set(state, (Object)Boolean.FALSE);
            this.m_model.setSelectedKey(state, null);
        } else {
            this.m_loaded.set(state, (Object)Boolean.TRUE);
            ACSObjectCache.set((ServletRequest)state.getRequest(), item);
            this.m_model.setSelectedKey(state, item.getID());
        }
    }

    public boolean isInitialized(PageState state) {
        return (Boolean)this.m_loaded.get(state);
    }

    public ACSObject createACSObject(BigDecimal id) throws ServletException {
        return this.createACSObject();
    }

    public ACSObject createACSObject() throws ServletException {
        Assert.exists(this.m_javaClass, class$java$lang$Class == null ? (class$java$lang$Class = ACSObjectSelectionModel.class$("java.lang.Class")) : class$java$lang$Class);
        try {
            ACSObject item = (ACSObject)this.m_javaClass.newInstance();
            return item;
        }
        catch (InstantiationException e) {
            throw new ServletException((Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new ServletException((Throwable)e);
        }
    }

    public Class getJavaClass() {
        return this.m_javaClass;
    }

    public String getObjectType() {
        return this.m_objectType;
    }

    public SingleSelectionModel getSingleSelectionModel() {
        return this.m_model;
    }

    public boolean isSelected(PageState state) {
        return this.m_model.isSelected(state);
    }

    public Object getSelectedKey(PageState state) {
        Object key = this.m_model.getSelectedKey(state);
        return key;
    }

    public void clearSelection(PageState state) {
        this.m_model.clearSelection(state);
        this.m_loaded.set(state, (Object)Boolean.FALSE);
    }

    public void addChangeListener(ChangeListener l) {
        this.m_model.addChangeListener(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.m_model.removeChangeListener(l);
    }

    public ParameterModel getStateParameter() {
        return this.m_model.getStateParameter();
    }

    private static BigDecimal convertToBigDecimal(Object value) {
        BigDecimal newValue = null;
        if (value instanceof BigDecimal) {
            newValue = (BigDecimal)value;
        } else if (value != null) {
            newValue = new BigDecimal(value.toString());
        }
        return newValue;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

