/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.kernel.security;

import com.arsdigita.kernel.security.CredentialEncodingException;
import com.arsdigita.kernel.security.CredentialExpiredException;
import com.arsdigita.kernel.security.CredentialParsingException;
import com.arsdigita.kernel.security.Crypto;
import com.arsdigita.kernel.security.KernelLoginException;
import com.arsdigita.util.UncheckedWrapperException;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;
import java.util.Arrays;
import java.util.Date;
import java.util.StringTokenizer;
import javax.crypto.Mac;
import org.apache.commons.codec.binary.Base64;

public class Credential {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/kernel/security/Credential.java#12 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    public static final char SEPARATOR = '!';
    private String m_value;
    private long m_expiration;
    private byte[] m_validator;

    private Credential(String value, long expiration, byte[] validator) {
        this.m_value = value;
        this.m_expiration = expiration;
        this.m_validator = validator;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.m_value).append('!');
        buf.append(this.m_expiration).append('!');
        buf.append(new String(new Base64().encode(this.m_validator)));
        return buf.toString();
    }

    public String getValue() {
        return this.m_value;
    }

    public Date getExpiration() {
        return new Date(this.m_expiration);
    }

    public boolean hasExpired() {
        return this.m_expiration < System.currentTimeMillis();
    }

    public static Credential create(String value, long lifetimeMillis) throws CredentialEncodingException {
        Mac mac;
        try {
            mac = Crypto.newMac();
        }
        catch (GeneralSecurityException ex) {
            throw new CredentialEncodingException("Couldn't create a MAC", ex);
        }
        return Credential.create(value, lifetimeMillis, mac);
    }

    static Credential create(String value, long lifetimeMillis, Mac mac) throws CredentialEncodingException {
        if (value.indexOf(33) != -1) {
            throw new CredentialEncodingException("value must not contain separator character (!): " + value);
        }
        if (lifetimeMillis < 0L) {
            throw new CredentialEncodingException("lifetime must not be negative: " + lifetimeMillis);
        }
        try {
            long expiration = System.currentTimeMillis() + lifetimeMillis;
            return new Credential(value, expiration, Credential.createValidator(value, expiration, mac));
        }
        catch (ValidatorException ex) {
            throw new CredentialEncodingException(ex.getRootCause());
        }
    }

    public static Credential parse(String credential) throws CredentialParsingException, CredentialExpiredException {
        Mac mac;
        try {
            mac = Crypto.newMac();
        }
        catch (GeneralSecurityException ex) {
            throw new CredentialParsingException("Couldn't create a MAC", ex);
        }
        return Credential.parse(credential, mac);
    }

    static Credential parse(String credential, Mac mac) throws CredentialParsingException, CredentialExpiredException {
        byte[] calculated;
        byte[] validator;
        long expiration;
        StringTokenizer tok = new StringTokenizer(credential, String.valueOf('!'));
        if (tok.countTokens() != 3) {
            throw new CredentialParsingException("Bad format");
        }
        String value = tok.nextToken();
        try {
            expiration = Long.parseLong(tok.nextToken());
        }
        catch (NumberFormatException e) {
            throw new CredentialParsingException("Bad expiration", e);
        }
        if (expiration < System.currentTimeMillis()) {
            throw new CredentialExpiredException(new Date(expiration).toString());
        }
        try {
            validator = new Base64().decode(tok.nextToken().getBytes("UTF-8"));
            calculated = Credential.createValidator(value, expiration, mac);
        }
        catch (ValidatorException ex) {
            throw new CredentialParsingException(ex.getRootCause());
        }
        catch (UnsupportedEncodingException uec) {
            throw new UncheckedWrapperException(uec);
        }
        if (!Arrays.equals(validator, calculated)) {
            throw new CredentialParsingException("Bad validator");
        }
        return new Credential(value, expiration, validator);
    }

    private static byte[] createValidator(String value, long expiration, Mac mac) throws ValidatorException {
        if (mac == null) {
            throw new NullPointerException("mac");
        }
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(baos);
            dos.writeUTF(value);
            dos.writeLong(expiration);
            byte[] data = baos.toByteArray();
            return mac.doFinal(data);
        }
        catch (IOException ex) {
            throw new ValidatorException(ex);
        }
    }

    private static class ValidatorException
    extends KernelLoginException {
        public ValidatorException(Exception rootCause) {
            super(rootCause);
        }
    }
}

