/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.globalization;

import com.arsdigita.globalization.ApplicationLocaleProvider;
import com.arsdigita.globalization.Charset;
import com.arsdigita.globalization.ClientLocaleProvider;
import com.arsdigita.globalization.Globalization;
import com.arsdigita.globalization.Locale;
import com.arsdigita.globalization.LocaleNegotiator;
import com.arsdigita.globalization.SystemLocaleProvider;
import com.arsdigita.initializer.Configuration;
import com.arsdigita.initializer.InitializationException;
import com.arsdigita.persistence.DataCollection;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.persistence.TransactionContext;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;

public class Initializer
implements com.arsdigita.initializer.Initializer {
    private static final String DEFAULT_CHARSET = "defaultCharset";
    private static final String CHARSETS = "charsets";
    private static final String LOCALES = "locales";
    private static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$globalization$Initializer == null ? (class$com$arsdigita$globalization$Initializer = Initializer.class$("com.arsdigita.globalization.Initializer")) : class$com$arsdigita$globalization$Initializer));
    private Configuration m_conf = new Configuration();
    static /* synthetic */ Class class$com$arsdigita$globalization$Initializer;
    static /* synthetic */ Class class$java$util$List;
    static /* synthetic */ Class class$java$lang$String;

    public Initializer() throws InitializationException {
        this.m_conf.initParameter(CHARSETS, "Recognized character sets", class$java$util$List == null ? (class$java$util$List = Initializer.class$("java.util.List")) : class$java$util$List);
        this.m_conf.initParameter(LOCALES, "Recognized locales", class$java$util$List == null ? (class$java$util$List = Initializer.class$("java.util.List")) : class$java$util$List);
        this.m_conf.initParameter(DEFAULT_CHARSET, "Default character set for locales not listed", class$java$lang$String == null ? (class$java$lang$String = Initializer.class$("java.lang.String")) : class$java$lang$String);
    }

    public Configuration getConfiguration() {
        return this.m_conf;
    }

    public void startup() throws InitializationException {
        TransactionContext txn = SessionManager.getSession().getTransactionContext();
        txn.beginTxn();
        if (!Initializer.isLoaded()) {
            s_log.info((Object)"Globalization Initializer is loading.");
            this.load();
        }
        LocaleNegotiator.setApplicationLocaleProvider(new ApplicationLocaleProvider());
        LocaleNegotiator.setClientLocaleProvider(new ClientLocaleProvider());
        LocaleNegotiator.setSystemLocaleProvider(new SystemLocaleProvider());
        String defaultCharset = (String)this.m_conf.getParameter(DEFAULT_CHARSET);
        Globalization.setDefaultCharset(defaultCharset);
        txn.commitTxn();
    }

    public void shutdown() {
    }

    private static boolean isLoaded() {
        DataCollection charsets = SessionManager.getSession().retrieve("com.arsdigita.globalization.Charset");
        boolean result = charsets.size() > 0L;
        charsets.close();
        return result;
    }

    private void load() throws InitializationException {
        List charsets = (List)this.m_conf.getParameter(CHARSETS);
        if (charsets == null) {
            throw new InitializationException("You must specify at least one charset in the \"charsets\" parameter of the globalization initaliazer in the init  file. ISO-8859-1 would be a good first choice.");
        }
        HashMap<String, Charset> charsetMap = new HashMap<String, Charset>();
        Iterator i = charsets.iterator();
        while (i.hasNext()) {
            String charsetName = (String)i.next();
            try {
                new OutputStreamWriter((OutputStream)new ByteArrayOutputStream(), charsetName);
            }
            catch (UnsupportedEncodingException ex) {
                throw new InitializationException(charsetName + " is not a supported charset", ex);
            }
            Charset charset = new Charset();
            charset.setCharset(charsetName);
            charset.save();
            charsetMap.put(charsetName, charset);
        }
        List locales = (List)this.m_conf.getParameter(LOCALES);
        if (locales == null) {
            throw new InitializationException("You must specify at least one locale in the \"locales\" parameter of the globalization initializer section of the init file. The \"en\" locale is probably required.");
        }
        Iterator i2 = locales.iterator();
        while (i2.hasNext()) {
            List localeData = (List)i2.next();
            String language = (String)localeData.get(0);
            String country = (String)localeData.get(1);
            String variant = (String)localeData.get(2);
            String charsetName = (String)localeData.get(3);
            Locale locale = new Locale(language, country, variant);
            Charset defaultCharset = (Charset)charsetMap.get(charsetName);
            if (defaultCharset == null) {
                throw new InitializationException("You must list " + charsetName + " in the \"" + CHARSETS + "\" parameter before using it in the \"" + LOCALES + "\" parameter.");
            }
            locale.setDefaultCharset(defaultCharset);
            locale.save();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

