/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.formbuilder;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.form.MultipleSelect;
import com.arsdigita.bebop.form.Option;
import com.arsdigita.bebop.form.Select;
import com.arsdigita.bebop.form.SingleSelect;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.formbuilder.PersistentDataQuery;
import com.arsdigita.formbuilder.PersistentWidget;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.DataQuery;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.Session;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.persistence.metadata.ObjectType;
import com.arsdigita.util.UncheckedWrapperException;
import java.math.BigDecimal;

public class DataDrivenSelect
extends PersistentWidget {
    public static final String BASE_DATA_OBJECT_TYPE = "com.arsdigita.formbuilder.DataDrivenSelect";
    public static final String MULTIPLE = "multiple";
    public static final String QUERY = "queryId";

    public DataDrivenSelect() {
        this(BASE_DATA_OBJECT_TYPE);
    }

    public DataDrivenSelect(String typeName) {
        super(typeName);
    }

    public DataDrivenSelect(ObjectType type) {
        super(type);
    }

    public DataDrivenSelect(DataObject obj) {
        super(obj);
    }

    public DataDrivenSelect(BigDecimal id) throws DataObjectNotFoundException {
        this(new OID(BASE_DATA_OBJECT_TYPE, (Object)id));
    }

    public DataDrivenSelect(OID oid) throws DataObjectNotFoundException {
        super(oid);
    }

    public String getBaseDataObjectType() {
        return BASE_DATA_OBJECT_TYPE;
    }

    public boolean isMultiple() {
        return (Boolean)this.get(MULTIPLE);
    }

    public void setMultiple(boolean multiple) {
        this.set(MULTIPLE, new Boolean(multiple));
    }

    public PersistentDataQuery getQuery() throws DataObjectNotFoundException {
        return new PersistentDataQuery((BigDecimal)this.get(QUERY));
    }

    public void setQuery(PersistentDataQuery query) {
        this.set(QUERY, query.getID());
    }

    public BigDecimal getQueryID() {
        return (BigDecimal)this.get(QUERY);
    }

    public void setQueryID(BigDecimal query) {
        this.set(QUERY, query);
    }

    public Component createComponent() {
        Select select = this.isMultiple() ? new MultipleSelect(this.getParameterName()) : new SingleSelect(this.getParameterName());
        PersistentDataQuery query = null;
        try {
            query = this.getQuery();
        }
        catch (DataObjectNotFoundException ex) {
            throw new UncheckedWrapperException(ex);
        }
        String name = query.getName();
        Session ssn = SessionManager.getSession();
        DataQuery items = ssn.retrieveQuery(name);
        while (items.next()) {
            String id = items.get("id").toString();
            String label = items.get("label").toString();
            select.addOption(new Option(id, label));
        }
        return select;
    }
}

