/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.dispatcher;

import com.arsdigita.developersupport.DeveloperSupport;
import com.arsdigita.dispatcher.Dispatcher;
import com.arsdigita.dispatcher.DispatcherHelper;
import com.arsdigita.dispatcher.JSPApplicationDispatcher;
import com.arsdigita.dispatcher.RequestContext;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.log4j.Logger;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class MapDispatcher
implements Dispatcher {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/dispatcher/MapDispatcher.java#13 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private Map m_map = new HashMap();
    private Dispatcher m_notFoundHandler = JSPApplicationDispatcher.getInstance();
    private File m_configFile;
    private long m_configFileTimeRead;
    private static final Logger s_log = Logger.getLogger((String)(class$com$arsdigita$dispatcher$MapDispatcher == null ? (class$com$arsdigita$dispatcher$MapDispatcher = MapDispatcher.class$("com.arsdigita.dispatcher.MapDispatcher")) : class$com$arsdigita$dispatcher$MapDispatcher).getName());
    static /* synthetic */ Class class$com$arsdigita$dispatcher$MapDispatcher;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispatch(HttpServletRequest req, HttpServletResponse resp, RequestContext ctx) throws IOException, ServletException {
        Dispatcher target;
        s_log.debug((Object)"MapDispacher.dispatch called");
        DeveloperSupport.startStage("MapDispatcher.dispatch");
        String url = ctx.getRemainingURLPart();
        String mapURL = null;
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("Searching for URL '" + url + "' in map '" + this.m_map + "'"));
        }
        MapDispatcher mapDispatcher = this;
        synchronized (mapDispatcher) {
            if (this.m_configFile != null && this.m_configFile.lastModified() > this.m_configFileTimeRead) {
                this.readFromFile(this.m_configFile);
            }
            if ((target = (Dispatcher)this.m_map.get(url)) == null && url.endsWith("/")) {
                String strippedURL = url.substring(0, url.length() - 1);
                target = (Dispatcher)this.m_map.get(strippedURL);
                mapURL = strippedURL;
            } else {
                mapURL = url;
            }
        }
        if (target == null) {
            s_log.debug((Object)"No URL match found; trying to serve the not-found page");
            target = this.m_notFoundHandler;
        }
        if (target != null) {
            this.preprocessRequest(req, resp, ctx, mapURL);
            target.dispatch(req, resp, ctx);
        } else {
            resp.setContentType("text/html");
            resp.setStatus(404);
            PrintWriter pw = new PrintWriter(resp.getWriter());
            pw.println("<h2>Not found</h2>");
            pw.print("Could not find the page you requested: ");
            pw.println(ctx.getOriginalURL());
            pw.close();
        }
        DeveloperSupport.endStage("MapDispatcher.dispatch");
    }

    public synchronized void setMap(Map m) {
        this.m_map = m;
    }

    protected void preprocessRequest(HttpServletRequest req, HttpServletResponse resp, RequestContext ctx, String url) {
    }

    protected Map getMap() {
        return this.m_map;
    }

    public final synchronized void addPage(String url, Dispatcher d) {
        this.m_map.put(url, d);
    }

    public final void setNotFoundDispatcher(Dispatcher d) {
        this.m_notFoundHandler = d;
    }

    public void requireTrailingSlash(String url) {
    }

    public final void readFromFile(File file) {
        try {
            SAXParserFactory spf = SAXParserFactory.newInstance();
            SAXParser parser = spf.newSAXParser();
            HashMap m = new HashMap();
            this.setMap(m);
            parser.parse(file, this.newParseConfigHandler(this));
            this.m_configFile = file;
            this.m_configFileTimeRead = System.currentTimeMillis();
        }
        catch (ParserConfigurationException e) {
            s_log.error((Object)"error parsing dispatcher config", (Throwable)e);
        }
        catch (SAXException e) {
            s_log.error((Object)"error parsing dispatcher config", (Throwable)e);
        }
        catch (IOException e) {
            s_log.error((Object)"error parsing dispatcher config", (Throwable)e);
        }
    }

    protected DefaultHandler newParseConfigHandler(MapDispatcher md) {
        return new ParseConfigHandler(md);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected static class ParseConfigHandler
    extends DefaultHandler {
        private MapDispatcher m_map;
        protected StringBuffer m_buffer;
        private String m_url;
        protected Dispatcher m_dispatcher;

        protected ParseConfigHandler(MapDispatcher m) {
            this.m_map = m;
            this.m_buffer = new StringBuffer();
        }

        public void characters(char[] ch, int start, int len) {
            for (int i = 0; i < len; ++i) {
                this.m_buffer.append(ch[start + i]);
            }
        }

        public void endElement(String uri, String localName, String qname) {
            if (qname.equals("url")) {
                this.m_url = this.m_buffer.toString().trim();
            } else if (qname.equals("servlet-name")) {
                String servletName = this.m_buffer.toString().trim();
                this.m_dispatcher = new Dispatcher(this, servletName){
                    private final /* synthetic */ String val$servletName;
                    private final /* synthetic */ ParseConfigHandler this$0;
                    {
                        this.this$0 = this$0;
                        this.val$servletName = val$servletName;
                    }

                    public void dispatch(HttpServletRequest req, HttpServletResponse resp, RequestContext rctx) throws IOException, ServletException {
                        DispatcherHelper.forwardRequestByName(this.val$servletName, req, resp);
                    }
                };
            } else if (qname.equals("dispatcher-class")) {
                try {
                    Class<?> pclass = Class.forName(this.m_buffer.toString().trim());
                    this.m_dispatcher = (Dispatcher)pclass.newInstance();
                }
                catch (Exception e) {
                    s_log.error((Object)"error in parsing config file", (Throwable)e);
                }
            } else if (qname.equals("url-mapping")) {
                this.m_map.addPage(this.m_url, this.m_dispatcher);
            } else if (qname.equals("default-handler")) {
                this.m_map.setNotFoundDispatcher(this.m_dispatcher);
            }
            this.m_buffer = new StringBuffer();
        }
    }
}

