/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.bebop.page;

import com.arsdigita.bebop.Bebop;
import com.arsdigita.developersupport.DeveloperSupport;
import com.arsdigita.dispatcher.DispatcherHelper;
import com.arsdigita.globalization.Globalization;
import com.arsdigita.kernel.Kernel;
import com.arsdigita.templating.PresentationManager;
import com.arsdigita.templating.Templating;
import com.arsdigita.templating.XSLParameterGenerator;
import com.arsdigita.templating.XSLTemplate;
import com.arsdigita.util.Assert;
import com.arsdigita.util.UncheckedWrapperException;
import com.arsdigita.web.CachePolicy;
import com.arsdigita.web.Debugger;
import com.arsdigita.web.TransformationDebugger;
import com.arsdigita.web.URL;
import com.arsdigita.web.Web;
import com.arsdigita.xml.Document;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.log4j.Logger;

public class PageTransformer
implements PresentationManager {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/bebop/page/PageTransformer.java#17 $$Author: dennis $$DateTime: 2004/04/07 16:07:11 $";
    private static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$bebop$page$PageTransformer == null ? (class$com$arsdigita$bebop$page$PageTransformer = PageTransformer.class$("com.arsdigita.bebop.page.PageTransformer")) : class$com$arsdigita$bebop$page$PageTransformer));
    private static final HashMap s_XSLParameters = new HashMap();
    public static final String CACHE_XSL_NONE = "cacheXSLNone";
    public static final String FANCY_ERRORS = "fancyErrors";
    public static final String CACHE_NONE = "none";
    public static final String CACHE_USER = "user";
    public static final String CACHE_WORLD = "world";
    public static final String CACHE_DISABLE = "disable";
    private static String s_defaultCachePolicy;
    static /* synthetic */ Class class$com$arsdigita$bebop$page$PageTransformer;
    static /* synthetic */ Class class$com$arsdigita$xml$Document;
    static /* synthetic */ Class class$javax$servlet$http$HttpServletRequest;
    static /* synthetic */ Class class$javax$servlet$http$HttpServletResponse;

    public static void setDefaultCachePolicy(String policy) {
        s_defaultCachePolicy = policy;
    }

    private PrintWriter getWriter(HttpServletResponse resp, String contentType, String charset) {
        Assert.exists(contentType);
        Assert.exists(charset);
        resp.setContentType(contentType + "; " + "charset=" + charset);
        try {
            return resp.getWriter();
        }
        catch (IllegalStateException e) {
            s_log.warn((Object)"Using getOutputStream instead of getWriter");
            try {
                return new PrintWriter(new OutputStreamWriter((OutputStream)resp.getOutputStream(), charset));
            }
            catch (IOException ex) {
                throw new UncheckedWrapperException(ex);
            }
        }
        catch (IOException ex) {
            throw new UncheckedWrapperException(ex);
        }
    }

    public void servePage(Document doc, HttpServletRequest req, HttpServletResponse resp) {
        this.servePage(doc, req, resp, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void servePage(Document doc, HttpServletRequest req, HttpServletResponse resp, Map params) {
        if (Assert.isEnabled()) {
            Assert.exists(doc, class$com$arsdigita$xml$Document == null ? (class$com$arsdigita$xml$Document = PageTransformer.class$("com.arsdigita.xml.Document")) : class$com$arsdigita$xml$Document);
            Assert.exists(req, class$javax$servlet$http$HttpServletRequest == null ? (class$javax$servlet$http$HttpServletRequest = PageTransformer.class$("javax.servlet.http.HttpServletRequest")) : class$javax$servlet$http$HttpServletRequest);
            Assert.exists(resp, class$javax$servlet$http$HttpServletResponse == null ? (class$javax$servlet$http$HttpServletResponse = PageTransformer.class$("javax.servlet.http.HttpServletResponse")) : class$javax$servlet$http$HttpServletResponse);
        }
        String charset = Globalization.getDefaultCharset(Kernel.getContext().getLocale());
        String output = req.getParameter("output");
        s_log.info((Object)("output=" + output));
        if (output == null) {
            DeveloperSupport.startStage("PresMgr get stylesheet");
            boolean fancyErrors = Bebop.getConfig().wantFancyXSLErrors() || Boolean.TRUE.equals(req.getAttribute(FANCY_ERRORS));
            XSLTemplate template = Templating.getTemplate(req, fancyErrors, !Boolean.TRUE.equals(req.getAttribute(CACHE_XSL_NONE)));
            DeveloperSupport.endStage("PresMgr get stylesheet");
            DeveloperSupport.startStage("PresMgr transform");
            CachePolicy policy = Web.getConfig().getCachePolicy();
            if (policy != null) {
                policy.implement(req, resp);
            }
            PrintWriter writer = this.getWriter(resp, "text/html", charset);
            Transformer xf = template.newTransformer();
            this.endTransaction(req);
            xf.clearParameters();
            if (params != null) {
                Iterator entries = params.entrySet().iterator();
                while (entries.hasNext()) {
                    Map.Entry entry = entries.next();
                    xf.setParameter((String)entry.getKey(), entry.getValue());
                }
            }
            PageTransformer.addXSLParameters(xf, req);
            xf.setOutputProperty("encoding", charset);
            try {
                xf.transform(new DOMSource(doc.getInternalDocument()), new StreamResult(writer));
            }
            catch (TransformerException ex) {
                throw new UncheckedWrapperException("cannot transform document", ex);
            }
            DeveloperSupport.endStage("PresMgr transform");
            if (Kernel.getConfig().isDebugEnabled()) {
                Document origDoc = (Document)req.getAttribute("com.arsdigita.xml.Document");
                Debugger.addDebugger(new TransformationDebugger(template.getSource(), template.getDependents()));
                writer.print(Debugger.getDebugging(req));
            }
        } else if (output.equals("xml")) {
            this.endTransaction(req);
            PrintWriter writer = this.getWriter(resp, "text/xml", charset);
            DispatcherHelper.forceCacheDisable(resp);
            writer.println(doc.toString(true));
        } else {
            if (output.equals("xsl")) {
                DeveloperSupport.startStage("PresMgr get stylesheet");
                XSLTemplate template = null;
                try {
                    template = Templating.getTemplate(req, Boolean.TRUE.equals(req.getAttribute(FANCY_ERRORS)), !Boolean.TRUE.equals(req.getAttribute(CACHE_XSL_NONE)));
                    this.endTransaction(req);
                }
                finally {
                    DeveloperSupport.endStage("PresMgr get stylesheet");
                }
                DeveloperSupport.startStage("PresMgr send XSL ZIP");
                try {
                    Date now = new Date();
                    SimpleDateFormat fmt = new SimpleDateFormat("yyyy-MM-dd-HH-mm");
                    String prefix = "waf-xsl-" + fmt.format(now);
                    ServletOutputStream os = resp.getOutputStream();
                    resp.reset();
                    resp.setContentType("application/zip");
                    resp.setHeader("Content-Disposition", "attachment; filename=\"" + prefix + ".zip\"");
                    DispatcherHelper.forceCacheDisable(resp);
                    template.toZIP((OutputStream)os, prefix);
                    resp.flushBuffer();
                }
                catch (IOException ex) {
                    throw new UncheckedWrapperException(ex);
                }
                finally {
                    DeveloperSupport.endStage("PresMgr send XSL ZIP");
                }
            }
            throw new IllegalStateException(output + " is an unknown output");
        }
    }

    private void endTransaction(HttpServletRequest req) {
        if (req.getAttribute("javax.servlet.jsp.jspException") == null) {
            Kernel.getContext().getTransaction().end();
        } else {
            Kernel.getContext().getTransaction().abort();
        }
    }

    public static void registerXSLParameterGenerator(String parameterName, XSLParameterGenerator parameterGenerator) {
        s_XSLParameters.put(parameterName, parameterGenerator);
    }

    public static void removeXSLParameterGenerator(String parameterName) {
        s_XSLParameters.remove(parameterName);
    }

    public static Collection getXSLParameterNames() {
        return s_XSLParameters.keySet();
    }

    public static String getXSLParameterValue(String name, HttpServletRequest request) {
        XSLParameterGenerator generator = (XSLParameterGenerator)s_XSLParameters.get(name);
        if (generator != null) {
            return generator.generateValue(request);
        }
        return null;
    }

    public static void addXSLParameters(Transformer transformer, HttpServletRequest request) {
        Iterator entries = s_XSLParameters.entrySet().iterator();
        while (entries.hasNext()) {
            Map.Entry entry = entries.next();
            String value = ((XSLParameterGenerator)entry.getValue()).generateValue(request);
            if (value == null) {
                value = "";
            }
            transformer.setParameter((String)entry.getKey(), value);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        PageTransformer.registerXSLParameterGenerator("contextPath", new XSLParameterGenerator(){

            public String generateValue(HttpServletRequest request) {
                return request.getContextPath();
            }
        });
        PageTransformer.registerXSLParameterGenerator("root-context-prefix", new XSLParameterGenerator(){

            public String generateValue(HttpServletRequest request) {
                return Web.getConfig().getDispatcherContextPath();
            }
        });
        PageTransformer.registerXSLParameterGenerator("context-prefix", new XSLParameterGenerator(){

            public String generateValue(HttpServletRequest request) {
                return Web.getContext().getRequestURL().getContextPath();
            }
        });
        PageTransformer.registerXSLParameterGenerator("static-prefix", new XSLParameterGenerator(){

            public String generateValue(HttpServletRequest request) {
                return Web.getContext().getRequestURL().getContextPath() + "/__ccm__/static";
            }
        });
        PageTransformer.registerXSLParameterGenerator("dispatcher-prefix", new XSLParameterGenerator(){

            public String generateValue(HttpServletRequest request) {
                return URL.getDispatcherPath();
            }
        });
        s_defaultCachePolicy = CACHE_DISABLE;
    }
}

