/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.bebop.demo.workflow;

import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.demo.workflow.Process;
import com.arsdigita.bebop.demo.workflow.Task;
import com.arsdigita.bebop.list.ListModel;
import java.util.ArrayList;
import java.util.NoSuchElementException;

public class SampleProcesses {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/bebop/demo/workflow/SampleProcesses.java#8 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private static SampleProcesses m_instance;
    private ArrayList m_processes = new ArrayList();
    private static ArrayList m_allTasks;

    public static synchronized SampleProcesses getInstance() {
        if (m_instance == null) {
            m_instance = new SampleProcesses();
        }
        return m_instance;
    }

    private SampleProcesses() {
        Process simple = new Process("1", "Simple Article");
        Process front = new Process("2", "Front Page");
        Process legal = new Process("3", "Legal Article");
        Process press = new Process("4", "Press Release");
        this.m_processes.add(simple);
        this.m_processes.add(front);
        this.m_processes.add(legal);
        this.m_processes.add(press);
        Task write = new Task("Write");
        write.setAssignee("Authors");
        Task publish = new Task("Publish");
        publish.setAssignee("Publishers");
        simple.addTask(write);
        simple.addTask(publish);
        write = new Task("Write");
        write.setAssignee("Authors");
        Task edit = new Task("Edit");
        edit.setAssignee("Editors");
        Task approve = new Task("Approve");
        approve.setAssignee("Approvers");
        publish = new Task("Publish");
        publish.setAssignee("Publishers");
        front.addTask(write);
        front.addTask(edit);
        front.addTask(approve);
        front.addTask(publish);
        write = new Task("Write");
        write.setAssignee("Authors");
        edit = new Task("Edit");
        edit.setAssignee("Editors");
        approve = new Task("Approve");
        approve.setAssignee("Approvers");
        publish = new Task("Publish");
        publish.setAssignee("Publishers");
        Task review = new Task("Review");
        review.setAssignee("Sharks");
        legal.addTask(write);
        legal.addTask(edit);
        legal.addTask(approve);
        legal.addTask(review);
        legal.addTask(publish);
        approve = new Task("Approve");
        approve.setAssignee("Approvers");
        publish = new Task("Publish");
        publish.setAssignee("Publishers");
        review = new Task("Review");
        review.setAssignee("Sharks");
        press.addTask(approve, false);
        press.addTask(review, false);
        press.addTask(publish);
    }

    public synchronized int size() {
        return this.m_processes.size();
    }

    public synchronized Process get(int i) {
        return (Process)this.m_processes.get(i);
    }

    public synchronized void add(Process p) {
        this.m_processes.add(p);
    }

    public static synchronized Process getProcess(Object key) {
        int i = Integer.parseInt(key.toString());
        return SampleProcesses.getInstance().get(i - 1);
    }

    public static synchronized Task getTask(String key) {
        int i;
        SampleProcesses l = SampleProcesses.getInstance();
        if (key == null) {
            return null;
        }
        for (i = 0; i < l.size(); ++i) {
            Process p = l.get(i);
            for (int j = 0; j < p.taskCount(); ++j) {
                if (!key.equals(p.getTask(j).getKey())) continue;
                return p.getTask(j);
            }
        }
        for (i = 0; i < m_allTasks.size(); ++i) {
            Task t = (Task)m_allTasks.get(i);
            if (!key.equals(t.getKey())) continue;
            return t;
        }
        return null;
    }

    public static synchronized ListModel getAllTasks(PageState s) {
        return new ListModel(){
            private int i = -1;

            public boolean next() throws NoSuchElementException {
                ++this.i;
                return this.i < m_allTasks.size();
            }

            public Object getElement() {
                return m_allTasks.get(this.i);
            }

            public String getKey() {
                return ((Task)m_allTasks.get(this.i)).getKey();
            }
        };
    }

    static {
        Task write = new Task("Write");
        write.setAssignee("Authors");
        Task edit = new Task("Edit");
        edit.setAssignee("Editors");
        Task approve = new Task("Approve");
        approve.setAssignee("Approvers");
        Task publish = new Task("Publish");
        publish.setAssignee("Publishers");
        Task review = new Task("Review");
        review.setAssignee("Sharks");
        m_allTasks = new ArrayList();
        m_allTasks.add(write);
        m_allTasks.add(edit);
        m_allTasks.add(approve);
        m_allTasks.add(publish);
        m_allTasks.add(review);
    }
}

