/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.bebop;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SimpleContainer;
import com.arsdigita.bebop.form.Hidden;
import com.arsdigita.bebop.util.BebopConstants;
import com.arsdigita.util.Assert;
import com.arsdigita.xml.Element;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class GridPanel
extends SimpleContainer
implements BebopConstants {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/bebop/GridPanel.java#8 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private static final ChildConstraint DEFAULT_CONSTRAINT = new ChildConstraint();
    private int m_numColumns;
    private Map m_childConstraintMap;
    private boolean m_isInserted;

    public GridPanel(int numColumns) {
        this(numColumns, false);
    }

    public GridPanel(int numColumns, boolean isInserted) {
        this.m_numColumns = numColumns;
        this.setInserted(isInserted);
        this.m_childConstraintMap = new HashMap();
    }

    public void add(Component component, int constraints) {
        super.add(component);
        this.m_childConstraintMap.put(component, new ChildConstraint(constraints));
    }

    public void setInserted(boolean isInserted) {
        Assert.assertNotLocked(this);
        this.m_isInserted = isInserted;
    }

    public final boolean isInserted() {
        return this.m_isInserted;
    }

    public void generateXML(PageState pageState, Element parent) {
        if (this.isVisible(pageState)) {
            if (this.isInserted()) {
                this.generateChildren(pageState, parent);
            } else {
                Element panel = parent.newChildElement("bebop:gridPanel", "http://www.arsdigita.com/bebop/1.0");
                this.exportAttributes(panel);
                this.generateChildren(pageState, panel);
            }
        }
    }

    private void generateChildren(PageState pageState, Element parent) {
        int positionInRow = 0;
        boolean newRowRequested = true;
        Element row = null;
        Element cell = null;
        ChildConstraint constraint = null;
        Iterator iter = this.children();
        while (iter.hasNext()) {
            Component child = (Component)iter.next();
            if (!child.isVisible(pageState)) continue;
            if (child instanceof Hidden) {
                child.generateXML(pageState, parent);
                continue;
            }
            constraint = this.getChildConstraint(child);
            if (constraint.m_isInsert) {
                child.generateXML(pageState, parent);
                newRowRequested = true;
                continue;
            }
            if (positionInRow >= this.m_numColumns || constraint.m_isFullWidth || newRowRequested) {
                positionInRow = 0;
                row = parent.newChildElement("bebop:panelRow", "http://www.arsdigita.com/bebop/1.0");
                if (constraint.m_isFullWidth) {
                    newRowRequested = true;
                } else if (newRowRequested) {
                    newRowRequested = false;
                }
            }
            cell = row.newChildElement("bebop:cell", "http://www.arsdigita.com/bebop/1.0");
            child.generateXML(pageState, cell);
            constraint.exportCellAttributes(cell, this.m_numColumns);
            ++positionInRow;
        }
    }

    private ChildConstraint getChildConstraint(Component component) {
        ChildConstraint constraint = (ChildConstraint)this.m_childConstraintMap.get(component);
        if (constraint == null) {
            constraint = DEFAULT_CONSTRAINT;
        }
        return constraint;
    }

    private static class ChildConstraint {
        public boolean m_isFullWidth;
        public boolean m_isInsert;
        public String m_horizontalAlignment;
        public String m_verticalAlignment;

        public ChildConstraint() {
            this(0);
        }

        public ChildConstraint(int constraints) {
            this.m_horizontalAlignment = (constraints & 1) != 0 ? "left" : ((constraints & 2) != 0 ? "center" : ((constraints & 4) != 0 ? "right" : null));
            this.m_verticalAlignment = (constraints & 8) != 0 ? "top" : ((constraints & 0x10) != 0 ? "middle" : ((constraints & 0x20) != 0 ? "bottom" : null));
            this.m_isFullWidth = (constraints & 0x40) != 0;
            this.m_isInsert = (constraints & 0x80) != 0;
        }

        public void exportCellAttributes(Element cell, int numColumns) {
            if (this.m_horizontalAlignment != null) {
                cell.addAttribute("align", this.m_horizontalAlignment);
            }
            if (this.m_verticalAlignment != null) {
                cell.addAttribute("valign", this.m_verticalAlignment);
            }
            if (this.m_isFullWidth) {
                cell.addAttribute("colspan", Integer.toString(numColumns));
            }
        }
    }
}

