/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.bebop;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Container;
import com.arsdigita.bebop.FormData;
import com.arsdigita.bebop.FormModel;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.FormSection;
import com.arsdigita.bebop.GridPanel;
import com.arsdigita.bebop.Page;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.RequestLocal;
import com.arsdigita.bebop.form.Hidden;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.bebop.util.BebopConstants;
import com.arsdigita.bebop.util.Traversal;
import com.arsdigita.globalization.GlobalizedMessage;
import com.arsdigita.util.Assert;
import com.arsdigita.util.UncheckedWrapperException;
import com.arsdigita.web.RedirectSignal;
import com.arsdigita.web.URL;
import com.arsdigita.web.Web;
import com.arsdigita.xml.Element;
import java.util.Iterator;
import javax.servlet.ServletException;
import org.apache.log4j.Logger;

public class Form
extends FormSection
implements BebopConstants {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/bebop/Form.java#18 $$Author: dennis $$DateTime: 2004/04/07 16:07:11 $";
    private static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$bebop$Form == null ? (class$com$arsdigita$bebop$Form = Form.class$("com.arsdigita.bebop.Form")) : class$com$arsdigita$bebop$Form));
    public static final String GET = "get";
    public static final String POST = "post";
    private static final String NAME = "name";
    private static final String METHOD = "method";
    private String m_action;
    private boolean m_processInvisible;
    private RequestLocal m_formData;
    private boolean m_isRedirecting = false;
    static /* synthetic */ Class class$com$arsdigita$bebop$Form;

    public Form(String name) {
        this(name, new GridPanel(2));
    }

    public Form(String name, Container panel) {
        super(panel, new FormModel(name));
        this.initFormData();
        this.setName(name);
        this.setProcessInvisible(false);
        this.addMagicTag();
    }

    public void generateXML(PageState s, Element parent) {
        if (this.isVisible(s)) {
            Element form = this.generateXMLSansState(s, parent);
            s.setControlEvent(this);
            s.generateXML(form, this.getModel().getParametersToExclude());
            s.clearControlEvent();
        }
    }

    protected Element generateXMLSansState(PageState s, Element parent) {
        URL requestURL;
        Element form = parent.newChildElement("bebop:form", "http://www.arsdigita.com/bebop/1.0");
        String url = null;
        url = this.m_action == null ? ((requestURL = Web.getContext().getRequestURL()) == null ? s.getRequest().getRequestURI() : requestURL.getRequestURI()) : this.m_action;
        form.addAttribute("action", s.getResponse().encodeURL(url));
        this.exportAttributes(form);
        this.m_panel.generateXML(s, form);
        this.generateErrors(s, form);
        return form;
    }

    protected void generateErrors(PageState ps, Element parent) {
        Iterator it = this.getFormData(ps).getErrors();
        while (it.hasNext()) {
            Element errors = parent.newChildElement("bebop:formErrors", "http://www.arsdigita.com/bebop/1.0");
            errors.addAttribute("message", (String)((GlobalizedMessage)it.next()).localize(ps.getRequest()));
            errors.addAttribute("id", this.getName());
        }
    }

    public boolean isRedirecting() {
        return this.m_isRedirecting;
    }

    public void setRedirecting(boolean isRedirecting) {
        Assert.assertNotLocked(this);
        this.m_isRedirecting = isRedirecting;
    }

    public void respond(PageState state) throws ServletException {
        FormData data = this.process(state);
        if (this.m_isRedirecting && data.isValid()) {
            state.clearControlEvent();
            throw new RedirectSignal(state.toURL(), true);
        }
    }

    public void setName(String name) {
        Assert.assertNotLocked(this);
        this.setAttribute(NAME, name);
    }

    public String getName() {
        return this.getAttribute(NAME);
    }

    public void setEncType(String encType) {
        Assert.assertNotLocked(this);
        this.setAttribute("enctype", encType);
    }

    public void setOnSubmit(String javascriptCode) {
        Assert.assertNotLocked(this);
        this.setAttribute("onSubmit", javascriptCode);
    }

    public void setOnReset(String javascriptCode) {
        Assert.assertNotLocked(this);
        this.setAttribute("onReset", javascriptCode);
    }

    public void setMethod(String method) {
        Assert.assertNotLocked(this);
        this.setAttribute(METHOD, method);
    }

    private String getMethod() {
        return this.getAttribute(METHOD);
    }

    protected boolean getProcessInvisible() {
        return this.m_processInvisible;
    }

    protected void setProcessInvisible(boolean processInvisible) {
        this.m_processInvisible = processInvisible;
    }

    public void setAction(String action) {
        Assert.assertNotLocked(this);
        this.m_action = action;
    }

    public final String getAction() {
        return this.m_action;
    }

    public FormData process(PageState state) throws FormProcessException {
        Assert.assertNotNull(state, "PageState");
        FormData result = new FormData(this.getModel(), state.getRequest());
        this.setFormData(state, result);
        if (this.getProcessInvisible() || state.isVisibleOnPage(this)) {
            this.getModel().process(state, result);
        }
        return result;
    }

    public FormData getFormData(PageState state) {
        return (FormData)this.m_formData.get(state);
    }

    protected void addMagicTag() {
        Hidden h = new Hidden(this.getModel().getMagicTagName());
        h.setDefaultValue("visited");
        this.add(h);
    }

    protected void traverse() {
        Traversal formRegistrar = new Traversal(){

            protected void act(Component c) {
                if (c == Form.this) {
                    return;
                }
                if (c instanceof Form) {
                    throw new IllegalStateException("Forms cannot contain other Forms");
                }
                c.register(Form.this, Form.this.getModel());
            }
        };
        formRegistrar.preorder(this);
    }

    public void register(Page p) {
        this.traverse();
        p.addComponent(this);
    }

    public void excludeParameterFromExport(ParameterModel model) {
        this.getModel().excludeFormParameterFromExport(model);
    }

    private void initFormData() {
        this.m_formData = new RequestLocal(){

            protected Object initialValue(PageState s) {
                try {
                    return Form.this.process(s);
                }
                catch (FormProcessException e) {
                    s_log.error((Object)"Form Process exception", (Throwable)((Object)e));
                    throw new UncheckedWrapperException("Form Process error: " + e.getMessage(), (Throwable)((Object)e));
                }
            }
        };
    }

    public String toString() {
        return super.toString() + " " + "[" + this.getName() + "," + this.getAction() + "," + this.getMethod() + "," + this.isRedirecting() + "]";
    }

    protected void setFormData(PageState state, FormData data) {
        this.m_formData.set(state, (Object)data);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

