/*
 * Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.xmlutil;

import com.arsdigita.kernel.TestHelper;
import com.arsdigita.tools.junit.framework.BaseTestCase;
import org.jdom.Document;

public abstract class XMLTestCase extends BaseTestCase {

    public XMLTestCase(String name) {
        super(name);
    }
    /**
     * Runs an XML test and reports any failures.
     *
     * @param factory The test specific JDOMFactory to use.
     * @param testFile The xml file that defines the test. It is expected to reside
     *      in the test source directory. File name should be given as
     *      com/arsdigita/whatever/Test.xml
     * @param validateDoc If true, XML validation will be turned on for the document import.
     */
    protected void executeXMLTest(TestJDOMFactory factory, String testFile, final boolean validateDoc) throws Exception {
        DocImporter importer = new DocImporter(validateDoc);
        importer.setJDOMFactory(factory);

       // String fullPath = System.getProperty("user.dir") + "/test/src/" + testFile;
        String fullPath = System.getProperty("test.base.dir") + "/" + testFile;
        Document tests = importer.getDocumentAsFile(fullPath);
        TestSet set = (TestSet) tests.getRootElement();
        try {
            set.runTests();

        } finally {
            ResourceRegistry.instance().cleanResources();
        }


    }

}
