/*
 * Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.versioning;

import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.persistence.TestTransaction;
import com.arsdigita.tools.junit.framework.BaseTestCase;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

/**
 * This reproduces the issues reported by Mike Bonnet in
 * https://bugzilla.redhat.com/bugzilla/show_bug.cgi?id=101280
 *
 * <p>This has to live in a separate test file.  If we put in the
 * VersioningEventProcessorTest, some other test would run first and initialize
 * the Event types data objects, thus defeating the purpose of this test. </p>
 *
 * @author  Vadim Nasardinov (vadimn@redhat.com)
 * @since   2003-07-30
 * @version $Revision: #6 $ $Date: 2004/04/07 $
 **/
public class ReentranceTest extends BaseTestCase implements Const {
    // the test does not really fail, but it increases the overall execution of
    // the suite by 3 min on my machine, so I disabled it.
    public final static boolean FAILS = true;

    public ReentranceTest(String name) {
        super(name);
    }

    /**
     * This simply tests whether or not the versioning event processor gets
     * overwhelmed by a long queue of events.
     **/
    public void testGazillionVersionedObjects() {
        final int nObjects = 1000;
        List refs = new ArrayList(nObjects);
        for (int ii=0; ii<nObjects; ii++) {
            DataObject vt1 = Util.newDataObject(VT1);
            vt1.set(NAME, "vt1 " + ii);
            vt1.set(CONTENT, "vt1 content " + ii);
            vt1.set(INT_ATTR, new BigInteger(String.valueOf(ii)));
            // Prevent vt1 from being GC-ed before the loop finishes just in
            // case.
            refs.add(vt1);
        }
        TestTransaction.testCommitTxn
            (SessionManager.getSession().getTransactionContext());
    }
}
