/*
 * Copyright (C) 2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.runtime;

import com.arsdigita.persistence.*;
import com.arsdigita.persistence.metadata.MetadataRoot;
import com.arsdigita.util.Assert;
import junit.framework.*;

public class StartupTest extends TestCase {

    public static final String versionId = "$Id: //core-platform/dev/test/src/com/arsdigita/runtime/StartupTest.java#3 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    public StartupTest(String name) {
        super(name);
    }

    public static void testHasRun() {
        final String key = "test";
        String url = RuntimeConfig.getConfig().getJDBCURL();
        final MetadataRoot root = MetadataRoot.getMetadataRoot();
        SessionManager.configure(key, root, new DedicatedConnectionSource(url));
        final Session session = SessionManager.getSession(key);

        Startup.run(session, new Initializer() {
                public void init(DataInitEvent e) { }
                public void init (DomainInitEvent e) {
                    // Must be true, because of the session that this initializer is
                    // running in.
                    assertTrue(Startup.hasRun());
                }
                public void init(LegacyInitEvent e) { }
            });

    }
}
