/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.kernel;

import com.arsdigita.db.Sequences;

import com.arsdigita.tools.junit.framework.BaseTestCase;
import junit.framework.Test;
import junit.framework.TestSuite;

import java.sql.SQLException;

/**
 * Tests that we can create and modify lots of users without running
 * out of memory.
 *
 *
 * @author Michael Bryzek
 * @version 1.0
 **/
public class UserMassTest extends BaseTestCase {

    public static final boolean FAILS = true;

    public static final String versionId = "$Id: //core-platform/dev/test/src/com/arsdigita/kernel/UserMassTest.java#8 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    private static final int NUMBER_TO_TEST = 25000;
    private static final int NUMBER_TO_REPORT = 500;

    /**
     * Constructs a UserMassTest with the specified name.
     *
     * @param name Test case name.
     **/
    public UserMassTest( String name ) {
        super( name );
    }

    /**
     * Creates a user with a default email address
     **/
    public static User createUser(String givenName,
                                  String familyName) {
        return createUser(givenName, familyName, null);
    }


    /**
     * Creates a user with specified names and email.
     **/
    public static User createUser(String givenName,
                                  String familyName,
                                  String email) {
        if (email == null) {
            try {
                email = "user-mass-test-" +
                    Sequences.getNextValue() +
                    "@arsdigita.com";
            } catch (SQLException e) {
                e.printStackTrace(System.err);
                fail("Could not generate a unique email address");
            }
        }
        User user = new User();
        user.setPrimaryEmail( new EmailAddress(email) );
        user.getPersonName().setGivenName(givenName);
        user.getPersonName().setFamilyName(familyName);
        user.setScreenName("Random screen name for " + givenName);
        return user;
    }


    public void testMassCreateAndUpdate() {
        String givenName = "Michael";
        String familyName = "Bryzek";
        for ( int i = 1; i <= NUMBER_TO_TEST; i++ ) {
            if ( i % NUMBER_TO_REPORT == 0 ) {
                System.err.println("Creating user: " + i);
            }
            createUser(givenName + i, familyName + i).save();
        }

        UserCollection allUsers = User.retrieveAll();
        int ctr = 0;
        while (allUsers.next()) {
            ctr++;
            if ( ctr % NUMBER_TO_REPORT == 0 ) {
                System.err.println("Updating user: " + ctr);
            }
            User user = allUsers.getUser();
            String oldEmail = user.getPrimaryEmail().toString();
            user.setPrimaryEmail( new EmailAddress( oldEmail + "-" + ctr ) );
            user.setScreenName(user.getScreenName() + "-" + ctr);
            user.save();
        }

    }

    public static Test suite() {
        return new TestSuite(UserMassTest.class);
    }

    public static void main(String args[]) {
        junit.textui.TestRunner.run(suite());
    }
}
