/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.kernel;

import com.arsdigita.persistence.OID;

import com.arsdigita.tools.junit.framework.BaseTestCase;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.log4j.Logger;
import java.sql.*;
import java.util.List;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.math.BigDecimal;
import java.util.Set;
import java.util.HashSet;

import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.persistence.metadata.MetadataRoot;
import com.arsdigita.persistence.Session;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.domain.DomainService;
import com.arsdigita.persistence.pdl.*;
import com.arsdigita.db.Sequences;

/**
 * Tests basic functionality of kernel classes
 *
 *
 * @author Oumi Mehrotra
 * @version 1.0
 * @see com.arsdigita.kernel
 */


public class URLServiceTest extends BaseTestCase {

    public static final String versionId = "$Id: //core-platform/dev/test/src/com/arsdigita/kernel/URLServiceTest.java#8 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    public final static String id = "$Id: //core-platform/dev/test/src/com/arsdigita/kernel/URLServiceTest.java#8 $";

    private static Logger s_log =
        Logger.getLogger( URLServiceTest.class.getName() );

    private static boolean s_dataLoaded = false;

    private static ExampleForum s_forum;
    private static SiteNode s_bboardNode;
    private static Session m_ssn;


    // NOTE: s_loadedPDLResources and load() should be moved into a seperate
    // class (e.g. KernelTestCase) if other kernel tests need to load
    // PDL files on the fly.  These were copied from PersistenceTestCase.java.

    // Prevent loading the same PDL file twice
    private static Set s_loadedPDLResources = new HashSet();
    protected static void load(String resource) {
        if (s_loadedPDLResources.contains(resource)) {
            return;
        }
        try {
            PDL m = new PDL();
            m.loadResource(resource);
            m.generateMetadata(MetadataRoot.getMetadataRoot());
        } catch (Exception e) {
            e.printStackTrace();
            throw new Error(e.getMessage());
        }
        s_loadedPDLResources.add(resource);
    }

    protected void setUp() throws Exception {
        load("com/arsdigita/kernel/examples/URLServiceExample.pdl");
        URLService.registerFinder("examples.Forum",
                                  new GenericURLFinder("index?forum_id=:id"));
        URLService.registerFinder("examples.Message",
                                  new GenericURLFinder("message?message_id=:id"));
        URLService.registerFinder("PackageInstance.BASE_DATA_OBJECT_TYPE",
                                  new GenericURLFinder(""));
        m_ssn = SessionManager.getSession();
        if (!s_dataLoaded) {
            loadData();
            s_dataLoaded=true;
        }
        super.setUp();
    }

    void loadData() throws Exception {
        PackageType bboardApp = new PackageType();
        bboardApp.setKey("__test-bboard");
        bboardApp.setPrettyName("__Test Bboard Application");
        bboardApp.setPrettyName("__Test Bboard Applications");
        bboardApp.setURI("http://www.junit.org/");
        bboardApp.save();

        PackageInstance bboardInstance =
            bboardApp.createInstance("Test Bboard Instance");

        s_bboardNode = SiteNode.createSiteNode("test-bboard");
        s_bboardNode.mountPackage(bboardInstance);
        s_bboardNode.save();

        s_forum = createForum(bboardInstance, "Test Forum");
    }

    private ExampleForum createForum(PackageInstance pkgInst, String name)
        throws Exception
    {
        ExampleForum forum = new ExampleForum();
        forum.setPackageInstance(pkgInst);
        forum.setDisplayName(name);
        forum.save();
        return forum;
    }

    private ExampleMessage createMessage(ExampleForum forum, String subject)
        throws Exception
    {
        ExampleMessage message = new ExampleMessage();
        message.setForum(forum);
        message.setSubject(subject);
        message.setBody(subject);
        message.save();
        return message;
    }

    /**
     * Constructs a UserTest with the specified name.
     *
     * @param name Test case name.
     **/
    public URLServiceTest( String name ) {
        super( name );
    }

    private String getBboardURL() {
        return s_bboardNode.getURL();
    }

    public void testGenericFinder() throws Exception {

        ExampleMessage message = createMessage(s_forum, "test subject 1");

        String url = URLService.locate(message.getOID());
        String targetURL = getBboardURL() +
            "message?message_id=" + message.getID();
        assertEquals("Incorrect URL from URLService", targetURL, url);
        s_log.info(url);

        url = URLService.locate(s_forum.getOID());
        targetURL = getBboardURL() + "index?forum_id=" + s_forum.getID();
        assertEquals("Incorrect URL from URLService", targetURL, url);
        s_log.info(url);

        url = URLService.locate(s_bboardNode.getPackageInstance().getOID());
        targetURL = getBboardURL();
        assertEquals("Incorrect URL from URLService", targetURL, url);
        s_log.info(url);
    }

}
