/*
 * Copyright (C) 2002-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.kernel;

import java.util.Locale;

/**
 * Provides access to protected kernel facilities for tests outside the kernel package.
 */
public class TestHelper {

    public static Party setCurrentSystemParty(Party newParty) {
        KernelContext ctx = Kernel.getContext();
        Party oldParty = ctx.getParty();
        ctx.setParty(newParty);
        return oldParty;
    }

    public static Locale setLocale(Locale newLocale) {
        KernelContext ctx = Kernel.getContext();
        Locale oldLocale = ctx.getLocale();
        ctx.setLocale(newLocale);
        return oldLocale;
    }

}
