/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.kernel;

import junit.framework.*;

import com.arsdigita.domain.DomainObject;
import com.arsdigita.domain.DomainCollection;

/**
 * Test to illustrate a problem discovered with changing group
 * memberships.
 *
 * @author Kevin Scaldeferri
 */


public class GroupMembershipTest
    extends com.arsdigita.tools.junit.framework.BaseTestCase {

    public static final String versionId = "$Id: //core-platform/dev/test/src/com/arsdigita/kernel/GroupMembershipTest.java#8 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    private Group theGroup;
    private User user1;
    private User user2;

    public GroupMembershipTest(String name) {
        super(name);
    }

    public static void main(String args[]) {
        junit.textui.TestRunner.run(GroupMembershipTest.class);
    }

    protected void setUp() {
        theGroup = new Group();
        theGroup.setName("testMemberhipChange");
        theGroup.save();

        user1 = new User("Foo", "Bar", "user1@foo.com");
        user1.save();

        user2 = new User("Foo", "Bar", "user2@foo.com");
        user2.save();

    }

    /*
     * Group doesn't define an isMember() method currently, so
     * I have to fake something
     */
    private static Boolean isMember(Group group, User user) {
        UserCollection uc = group.getAllMemberUsers();
        Boolean retValue = Boolean.FALSE;
        while (uc.next()) {
            User testUser = uc.getUser();
            if (testUser.equals(user)) {
                retValue = Boolean.TRUE;
                uc.close();
                break;
            }
        }

        return retValue;
    }

    public void testMembershipChange() {
        theGroup.addMember(user1);
        theGroup.save();

        assertTrue("User 1 didn't pass the test",
                   isMember(theGroup, user1).booleanValue());

        assertTrue("User 2 did pass the test, but shouldn't have",
                   ! isMember(theGroup, user2).booleanValue());

        assertEquals(1, theGroup.getAllMemberUsers().size());

        theGroup.addMember(user2);
        theGroup.save();

        assertEquals(2, theGroup.getAllMemberUsers().size());
        assertTrue("User 1 didn't pass the second test",
                   isMember(theGroup, user2).booleanValue());
        assertTrue("User 2 didn't pass the second test",
                   isMember(theGroup, user2).booleanValue());
    }

    public void testDuplicateAddAndSave() {
        theGroup.addMember(user1);
        theGroup.save();
        theGroup.addMember(user1);
        theGroup.save();
    }

    public void testDuplicateAddAndRemove() {
        theGroup.addMember(user1);
        theGroup.addMember(user1);
        theGroup.save();

        assertTrue("User 1 wasn't a member after being added",
                   isMember(theGroup, user1).booleanValue());

        assertEquals(1, theGroup.getAllMemberUsers().size());

        theGroup.removeMember(user1);
        theGroup.save();

        assertTrue("User 1 was a member after being removed",
                   ! isMember(theGroup, user1).booleanValue());

        assertEquals(0, theGroup.getAllMemberUsers().size());
    }


    public void testContainedParties() {
        theGroup.addMember(user1);
        theGroup.save();
        
        DomainCollection parties = theGroup.getContainedParties();
        assertTrue("There is at least one contained party", 
                   parties.next());
        DomainObject party = parties.getDomainObject();
        assertTrue("The contained party is user1",
                   party.equals(user1));
        
        assertTrue("There is not a second contained party",
                   !parties.next());
    }
}
